/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.context;

import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.PrepareCache;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.context.BaseContext;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.impl.TransactionSaver;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.export.ExceptionFactory;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.ClientMessage;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.client.RedoableClientMessage;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.server.InitialHandshakePacket;

public class RedoContext
extends BaseContext {
    private final TransactionSaver transactionSaver;

    public RedoContext(InitialHandshakePacket handshake2, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache) {
        super(handshake2, clientCapabilities, conf, exceptionFactory, prepareCache);
        this.transactionSaver = new TransactionSaver(conf.transactionReplaySize());
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
        if ((serverStatus & 1) == 0) {
            this.transactionSaver.clear();
        }
    }

    public void saveRedo(ClientMessage msg) {
        if (msg instanceof RedoableClientMessage) {
            RedoableClientMessage redoMsg = (RedoableClientMessage)msg;
            redoMsg.saveParameters();
            this.transactionSaver.add(redoMsg);
        }
    }

    public void saveRedo(ClientMessage[] msgs) {
        for (ClientMessage msg : msgs) {
            this.saveRedo(msg);
        }
    }

    public TransactionSaver getTransactionSaver() {
        return this.transactionSaver;
    }
}

