/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.Context;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.socket.Writer;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.Codec;

public class BooleanCodec
implements Codec<Boolean> {
    public static final BooleanCodec INSTANCE = new BooleanCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, new DataType[]{DataType.VARSTRING, DataType.STRING, DataType.BIGINT, DataType.INTEGER, DataType.MEDIUMINT, DataType.SMALLINT, DataType.YEAR, DataType.TINYINT, DataType.DECIMAL, DataType.OLDDECIMAL, DataType.FLOAT, DataType.DOUBLE, DataType.BIT, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Boolean.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Boolean.TYPE || type.isAssignableFrom(Boolean.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public Boolean decodeText(ReadableByteBuf buffer, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeBooleanText(buffer, length);
    }

    @Override
    public Boolean decodeBinary(ReadableByteBuf buffer, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeBooleanBinary(buffer, length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeAscii((Boolean)value != false ? "1" : "0");
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeByte((Boolean)value != false ? 1 : 0);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TINYINT.get();
    }
}

