/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.Context;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.socket.Writer;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.Codec;

public class TimeCodec
implements Codec<Time> {
    public static final TimeCodec INSTANCE = new TimeCodec();
    public static final LocalDate EPOCH_DATE = LocalDate.of(1970, 1, 1);
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TIME, new DataType[]{DataType.DATETIME, DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Time.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Time.class) && !type.equals(Date.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Time;
    }

    @Override
    public Time decodeText(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeTimeText(buf, length, cal);
    }

    @Override
    public Time decodeBinary(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar calParam) throws SQLDataException {
        return column.decodeTimeBinary(buf, length, calParam);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar providedCal, Long maxLength) throws IOException {
        Calendar cal;
        Calendar calendar = cal = providedCal == null ? Calendar.getInstance() : providedCal;
        synchronized (calendar) {
            cal.clear();
            cal.setTime((Time)value);
            cal.set(5, 1);
            if (cal.get(14) > 0) {
                encoder.writeByte(12);
                encoder.writeByte(0);
                encoder.writeInt(0);
                encoder.writeByte((byte)cal.get(11));
                encoder.writeByte((byte)cal.get(12));
                encoder.writeByte((byte)cal.get(13));
                encoder.writeInt(cal.get(14) * 1000);
            } else {
                encoder.writeByte(8);
                encoder.writeByte(0);
                encoder.writeInt(0);
                encoder.writeByte((byte)cal.get(11));
                encoder.writeByte((byte)cal.get(12));
                encoder.writeByte((byte)cal.get(13));
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TIME.get();
    }
}

