/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.UUID;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.Context;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.socket.Writer;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.Codec;

public class UuidCodec
implements Codec<UUID> {
    public static final UuidCodec INSTANCE = new UuidCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, DataType.VARSTRING, DataType.STRING);

    @Override
    public String className() {
        return UUID.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(UUID.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof UUID;
    }

    @Override
    public UUID decodeText(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return UUID.fromString(column.decodeStringText(buf, length, cal));
    }

    @Override
    public UUID decodeBinary(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return UUID.fromString(column.decodeStringBinary(buf, length, cal));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeByte(39);
        encoder.writeAscii(value.toString());
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer writer, Object value, Calendar cal, Long maxLength) throws IOException {
        String valueSt = value.toString();
        writer.writeLength(valueSt.length());
        writer.writeAscii(valueSt);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARSTRING.get();
    }
}

