/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.credential.aws;

import java.util.Properties;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.HostAddress;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.Credential;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.amazon.awssdk.services.rds.model.GenerateAuthenticationTokenRequest;

public class AwsCredentialGenerator {
    private final String authenticationToken;
    private final String userName;

    public AwsCredentialGenerator(Properties nonMappedOptions, String userName, HostAddress hostAddress) {
        this.userName = userName;
        String accessKeyId = nonMappedOptions.getProperty("accessKeyId");
        String secretKey = nonMappedOptions.getProperty("secretKey");
        String region = nonMappedOptions.getProperty("region");
        Object awsCredentialsProvider = accessKeyId != null && secretKey != null ? StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretKey)) : DefaultCredentialsProvider.builder().build();
        RdsUtilities utilities = RdsUtilities.builder().credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider).region(region != null ? Region.of((String)region) : new DefaultAwsRegionProviderChain().getRegion()).build();
        this.authenticationToken = utilities.generateAuthenticationToken(arg_0 -> AwsCredentialGenerator.lambda$new$0(userName, hostAddress, (AwsCredentialsProvider)awsCredentialsProvider, arg_0));
    }

    public Credential getToken() {
        return new Credential(this.userName, this.authenticationToken);
    }

    private static /* synthetic */ void lambda$new$0(String userName, HostAddress hostAddress, AwsCredentialsProvider awsCredentialsProvider, GenerateAuthenticationTokenRequest.Builder builder) {
        builder.username(userName).hostname(hostAddress.host).port(hostAddress.port).credentialsProvider(awsCredentialsProvider);
    }
}

