/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.spongepowered.configurate.objectmapping;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.serialize.SerializationException;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RecordFieldDiscoverer
implements FieldDiscoverer<Object[]> {
    static final RecordFieldDiscoverer INSTANCE = new RecordFieldDiscoverer();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final @Nullable MethodHandle CLASS_IS_RECORD;
    private static final @Nullable MethodHandle CLASS_GET_RECORD_COMPONENTS;
    private static final @Nullable MethodHandle RECORD_COMPONENT_GET_ANNOTATED_TYPE;
    private static final @Nullable MethodHandle RECORD_COMPONENT_GET_NAME;
    private static final @Nullable MethodHandle RECORD_COMPONENT_GET_ACCESSOR;

    private RecordFieldDiscoverer() {
    }

    @Override
    public <V> @Nullable FieldDiscoverer.InstanceFactory<@Nullable Object[]> discover(AnnotatedType target, FieldDiscoverer.FieldCollector<@Nullable Object[], V> collector) throws SerializationException {
        if (CLASS_IS_RECORD != null && CLASS_GET_RECORD_COMPONENTS != null && RECORD_COMPONENT_GET_ANNOTATED_TYPE != null && RECORD_COMPONENT_GET_NAME != null && RECORD_COMPONENT_GET_ACCESSOR != null) {
            Class clazz = GenericTypeReflector.erase((Type)target.getType());
            try {
                if (CLASS_IS_RECORD.invoke(clazz)) {
                    AnnotatedElement[] recordComponents = CLASS_GET_RECORD_COMPONENTS.invoke(clazz);
                    Class[] constructorParams = new Class[recordComponents.length];
                    int i = 0;
                    int recordComponentsLength = recordComponents.length;
                    while (i < recordComponentsLength) {
                        AnnotatedElement component = recordComponents[i];
                        Method accessor = RECORD_COMPONENT_GET_ACCESSOR.invoke(component);
                        accessor.setAccessible(true);
                        String name = RECORD_COMPONENT_GET_NAME.invoke(component);
                        AnnotatedType genericType = RECORD_COMPONENT_GET_ANNOTATED_TYPE.invoke(component);
                        constructorParams[i] = GenericTypeReflector.erase((Type)genericType.getType());
                        Field backingField = clazz.getDeclaredField(name);
                        backingField.setAccessible(true);
                        AnnotatedType resolvedType = GenericTypeReflector.resolveExactType((AnnotatedType)genericType, (AnnotatedType)target);
                        AnnotatedElement annotationContainer = Types.combinedAnnotations(component, backingField, accessor);
                        int targetIdx = i++;
                        collector.accept(name, resolvedType, annotationContainer, (intermediate, el, implicitSupplier) -> {
                            intermediate[targetIdx] = el != null ? el : implicitSupplier.get();
                        }, x$0 -> accessor.invoke(x$0, new Object[0]));
                    }
                    Constructor clazzConstructor = clazz.getDeclaredConstructor(constructorParams);
                    clazzConstructor.setAccessible(true);
                    return new FieldDiscoverer.InstanceFactory<Object[]>(){

                        @Override
                        public Object[] begin() {
                            return new Object[recordComponents.length];
                        }

                        @Override
                        public Object complete(@Nullable Object[] intermediate) throws SerializationException {
                            int length = intermediate.length;
                            for (int i = 0; i < length; ++i) {
                                if (intermediate[i] != null || !constructorParams[i].isPrimitive()) continue;
                                intermediate[i] = Types.defaultValue(constructorParams[i]);
                            }
                            try {
                                return clazzConstructor.newInstance(intermediate);
                            }
                            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                throw new SerializationException(target.getType(), (Throwable)e);
                            }
                        }

                        @Override
                        public boolean canCreateInstances() {
                            return true;
                        }
                    };
                }
            }
            catch (SerializationException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        @Nullable MethodHandle classIsRecord = null;
        @Nullable MethodHandle classGetRecordComponents = null;
        @Nullable MethodHandle recordComponentGetAnnotatedType = null;
        @Nullable MethodHandle recordComponentGetName = null;
        MethodHandle recordComponentGetAccessor = null;
        try {
            classIsRecord = LOOKUP.findVirtual(Class.class, "isRecord", MethodType.methodType(Boolean.TYPE));
            Class<?> recordComponent = Class.forName("java.lang.reflect.RecordComponent");
            Class<?> recordComponentArray = Array.newInstance(recordComponent, 0).getClass();
            classGetRecordComponents = LOOKUP.findVirtual(Class.class, "getRecordComponents", MethodType.methodType(recordComponentArray));
            recordComponentGetAnnotatedType = LOOKUP.findVirtual(recordComponent, "getAnnotatedType", MethodType.methodType(AnnotatedType.class));
            recordComponentGetAccessor = LOOKUP.findVirtual(recordComponent, "getAccessor", MethodType.methodType(Method.class));
            recordComponentGetName = LOOKUP.findVirtual(recordComponent, "getName", MethodType.methodType(String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CLASS_IS_RECORD = classIsRecord;
        CLASS_GET_RECORD_COMPONENTS = classGetRecordComponents;
        RECORD_COMPONENT_GET_ANNOTATED_TYPE = recordComponentGetAnnotatedType;
        RECORD_COMPONENT_GET_NAME = recordComponentGetName;
        RECORD_COMPONENT_GET_ACCESSOR = recordComponentGetAccessor;
    }
}

