/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.impactdev.json.JElement;

public class JObject
implements JElement {
    private final JsonObject delegate;

    public JObject() {
        this.delegate = new JsonObject();
    }

    private JObject(JsonObject source2) {
        this.delegate = source2;
    }

    public static JObject from(JsonObject source2) {
        return new JObject(source2);
    }

    public JsonObject toJson() {
        return this.delegate;
    }

    public JObject add(String key, JsonElement value) {
        this.delegate.add(key, value);
        return this;
    }

    public JObject add(String key, String value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, (JsonElement)new JsonPrimitive(value));
    }

    public JObject add(String key, Number value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, (JsonElement)new JsonPrimitive(value));
    }

    public JObject add(String key, Boolean value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, (JsonElement)new JsonPrimitive(value));
    }

    public JObject add(String key, JElement value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, value.toJson());
    }

    public JObject add(String key, Supplier<? extends JElement> value) {
        return this.add(key, value.get().toJson());
    }

    public JObject consume(Consumer<? super JObject> consumer) {
        consumer.accept(this);
        return this;
    }
}

