/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.ChunkSerializer;
import de.johni0702.minecraft.bobby.FakeChunkStorage;
import de.johni0702.minecraft.bobby.VisibleChunksTracker;
import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import de.johni0702.minecraft.bobby.ext.LightingProviderExt;
import de.johni0702.minecraft.bobby.mixin.BiomeAccessAccessor;
import de.johni0702.minecraft.bobby.mixin.ClientWorldAccessor;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2487;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_631;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.Pair;

public class FakeChunkManager {
    private static final String FALLBACK_LEVEL_NAME = "bobby-fallback";
    private static final class_310 client = class_310.method_1551();
    private final class_638 world;
    private final class_631 clientChunkManager;
    private final ClientChunkManagerExt clientChunkManagerExt;
    private final FakeChunkStorage storage;
    private final List<FakeChunkStorage> storages;
    private int ticksSinceLastSave;
    private final Long2ObjectMap<class_2818> fakeChunks = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final VisibleChunksTracker chunkTracker = new VisibleChunksTracker();
    private final Long2LongMap toBeUnloaded = new Long2LongOpenHashMap();
    private final Deque<Pair<Long, Long>> unloadQueue = new ArrayDeque<Pair<Long, Long>>();
    private static final ExecutorService loadExecutor = Executors.newFixedThreadPool(8, (ThreadFactory)new DefaultThreadFactory("bobby-loading", true));
    private final Long2ObjectMap<LoadingJob> loadingJobs = new Long2ObjectLinkedOpenHashMap();
    private static final ExecutorService saveExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("bobby-saving", true));

    public FakeChunkManager(class_638 world, class_631 clientChunkManager) {
        this.world = world;
        this.clientChunkManager = clientChunkManager;
        this.clientChunkManagerExt = (ClientChunkManagerExt)clientChunkManager;
        long seedHash = ((BiomeAccessAccessor)world.method_22385()).getSeed();
        class_5321 worldKey = world.method_27983();
        class_2960 worldId = worldKey.method_29177();
        Path storagePath = FakeChunkManager.client.field_1697.toPath().resolve(".bobby").resolve(FakeChunkManager.getCurrentWorldOrServerName(((ClientWorldAccessor)world).getNetworkHandler())).resolve("" + seedHash).resolve(worldId.method_12836()).resolve(worldId.method_12832());
        this.storage = FakeChunkStorage.getFor(storagePath, true);
        FakeChunkStorage fallbackStorage = null;
        class_32 levelStorage = client.method_1586();
        if (levelStorage.method_230(FALLBACK_LEVEL_NAME)) {
            try (class_32.class_5143 session = levelStorage.method_52236(FALLBACK_LEVEL_NAME);){
                Path worldDirectory = session.method_27424(worldKey);
                Path regionDirectory = worldDirectory.resolve("region");
                fallbackStorage = FakeChunkStorage.getFor(regionDirectory, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.storages = fallbackStorage == null ? List.of(this.storage) : List.of(this.storage, fallbackStorage);
    }

    public class_2818 getChunk(int x, int z) {
        return (class_2818)this.fakeChunks.get(class_1923.method_8331((int)x, (int)z));
    }

    public FakeChunkStorage getStorage() {
        return this.storage;
    }

    public void update(boolean blocking, BooleanSupplier shouldKeepTicking) {
        this.update(blocking, shouldKeepTicking, (Integer)FakeChunkManager.client.field_1690.method_42503().method_41753());
    }

    private void update(boolean blocking, BooleanSupplier shouldKeepTicking, int newViewDistance) {
        Pair<Long, Long> next;
        class_746 player;
        if (++this.ticksSinceLastSave > 1200) {
            class_156.method_27958().execute(() -> ((FakeChunkStorage)this.storage).method_23697());
            this.ticksSinceLastSave = 0;
        }
        if ((player = FakeChunkManager.client.field_1724) == null) {
            return;
        }
        BobbyConfig config = Bobby.getInstance().getConfig();
        long time = class_156.method_658();
        ArrayList<LoadingJob> newJobs = new ArrayList<LoadingJob>();
        class_1923 playerChunkPos = player.method_31476();
        int newCenterX = playerChunkPos.field_9181;
        int newCenterZ = playerChunkPos.field_9180;
        this.chunkTracker.update(newCenterX, newCenterZ, newViewDistance, chunkPos -> {
            this.cancelLoad(chunkPos);
            this.toBeUnloaded.put(chunkPos, time);
            this.unloadQueue.add((Pair<Long, Long>)Pair.of((Object)chunkPos, (Object)time));
        }, chunkPos -> {
            int x = class_1923.method_8325((long)chunkPos);
            int z = class_1923.method_8332((long)chunkPos);
            this.toBeUnloaded.remove(chunkPos);
            if (this.clientChunkManager.method_2857(x, z, class_2806.field_12803, false) != null) {
                return;
            }
            int distanceX = Math.abs(x - newCenterX);
            int distanceZ = Math.abs(z - newCenterZ);
            int distanceSquared = distanceX * distanceX + distanceZ * distanceZ;
            newJobs.add(new LoadingJob(x, z, distanceSquared));
        });
        if (!newJobs.isEmpty()) {
            newJobs.sort(LoadingJob.BY_DISTANCE);
            newJobs.forEach(job -> {
                this.loadingJobs.put(class_1923.method_8331((int)job.x, (int)job.z), job);
                loadExecutor.execute((Runnable)job);
            });
        }
        long unloadTime = time - (long)config.getUnloadDelaySecs() * 1000L;
        int countSinceLastThrottleCheck = 0;
        while ((next = this.unloadQueue.pollFirst()) != null) {
            long chunkPos2 = (Long)next.getLeft();
            long queuedTime = (Long)next.getRight();
            if (queuedTime > unloadTime) {
                this.unloadQueue.addFirst(next);
                break;
            }
            long actualQueuedTime = this.toBeUnloaded.remove(chunkPos2);
            if (actualQueuedTime != queuedTime) {
                if (actualQueuedTime == 0L) continue;
                this.toBeUnloaded.put(chunkPos2, actualQueuedTime);
                continue;
            }
            this.unload(class_1923.method_8325((long)chunkPos2), class_1923.method_8332((long)chunkPos2), false);
            if (countSinceLastThrottleCheck++ <= 10) continue;
            countSinceLastThrottleCheck = 0;
            if (shouldKeepTicking.getAsBoolean()) continue;
            break;
        }
        ObjectIterator loadingJobsIter = this.loadingJobs.values().iterator();
        block3: while (loadingJobsIter.hasNext()) {
            LoadingJob loadingJob = (LoadingJob)loadingJobsIter.next();
            while (loadingJob.result == null) {
                if (!blocking) continue block3;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            loadingJobsIter.remove();
            client.method_16011().method_15396("loadFakeChunk");
            loadingJob.complete();
            client.method_16011().method_15407();
            if (shouldKeepTicking.getAsBoolean()) continue;
            break;
        }
    }

    public void loadMissingChunksFromCache() {
        this.update(false, () -> false, 0);
        this.update(false, () -> false);
    }

    public boolean shouldBeLoaded(int x, int z) {
        return this.chunkTracker.isInViewDistance(x, z);
    }

    private CompletableFuture<Optional<Pair<class_2487, FakeChunkStorage>>> loadTag(int x, int z) {
        return this.loadTag(new class_1923(x, z), 0);
    }

    private CompletableFuture<Optional<Pair<class_2487, FakeChunkStorage>>> loadTag(class_1923 chunkPos, int storageIndex) {
        FakeChunkStorage storage = this.storages.get(storageIndex);
        return storage.loadTag(chunkPos).thenCompose(maybeTag -> {
            if (maybeTag.isPresent()) {
                return CompletableFuture.completedFuture(Optional.of(Pair.of((Object)((class_2487)maybeTag.get()), (Object)((Object)storage))));
            }
            if (storageIndex + 1 < this.storages.size()) {
                return this.loadTag(chunkPos, storageIndex + 1);
            }
            return CompletableFuture.completedFuture(Optional.empty());
        });
    }

    public void load(int x, int z, class_2818 chunk) {
        this.fakeChunks.put(class_1923.method_8331((int)x, (int)z), (Object)chunk);
        this.world.method_23782(new class_1923(x, z));
        for (int i = this.world.method_32891(); i < this.world.method_31597(); ++i) {
            this.world.method_18113(x, i, z);
        }
        this.clientChunkManagerExt.bobby_onFakeChunkAdded(x, z);
    }

    public boolean unload(int x, int z, boolean willBeReplaced) {
        long chunkPos = class_1923.method_8331((int)x, (int)z);
        this.cancelLoad(chunkPos);
        class_2818 chunk = (class_2818)this.fakeChunks.remove(chunkPos);
        if (chunk != null) {
            chunk.method_38289();
            class_3568 lightingProvider = this.clientChunkManager.method_12130();
            LightingProviderExt lightingProviderExt = LightingProviderExt.get(lightingProvider);
            ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9282));
            ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9284));
            lightingProviderExt.bobby_disableColumn(chunkPos);
            for (int i = 0; i < chunk.method_12006().length; ++i) {
                int y = this.world.method_31604(i);
                if (blockLightProvider != null) {
                    blockLightProvider.bobby_removeSectionData(class_4076.method_18685((int)x, (int)y, (int)z));
                }
                if (skyLightProvider == null) continue;
                skyLightProvider.bobby_removeSectionData(class_4076.method_18685((int)x, (int)y, (int)z));
            }
            this.clientChunkManagerExt.bobby_onFakeChunkRemoved(x, z, willBeReplaced);
            return true;
        }
        return false;
    }

    private void cancelLoad(long chunkPos) {
        LoadingJob loadingJob = (LoadingJob)this.loadingJobs.remove(chunkPos);
        if (loadingJob != null) {
            loadingJob.cancelled = true;
        }
    }

    public Supplier<class_2818> save(class_2818 chunk) {
        Pair<class_2818, Supplier<class_2818>> copy = ChunkSerializer.shallowCopy(chunk);
        class_3568 lightingProvider = chunk.method_12200().method_22336();
        saveExecutor.execute(() -> {
            class_2487 nbt = ChunkSerializer.serialize((class_2818)copy.getLeft(), lightingProvider);
            this.storage.save(chunk.method_12004(), nbt);
        });
        return (Supplier)copy.getRight();
    }

    private static String getCurrentWorldOrServerName(class_634 networkHandler) {
        class_1132 integratedServer = client.method_1576();
        if (integratedServer != null) {
            return integratedServer.method_27728().method_150();
        }
        if (client.method_1589()) {
            return "realms";
        }
        class_642 serverInfo = networkHandler.method_45734();
        if (serverInfo != null) {
            return serverInfo.field_3761.replace(':', '_');
        }
        return "unknown";
    }

    public String getDebugString() {
        return "F: " + this.fakeChunks.size() + " L: " + this.loadingJobs.size() + " U: " + this.toBeUnloaded.size();
    }

    public Collection<class_2818> getFakeChunks() {
        return this.fakeChunks.values();
    }

    private class LoadingJob
    implements Runnable {
        private final int x;
        private final int z;
        private final int distanceSquared;
        private volatile boolean cancelled;
        private volatile Optional<Supplier<class_2818>> result;
        public static final Comparator<LoadingJob> BY_DISTANCE = Comparator.comparing(it -> it.distanceSquared);

        public LoadingJob(int x, int z, int distanceSquared) {
            this.x = x;
            this.z = z;
            this.distanceSquared = distanceSquared;
        }

        @Override
        public void run() {
            Optional<Object> value;
            if (this.cancelled) {
                return;
            }
            try {
                value = FakeChunkManager.this.loadTag(this.x, this.z).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                value = Optional.empty();
            }
            if (this.cancelled) {
                return;
            }
            this.result = value.map(it -> ChunkSerializer.deserialize(new class_1923(this.x, this.z), (class_2487)it.getLeft(), (class_1937)FakeChunkManager.this.world));
        }

        public void complete() {
            this.result.ifPresent(it -> FakeChunkManager.this.load(this.x, this.z, (class_2818)it.get()));
        }
    }
}

