/*
 * Decompiled with CFR 0.152.
 */
package co.secretonline.accessiblestep.options.migration;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import co.secretonline.accessiblestep.AccessibleStepClient;
import co.secretonline.accessiblestep.options.AccessibleStepConfig;
import co.secretonline.accessiblestep.options.StepMode;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MigrateFromOptionsTxt {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static AccessibleStepConfig.WorldConfig defaultValues = new AccessibleStepConfig.WorldConfig();
    public String accessibleStep;
    public boolean accessibleStepFullRange;
    public double accessibleStepHeight;
    public double accessibleSneakHeight;
    public double accessibleSprintHeight;

    public MigrateFromOptionsTxt() {
        this.accessibleStep = MigrateFromOptionsTxt.defaultValues.stepMode.method_15434();
        this.accessibleStepFullRange = MigrateFromOptionsTxt.defaultValues.useFullRange;
        this.accessibleStepHeight = MigrateFromOptionsTxt.defaultValues.stepHeight;
        this.accessibleSneakHeight = MigrateFromOptionsTxt.defaultValues.sneakHeight;
        this.accessibleSprintHeight = MigrateFromOptionsTxt.defaultValues.sprintHeight;
    }

    @Nullable
    public static AccessibleStepConfig readConfig(class_310 client) {
        File optionsTxt = new File(client.field_1697, "options.txt");
        try {
            if (!optionsTxt.exists()) {
                return null;
            }
            Jankson jankson = Jankson.builder().build();
            JsonObject options = new JsonObject();
            try (BufferedReader bufferedReader = Files.newReader((File)optionsTxt, (Charset)Charsets.UTF_8);){
                bufferedReader.lines().forEach(line -> {
                    try {
                        Iterator iterator = COLON_SPLITTER.split((CharSequence)line).iterator();
                        String key = (String)iterator.next();
                        String value = (String)iterator.next();
                        if (value.isEmpty()) {
                            return;
                        }
                        options.put(key, jankson.loadElement(value));
                    }
                    catch (Exception err) {
                        AccessibleStepClient.LOGGER.warn("Migration: Skipping bad option: {}", line);
                    }
                });
            }
            catch (Throwable err) {
                AccessibleStepClient.LOGGER.warn("Migration: Stopped while parsing options.txt", err);
            }
            if (!options.containsKey((Object)"accessibleStep")) {
                return null;
            }
            MigrateFromOptionsTxt parsedOptions = (MigrateFromOptionsTxt)jankson.fromJson(options, MigrateFromOptionsTxt.class);
            AccessibleStepConfig config = new AccessibleStepConfig();
            config.defaultConfig.stepMode = StepMode.bySerialisedId(parsedOptions.accessibleStep);
            config.defaultConfig.useFullRange = parsedOptions.accessibleStepFullRange;
            config.defaultConfig.stepHeight = parsedOptions.accessibleStepHeight;
            config.defaultConfig.sneakHeight = parsedOptions.accessibleSneakHeight;
            config.defaultConfig.sprintHeight = parsedOptions.accessibleSprintHeight;
            return config;
        }
        catch (Exception err) {
            AccessibleStepClient.LOGGER.error("Migration: Failed to migrate options from options.txt, will reset to default", (Throwable)err);
            return null;
        }
    }
}

