/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobblemonridingfabric.mixin;

import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.scheduling.Schedulable;
import com.cobblemon.mod.common.entity.Poseable;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.zanckor.cobblemonridingfabric.CobblemonRidingFabric;
import dev.zanckor.cobblemonridingfabric.MCUtil;
import dev.zanckor.cobblemonridingfabric.config.PokemonJsonObject;
import dev.zanckor.cobblemonridingfabric.mixininterface.IEntityData;
import dev.zanckor.cobblemonridingfabric.mixininterface.IPokemonStamina;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import kotlin.jvm.internal.DefaultConstructorMarker;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonMixin
extends class_1314
implements Poseable,
Schedulable,
IPokemonStamina {
    @Unique
    private PokemonJsonObject.PokemonConfigData passengerObject;
    @Unique
    private int stamina = Integer.MAX_VALUE;
    @Unique
    private int maxPassengers = -1;
    @Unique
    private static final int TIME_BETWEEN_SWITCH_SPRINTS = 10;
    @Unique
    private int timeUntilNextSwitchSprint = 0;
    @Unique
    private boolean isSprinting;
    @Unique
    private boolean prevSprintPressed;
    @Unique
    private float speedMultiplier;
    @Unique
    private class_243 prevMovementInput;
    @Unique
    private int timeUntilNextJump;

    protected PokemonMixin(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    @Shadow
    public abstract void method_5982();

    @Shadow(remap=false)
    @NotNull
    public abstract PokemonSideDelegate getDelegate();

    @Shadow
    public abstract void method_5855(int var1);

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/entity/EntityType;ILkotlin/jvm/internal/DefaultConstructorMarker;)V"}, at={@At(value="RETURN")})
    private void init(class_1937 par1, Pokemon par2, class_1299<?> par3, int par4, DefaultConstructorMarker par5, CallbackInfo ci) {
        this.method_49477(1.0f);
        this.prevMovementInput = class_243.field_1353;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.method_5642() != null) {
            if (this.mayMountOtherEntities() && this.method_5818((class_1297)this.method_5642())) {
                this.mountEntity();
            }
            this.dismountHandler();
            this.movementHandler();
            this.rotateBody();
        }
    }

    @Inject(method={"recallWithAnimation"}, at={@At(value="HEAD")}, remap=false)
    public void recall(CallbackInfoReturnable<CompletableFuture<Pokemon>> cir) {
        if (this.method_5642() != null) {
            this.method_5642().method_5848();
        }
    }

    @Unique
    private void mountEntity() {
        List mobs = this.method_37908().method_8390(class_1309.class, this.method_5829(), entity -> !(entity instanceof class_1569) && !(entity instanceof class_1657) && !this.method_5685().contains(entity) && !entity.method_42148());
        for (class_1309 mob : mobs) {
            if (!this.method_5818((class_1297)mob)) continue;
            mob.method_5804((class_1297)this);
        }
    }

    protected void method_5865(class_1297 entity, class_1297.class_4738 moveFunction) {
        if (this.method_5626(entity) && this.getPassengerObject() != null && this.method_5642() != null) {
            int passengerIndex = this.method_5685().indexOf(entity) - 1;
            boolean isControllingPassenger = this.method_5642().equals((Object)entity);
            ArrayList<Float> offSet = isControllingPassenger ? this.getPassengerObject().getRidingOffSet() : this.getPassengerObject().getPassengersOffSet().get(passengerIndex);
            this.method_5636(this.method_5642().method_43078());
            float xOffset = offSet.get(2).floatValue();
            float yOffset = offSet.get(1).floatValue();
            float zOffset = offSet.get(0).floatValue();
            class_243 vec3 = new class_243((double)xOffset, (double)yOffset, (double)zOffset).method_1024(-this.method_5642().method_43078() * ((float)Math.PI / 180));
            moveFunction.accept(entity, this.method_23317() + vec3.field_1352, this.method_23318() + vec3.field_1351, this.method_23321() + vec3.field_1350);
        }
    }

    @Unique
    private void movementHandler() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 passenger = (class_1657)class_13092;
            if (this.getPassengerObject() != null) {
                if (!this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.SWIM) && this.method_5799()) {
                    return;
                }
                this.sprintHandler();
                this.travelHandler();
                if (this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.SWIM)) {
                    this.swimmingHandler();
                }
                if (this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.LAVA_SWIM)) {
                    this.lavaSwimmingHandler();
                }
                if (this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.FLY)) {
                    this.flyingHandler();
                }
                this.resetKeyData(passenger);
            }
        }
    }

    @Unique
    private void travelHandler() {
        if (this.method_5642() != null && this.canMove()) {
            float speedConfigModifier = this.getPassengerObject().getSpeedModifier();
            ArrayList<PokemonJsonObject.MountType> mountTypes = this.getPassengerObject().getMountTypes();
            boolean isNonGravityMount = mountTypes.contains((Object)PokemonJsonObject.MountType.FLY) || mountTypes.contains((Object)PokemonJsonObject.MountType.SWIM) && this.field_5957;
            class_243 movementInput = this.method_5642().method_18798().method_1021((double)this.speedMultiplier).method_1019(this.prevMovementInput).method_1021(0.86).method_18805(1.0, isNonGravityMount ? 0.0 : 1.0, 1.0);
            this.method_5784(class_1313.field_6308, movementInput);
            this.method_18799(movementInput);
            this.jumpHandler();
            this.prevMovementInput = this.method_18798();
            this.method_5784(class_1313.field_6308, this.method_18798().method_18805((double)speedConfigModifier, 1.0, (double)speedConfigModifier));
            this.method_18799(this.method_18798().method_18805((double)speedConfigModifier, 1.0, (double)speedConfigModifier));
        }
    }

    @Unique
    private void jumpHandler() {
        ++this.timeUntilNextJump;
        if (this.isSpacePressed() && this.method_24828() && this.timeUntilNextJump > 20) {
            this.method_6043();
            this.timeUntilNextJump = 0;
        }
    }

    @Unique
    private void rotateBody() {
        if (this.method_31483() != null) {
            this.method_5710(this.method_31483().method_36454(), 0.0f);
        }
    }

    @Unique
    private void sprintHandler() {
        if (!this.isMoving()) {
            this.isSprinting = false;
            this.cobblemonRider$increaseStamina(1);
            this.speedMultiplier = 1.0f;
            return;
        }
        if (!this.isSprinting && this.isSprintPressed() && this.canSprint() && this.timeUntilNextSwitchSprint >= 10) {
            this.isSprinting = true;
            this.timeUntilNextSwitchSprint = 0;
        } else if (this.isSprinting && !this.prevSprintPressed && this.isSprintPressed() && this.timeUntilNextSwitchSprint >= 10) {
            this.method_5728(false);
            this.isSprinting = false;
            this.timeUntilNextSwitchSprint = 0;
        }
        if (this.isSprinting && this.canSprint()) {
            this.cobblemonRider$decreaseStamina(1);
            this.isSprinting = true;
            this.speedMultiplier = 1.5f;
        } else {
            this.isSprinting = false;
            this.cobblemonRider$increaseStamina(1);
            this.speedMultiplier = 1.0f;
        }
        ++this.timeUntilNextSwitchSprint;
        this.prevSprintPressed = this.isSprintPressed();
    }

    @Unique
    private void swimmingHandler() {
        if (this.method_5642() != null && this.method_5799()) {
            double waterEmergeSpeed = this.isSpacePressed() ? 0.5 : (this.isShiftPressed() ? -0.25 : 0.003);
            this.method_18800(this.method_18798().field_1352, waterEmergeSpeed, this.method_18798().field_1350);
            if ((double)this.getDistanceToSurface((class_1297)this) <= 0.5 && this.isShiftPressed()) {
                this.method_5814(this.method_23317(), this.method_23318() - 1.0, this.method_23321());
            }
            for (class_1297 passenger : this.method_5685()) {
                this.method_5855(this.method_5748());
                passenger.method_5855(passenger.method_5748());
            }
        }
    }

    @Unique
    private void lavaSwimmingHandler() {
        if (this.method_5642() != null && this.method_5771()) {
            double lavaEmergeSpeed = this.isSprinting ? 0.4 : 0.3;
            this.method_18800(this.method_18798().field_1352, lavaEmergeSpeed, this.method_18798().field_1350);
        }
    }

    @Unique
    private void flyingHandler() {
        if (this.method_5642() == null) {
            return;
        }
        boolean increaseAltitude = this.isSpacePressed();
        boolean decreaseAltitude = this.isShiftPressed();
        double altitudeIncreaseValue = increaseAltitude ? 0.3 : (decreaseAltitude ? -0.3 : 0.0);
        this.method_18800(this.method_18798().field_1352, altitudeIncreaseValue, this.method_18798().field_1350);
        if (this.getPokemon().getEntity() != null) {
            this.getPokemon().getEntity().setBehaviourFlag(PokemonBehaviourFlag.FLYING, this.method_37908().method_8320(this.method_24515().method_10074()).method_26215());
        }
    }

    @Unique
    private float getDistanceToSurface(class_1297 entity) {
        double yPos = entity.method_23318();
        double surfaceYPos = entity.method_37908().method_8624(class_2902.class_2903.field_13202, (int)(entity.method_23317() - (double)entity.method_18381(class_4050.field_18076)), (int)entity.method_23321());
        return (float)(surfaceYPos - yPos);
    }

    @Unique
    private void dismountHandler() {
        class_1309 class_13092;
        if (!this.method_5805() || this.method_31481() || !(this.method_5642() instanceof class_1657)) {
            this.method_5772();
        }
        if (this.checkShouldDismount() && this.method_5642() != null && (class_13092 = this.method_5642()) instanceof class_1657) {
            class_1657 passenger = (class_1657)class_13092;
            this.resetKeyData(passenger);
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_5642() != null && fallDistance < 7.0f) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(class_1282 source, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_5642() != null && this.getPassengerObject() != null && this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.LAVA_SWIM)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"interactMob"}, at={@At(value="TAIL")})
    public void mobInteractRiding(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        String megacuff = "item.megamons.mega_cuff";
        if (!player.method_6047().method_7909().method_7876().equals(megacuff) && this.getPassengerObject() != null && (Objects.equals(this.getPokemon().getOwnerPlayer(), player) || this.method_5642() != null)) {
            player.method_5804((class_1297)this);
            this.method_49477(2.5f);
            this.resetKeyData(player);
        }
    }

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteractRemoveMegamonsMegaCuff(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        String megacuff = "item.megamons.mega_cuff";
        if (player.method_6047().method_7909().method_7876().equals(megacuff) && this.getPassengerObject() != null && this.method_5685().contains(player)) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    public boolean method_5862() {
        if (this.getPassengerObject() != null && this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.LAVA_SWIM)) {
            return false;
        }
        return super.method_5862();
    }

    protected boolean method_5818(@NotNull class_1297 entity) {
        if (this.maxPassengers == -1) {
            this.maxPassengers = this.getPassengerObject() != null ? this.getPassengerObject().getPassengersOffSet().size() + 1 : 0;
        }
        return this.method_5685().size() < this.maxPassengers;
    }

    @Unique
    private PokemonJsonObject.PokemonConfigData getPassengerObject() {
        if (this.passengerObject == null) {
            this.passengerObject = MCUtil.getPassengerObject(this.getPokemon().getSpecies().getName(), this.getPokemon().getForm().getName());
        }
        return this.passengerObject;
    }

    @Unique
    private boolean canMove() {
        return this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.SWIM) && this.method_5799() || this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.FLY) && !this.method_24828() || this.getPassengerObject().getMountTypes().contains((Object)PokemonJsonObject.MountType.WALK);
    }

    @Unique
    private void resetKeyData(class_1657 passenger) {
        ((IEntityData)passenger).getPersistentData().method_10556("press_space", false);
        ((IEntityData)passenger).getPersistentData().method_10556("press_sprint", false);
        ((IEntityData)passenger).getPersistentData().method_10556("pokemon_dismount", false);
        ((IEntityData)passenger).getPersistentData().method_10556("press_shift", false);
        passenger.method_5660(false);
    }

    @Nullable
    public class_1309 method_5642() {
        return this.method_5685().isEmpty() ? null : (class_1309)this.method_5685().get(0);
    }

    protected float method_6106() {
        return 0.6f * this.method_23313() + this.method_37416();
    }

    @Override
    public int cobblemonRider$getStamina() {
        return Math.min(this.stamina, this.cobblemonRider$getMaxStamina());
    }

    @Override
    public int cobblemonRider$getMaxStamina() {
        if (this.getPassengerObject() == null) {
            return 0;
        }
        return this.getPassengerObject().getMaxStamina();
    }

    @Override
    public void cobblemonRider$setStamina(int stamina) {
        this.stamina = stamina;
    }

    @Override
    public void cobblemonRider$increaseStamina(int amount) {
        this.cobblemonRider$setStamina(Math.min(this.cobblemonRider$getStamina() + amount, this.cobblemonRider$getMaxStamina()));
    }

    @Override
    public void cobblemonRider$decreaseStamina(int amount) {
        this.cobblemonRider$setStamina(Math.max(this.cobblemonRider$getStamina() - amount, 0));
    }

    @Unique
    public boolean checkShouldDismount() {
        return this.isPokemonDismountPressed() || this.method_5685().isEmpty();
    }

    @Unique
    private boolean isSpacePressed() {
        return this.method_5642() != null && ((IEntityData)this.method_5642()).getPersistentData().method_10545("press_space") && ((IEntityData)this.method_5642()).getPersistentData().method_10577("press_space");
    }

    @Unique
    public boolean canSprint() {
        return (this.isSprintPressed() || this.isSprinting) && (this.isSprinting && this.cobblemonRider$getStamina() > 0 || !this.isSprinting && (float)this.cobblemonRider$getStamina() > (float)this.cobblemonRider$getMaxStamina() * 0.3f);
    }

    public void method_5728(boolean sprinting) {
        if (this.method_5642() != null) {
            ((IEntityData)this.method_5642()).getPersistentData().method_10556("press_sprint", sprinting);
        }
    }

    @Unique
    private boolean isSprintPressed() {
        return this.method_5642() != null && ((IEntityData)this.method_5642()).getPersistentData().method_10545("press_sprint") && ((IEntityData)this.method_5642()).getPersistentData().method_10577("press_sprint");
    }

    @Unique
    private boolean isShiftPressed() {
        return this.method_5642() != null && ((IEntityData)this.method_5642()).getPersistentData().method_10545("press_shift") && ((IEntityData)this.method_5642()).getPersistentData().method_10577("press_shift");
    }

    @Unique
    private boolean isPokemonDismountPressed() {
        return this.method_5642() != null && ((IEntityData)this.method_5642()).getPersistentData().method_10545("pokemon_dismount") && ((IEntityData)this.method_5642()).getPersistentData().method_10577("pokemon_dismount");
    }

    @Unique
    private boolean mayMountOtherEntities() {
        return CobblemonRidingFabric.pokemonJsonObject != null && CobblemonRidingFabric.pokemonJsonObject.mustAllowEntityRiding() && this.method_5642() != null && this.method_5642() instanceof class_1657 && ((IEntityData)this.method_5642()).getPersistentData().method_10545("pokemon_mount_entities") && ((IEntityData)this.method_5642()).getPersistentData().method_10577("pokemon_mount_entities");
    }

    @Unique
    private boolean isMoving() {
        return this.method_5642() != null && (this.method_5642().method_18798().field_1352 != 0.0 || this.method_5642().method_18798().field_1350 != 0.0);
    }
}

