/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_6862;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FilterLogic
extends FilterLogicBase {
    private final int filterSlotCount;
    private final Predicate<class_1799> isItemValid;
    private ObservableFilterItemStackHandler filterHandler = null;
    private boolean emptyAllowListMatchesEverything = false;

    public FilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount) {
        this(upgrade, saveHandler, filterSlotCount, s -> true, "");
    }

    public FilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount, String parentTagKey) {
        this(upgrade, saveHandler, filterSlotCount, s -> true, parentTagKey);
    }

    public FilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount, Predicate<class_1799> isItemValid) {
        this(upgrade, saveHandler, filterSlotCount, isItemValid, "");
    }

    public FilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount, Predicate<class_1799> isItemValid, String parentTagKey) {
        super(upgrade, saveHandler, parentTagKey);
        this.filterSlotCount = filterSlotCount;
        this.isItemValid = isItemValid;
    }

    public void setEmptyAllowListMatchesEverything() {
        this.emptyAllowListMatchesEverything = true;
    }

    public ObservableFilterItemStackHandler getFilterHandler() {
        if (this.filterHandler == null) {
            this.filterHandler = new ObservableFilterItemStackHandler();
            NBTHelper.getCompound(this.upgrade, this.parentTagKey, "filters").ifPresent(this.filterHandler::deserializeNBT);
        }
        return this.filterHandler;
    }

    public boolean matchesFilter(class_1799 stack) {
        if (this.isAllowList()) {
            if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
                return this.isTagMatch(stack);
            }
            return this.getFilterHandler().hasOnlyEmptyFilters() && this.emptyAllowListMatchesEverything || InventoryHelper.iterate((SlottedStackStorage)this.getFilterHandler(), (slot, filter) -> this.stackMatchesFilter(stack, (class_1799)filter), () -> false, returnValue -> returnValue) != false;
        }
        if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
            return !this.isTagMatch(stack);
        }
        return this.getFilterHandler().hasOnlyEmptyFilters() || InventoryHelper.iterate((SlottedStackStorage)this.getFilterHandler(), (slot, filter) -> !this.stackMatchesFilter(stack, (class_1799)filter), () -> true, returnValue -> returnValue == false) != false;
    }

    private boolean isTagMatch(class_1799 stack) {
        if (this.shouldMatchAnyTag()) {
            return this.anyTagMatches(stack.method_40133());
        }
        return this.allTagsMatch(stack.method_40133());
    }

    private boolean allTagsMatch(Stream<class_6862<class_1792>> tagsStream) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        Set tags = tagsStream.collect(Collectors.toSet());
        for (class_6862 tagName : this.tagKeys) {
            if (tags.contains(tagName)) continue;
            return false;
        }
        return true;
    }

    private boolean anyTagMatches(Stream<class_6862<class_1792>> tags) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return tags.anyMatch(t -> this.tagKeys.contains(t));
    }

    public class ObservableFilterItemStackHandler
    extends FilterItemStackHandler {
        private IntConsumer onSlotChange;

        public ObservableFilterItemStackHandler() {
            super(FilterLogic.this.filterSlotCount);
            this.onSlotChange = s -> {};
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NBTHelper.setCompoundNBT(FilterLogic.this.upgrade, FilterLogic.this.parentTagKey, "filters", this.serializeNBT());
            FilterLogic.this.save();
            this.onSlotChange.accept(slot);
        }

        public void setOnSlotChange(IntConsumer onSlotChange) {
            this.onSlotChange = onSlotChange;
        }

        public void deserializeNBT(class_2487 nbt) {
            this.setSize(FilterLogic.this.filterSlotCount);
            class_2499 tagList = nbt.method_10554("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 itemTags = tagList.method_10602(i);
                int slot = itemTags.method_10550("Slot");
                if (slot < 0 || slot >= this.getSlotCount()) continue;
                this.getSlot(slot).load(itemTags);
            }
            this.onLoad();
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            class_1799 stack = resource.toStack(count);
            return stack.method_7960() || this.doesNotContain(stack) && FilterLogic.this.isItemValid.test(stack);
        }

        private boolean doesNotContain(class_1799 stack) {
            return !InventoryHelper.hasItem((SlottedStorage<ItemVariant>)this, s -> class_1799.method_31577((class_1799)s, (class_1799)stack));
        }
    }
}

