/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2520;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;
import team.reborn.energy.api.base.SimpleSidedEnergyContainer;

public class BatteryUpgradeWrapper
extends UpgradeWrapperBase<BatteryUpgradeWrapper, BatteryUpgradeItem>
implements IRenderedBatteryUpgrade,
EnergyStorage,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final String ENERGY_STORED_TAG = "energy";
    private Consumer<IRenderedBatteryUpgrade.BatteryRenderInfo> updateTankRenderInfoCallback;
    private final ItemStackHandler inventory;
    private final SimpleSidedEnergyContainer energyStorage;

    protected BatteryUpgradeWrapper(IStorageWrapper storageWrapper, final class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                upgrade.method_7959("inventory", (class_2520)this.serializeNBT());
                BatteryUpgradeWrapper.this.save();
            }

            public boolean isItemValid(int slot, ItemVariant resource, int count) {
                return switch (slot) {
                    case 0 -> this.isValidInputItem(resource.toStack(count));
                    case 1 -> this.isValidOutputItem(resource.toStack(count));
                    default -> false;
                };
            }

            private boolean isValidInputItem(class_1799 stack) {
                return BatteryUpgradeWrapper.this.isValidEnergyItem(stack, false);
            }

            private boolean isValidOutputItem(class_1799 stack) {
                return BatteryUpgradeWrapper.this.isValidEnergyItem(stack, true);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        NBTHelper.getCompound(upgrade, "inventory").ifPresent(arg_0 -> ((ItemStackHandler)this.inventory).deserializeNBT(arg_0));
        this.energyStorage = new SimpleSidedEnergyContainer(){

            protected void onFinalCommit() {
                BatteryUpgradeWrapper.this.serializeEnergyStored();
            }

            public long getCapacity() {
                return BatteryUpgradeWrapper.this.getCapacity();
            }

            public long getMaxInsert(@Nullable class_2350 side) {
                return BatteryUpgradeWrapper.this.getMaxInOut();
            }

            public long getMaxExtract(@Nullable class_2350 side) {
                return BatteryUpgradeWrapper.this.getMaxInOut();
            }
        };
        this.energyStorage.amount = BatteryUpgradeWrapper.getEnergyStored(upgrade);
    }

    public static long getEnergyStored(class_1799 upgrade) {
        return NBTHelper.getLong(upgrade, ENERGY_STORED_TAG).orElse(0L);
    }

    public EnergyStorage getSideEnergyStorage(@Nullable class_2350 side) {
        return this.energyStorage.getSideStorage(side);
    }

    public long insert(long maxAmount, TransactionContext ctx) {
        return this.getSideEnergyStorage(null).insert(maxAmount, ctx);
    }

    private void serializeEnergyStored() {
        NBTHelper.setLong(this.upgrade, ENERGY_STORED_TAG, this.energyStorage.amount);
        this.save();
        this.forceUpdateBatteryRenderInfo();
    }

    public long extract(long maxAmount, TransactionContext ctx) {
        return this.getSideEnergyStorage(null).extract(maxAmount, ctx);
    }

    public long getAmount() {
        return this.energyStorage.amount;
    }

    public long getCapacity() {
        return ((BatteryUpgradeItem)this.upgradeItem).getMaxEnergyStored(this.storageWrapper);
    }

    public boolean supportsExtraction() {
        return true;
    }

    public boolean supportsInsertion() {
        return true;
    }

    private int getMaxInOut() {
        int baseInOut;
        double stackMultiplier = ((BatteryUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper);
        return stackMultiplier > (double)(Integer.MAX_VALUE / (baseInOut = (Integer)((BatteryUpgradeItem)this.upgradeItem).getBatteryUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows())) ? Integer.MAX_VALUE : (int)((double)baseInOut * stackMultiplier);
    }

    private boolean isValidEnergyItem(class_1799 stack, boolean isOutput) {
        return isOutput || EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    @Override
    public void setBatteryRenderInfoUpdateCallback(Consumer<IRenderedBatteryUpgrade.BatteryRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateBatteryRenderInfo() {
        IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = new IRenderedBatteryUpgrade.BatteryRenderInfo(1.0f);
        batteryRenderInfo.setChargeRatio((float)Math.round((float)this.getAmount() / (float)this.getCapacity() * 4.0f) / 4.0f);
        this.updateTankRenderInfoCallback.accept(batteryRenderInfo);
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 world, class_2338 pos) {
        if (this.getAmount() < this.getCapacity()) {
            EnergyStorageUtil.move((EnergyStorage)((EnergyStorage)ContainerItemContext.ofSingleSlot((SingleSlotStorage)new EnergyStackWrapper(0)).find(EnergyStorage.ITEM)), (EnergyStorage)this.getSideEnergyStorage(null), (long)Long.MAX_VALUE, null);
        }
        if (this.getAmount() > 0L) {
            EnergyStorageUtil.move((EnergyStorage)this.getSideEnergyStorage(null), (EnergyStorage)((EnergyStorage)ContainerItemContext.ofSingleSlot((SingleSlotStorage)new EnergyStackWrapper(1)).find(EnergyStorage.ITEM)), (long)Long.MAX_VALUE, null);
            for (class_2350 side : class_2350.values()) {
                EnergyStorageUtil.move((EnergyStorage)this.getSideEnergyStorage(side), (EnergyStorage)((EnergyStorage)EnergyStorage.SIDED.find(world, pos.method_10093(side), (Object)side.method_10153())), (long)Long.MAX_VALUE, null);
            }
        }
    }

    public SlottedStackStorage getInventory() {
        return this.inventory;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.getAmount() / (float)((BatteryUpgradeItem)this.upgradeItem).getMaxEnergyBase(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    private class EnergyStackWrapper
    extends SingleStackStorage {
        private final int slot;

        public EnergyStackWrapper(int slot) {
            this.slot = slot;
        }

        protected class_1799 getStack() {
            return BatteryUpgradeWrapper.this.inventory.getStackInSlot(this.slot);
        }

        protected void setStack(class_1799 stack) {
            BatteryUpgradeWrapper.this.inventory.setStackInSlot(this.slot, stack);
        }
    }
}

