/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.villagers.data;

import com.glisco.numismaticoverhaul.villagers.data.RemappingTradeWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_3545;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import org.apache.commons.lang3.ArrayUtils;

public class NumismaticVillagerTradesRegistry {
    private static final HashMap<class_3852, Int2ObjectOpenHashMap<List<class_3853.class_1652>>> TRADES_REGISTRY = new HashMap();
    private static final Int2ObjectOpenHashMap<List<class_3853.class_1652>> WANDERING_TRADER_REGISTRY = new Int2ObjectOpenHashMap();
    private static final HashMap<class_3852, Int2ObjectOpenHashMap<List<class_3853.class_1652>>> REMAPPED_FABRIC_TRADES = new HashMap();
    private static final Int2ObjectOpenHashMap<List<class_3853.class_1652>> REMAPPED_FABRIC_WANDERING_TRADER_TRADES = new Int2ObjectOpenHashMap();
    private static final AtomicBoolean MOD_VILLAGERS_WRAPPED = new AtomicBoolean(false);

    public static void registerFabricVillagerTrades(class_3852 profession, int level, List<class_3853.class_1652> factories) {
        NumismaticVillagerTradesRegistry.getVillagerTradeList(REMAPPED_FABRIC_TRADES, profession, level).addAll(factories.stream().map(RemappingTradeWrapper::wrap).toList());
    }

    public static void registerFabricWanderingTraderTrades(int level, List<class_3853.class_1652> factories) {
        ((List)NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(REMAPPED_FABRIC_WANDERING_TRADER_TRADES, level, new ArrayList())).addAll(factories.stream().map(RemappingTradeWrapper::wrap).toList());
    }

    public static void registerVillagerTrade(class_3852 profession, int level, class_3853.class_1652 trade) {
        NumismaticVillagerTradesRegistry.getVillagerTradeList(TRADES_REGISTRY, profession, level).add(trade);
    }

    public static void registerWanderingTraderTrade(int level, class_3853.class_1652 trade) {
        ((List)NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(WANDERING_TRADER_REGISTRY, level, new ArrayList())).add(trade);
    }

    public static void wrapModVillagers() {
        if (MOD_VILLAGERS_WRAPPED.get()) {
            return;
        }
        class_3853.field_17067.forEach((profession, int2TradesMap) -> {
            if (TRADES_REGISTRY.containsKey(profession)) {
                return;
            }
            int2TradesMap.forEach((integer, factories) -> NumismaticVillagerTradesRegistry.registerFabricVillagerTrades(profession, integer, Arrays.asList(factories)));
        });
        MOD_VILLAGERS_WRAPPED.set(true);
    }

    private static List<class_3853.class_1652> getVillagerTradeList(HashMap<class_3852, Int2ObjectOpenHashMap<List<class_3853.class_1652>>> registry, class_3852 profession, int level) {
        Int2ObjectOpenHashMap villagerMap = NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(registry, profession, new Int2ObjectOpenHashMap());
        return NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(villagerMap, level, new ArrayList());
    }

    public static <K, V> V getOrDefaultAndAdd(Map<K, V> map, K key, V defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static void clearRegistries() {
        TRADES_REGISTRY.clear();
        WANDERING_TRADER_REGISTRY.clear();
    }

    public static class_3545<HashMap<class_3852, Int2ObjectOpenHashMap<class_3853.class_1652[]>>, Int2ObjectOpenHashMap<class_3853.class_1652[]>> getRegistryForLoading() {
        RegistryProcessor processor = RegistryProcessor.begin();
        TRADES_REGISTRY.forEach(processor::processProfession);
        REMAPPED_FABRIC_TRADES.forEach((villagerProfession, listInt2ObjectOpenHashMap) -> {
            if (TRADES_REGISTRY.containsKey(villagerProfession)) {
                return;
            }
            processor.processProfession((class_3852)villagerProfession, (Int2ObjectOpenHashMap<List<class_3853.class_1652>>)listInt2ObjectOpenHashMap);
        });
        WANDERING_TRADER_REGISTRY.forEach(processor::processWanderingTrader);
        REMAPPED_FABRIC_WANDERING_TRADER_TRADES.forEach(processor::processWanderingTrader);
        return processor.finish();
    }

    private static class RegistryProcessor {
        private final HashMap<class_3852, Int2ObjectOpenHashMap<class_3853.class_1652[]>> villagerTrades = new HashMap();
        private final Int2ObjectOpenHashMap<class_3853.class_1652[]> wanderingTraderTrades = new Int2ObjectOpenHashMap();

        private RegistryProcessor() {
        }

        public static RegistryProcessor begin() {
            return new RegistryProcessor();
        }

        public void processProfession(class_3852 profession, Int2ObjectOpenHashMap<List<class_3853.class_1652>> professionTradesPerLevel) {
            Int2ObjectOpenHashMap<class_3853.class_1652[]> factories = this.villagerTrades.getOrDefault(profession, (Int2ObjectOpenHashMap<class_3853.class_1652[]>)new Int2ObjectOpenHashMap());
            professionTradesPerLevel.forEach((level, factoryList) -> {
                Object[] oldFactories = (class_3853.class_1652[])factories.getOrDefault(level.intValue(), (Object)new class_3853.class_1652[0]);
                factories.put(level.intValue(), (Object)((class_3853.class_1652[])ArrayUtils.addAll((Object[])oldFactories, (Object[])factoryList.toArray(new class_3853.class_1652[0]))));
            });
            this.villagerTrades.put(profession, factories);
        }

        public void processWanderingTrader(Integer level, List<class_3853.class_1652> trades) {
            Object[] oldFactories = (class_3853.class_1652[])this.wanderingTraderTrades.getOrDefault(level.intValue(), (Object)new class_3853.class_1652[0]);
            this.wanderingTraderTrades.put(level.intValue(), (Object)((class_3853.class_1652[])ArrayUtils.addAll((Object[])oldFactories, (Object[])trades.toArray(new class_3853.class_1652[0]))));
        }

        public class_3545<HashMap<class_3852, Int2ObjectOpenHashMap<class_3853.class_1652[]>>, Int2ObjectOpenHashMap<class_3853.class_1652[]>> finish() {
            return new class_3545(this.villagerTrades, this.wanderingTraderTrades);
        }
    }
}

