/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.gooeylibs2.api.button;

import ca.landonjw.gooeylibs2.api.button.ButtonAction;
import ca.landonjw.gooeylibs2.api.button.ButtonBase;
import ca.landonjw.gooeylibs2.api.button.FlagType;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class GooeyButton
extends ButtonBase {
    private final Consumer<ButtonAction> onClick;

    protected GooeyButton(@Nonnull class_1799 display, @Nullable Consumer<ButtonAction> onClick) {
        super(display);
        this.onClick = onClick;
    }

    @Override
    public void onClick(@Nonnull ButtonAction action) {
        if (this.onClick != null) {
            this.onClick.accept(action);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GooeyButton of(class_1799 stack) {
        return GooeyButton.builder().display(stack).build();
    }

    public static class Builder {
        protected class_1799 display;
        protected class_2561 title;
        protected Collection<class_2561> lore = Lists.newArrayList();
        protected Consumer<ButtonAction> onClick;
        protected Set<FlagType> hideFlags = new LinkedHashSet<FlagType>();

        public Builder display(@Nonnull class_1799 display) {
            this.display = display;
            return this;
        }

        public Builder title(@Nullable String title) {
            if (title == null) {
                return this;
            }
            return this.title((class_2561)class_2561.method_43470((String)title));
        }

        public Builder title(@Nullable class_2561 title) {
            this.title = title;
            return this;
        }

        public Builder lore(@Nullable Collection<String> lore) {
            if (lore == null) {
                return this;
            }
            this.lore = lore.stream().map(class_2561::method_43470).collect(Collectors.toList());
            return this;
        }

        public <T> Builder lore(Class<T> type, @Nullable Collection<T> lore) {
            if (lore == null) {
                return this;
            }
            if (class_2561.class.isAssignableFrom(type)) {
                this.lore = lore;
                return this;
            }
            if (String.class.isAssignableFrom(type)) {
                return this.lore(lore);
            }
            throw new UnsupportedOperationException("Invalid Type: " + type.getName());
        }

        public Builder hideFlags(FlagType ... flags) {
            this.hideFlags.addAll(Arrays.asList(flags));
            return this;
        }

        public Builder onClick(@Nullable Consumer<ButtonAction> behaviour) {
            this.onClick = behaviour;
            return this;
        }

        public Builder onClick(@Nullable Runnable behaviour) {
            this.onClick = behaviour != null ? action -> behaviour.run() : null;
            return this;
        }

        public GooeyButton build() {
            this.validate();
            return new GooeyButton(this.buildDisplay(), this.onClick);
        }

        protected void validate() {
            if (this.display == null) {
                throw new IllegalStateException("button display must be defined");
            }
        }

        protected class_1799 buildDisplay() {
            if (this.title != null) {
                class_5250 result = class_2561.method_43473().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_10852(this.title);
                this.display.method_7977((class_2561)result);
            }
            if (!this.lore.isEmpty()) {
                class_2499 nbtLore = new class_2499();
                for (class_2561 line : this.lore) {
                    class_5250 result = class_2561.method_43473().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_10852(line);
                    nbtLore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)result)));
                }
                this.display.method_7911("display").method_10566("Lore", (class_2520)nbtLore);
            }
            if (!this.hideFlags.isEmpty() && this.display.method_7985()) {
                if (this.hideFlags.contains((Object)FlagType.Reforged) || this.hideFlags.contains((Object)FlagType.All)) {
                    this.display.method_7948().method_10582("tooltip", "");
                }
                if (this.hideFlags.contains((Object)FlagType.Generations) || this.hideFlags.contains((Object)FlagType.All)) {
                    this.display.method_7948().method_10556("HideTooltip", true);
                }
                int value = 0;
                for (FlagType flag : this.hideFlags) {
                    value += flag.getValue();
                }
                this.display.method_7948().method_10569("HideFlags", value);
            }
            return this.display;
        }
    }
}

