/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.gooeylibs2.api.container;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.ButtonAction;
import ca.landonjw.gooeylibs2.api.button.ButtonClick;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.button.moveable.Movable;
import ca.landonjw.gooeylibs2.api.button.moveable.MovableButtonAction;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.page.PageAction;
import ca.landonjw.gooeylibs2.api.tasks.Task;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlot;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;
import ca.landonjw.gooeylibs2.api.template.types.InventoryTemplate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2649;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3944;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class GooeyContainer
extends class_1703 {
    private final MinecraftServer server;
    private final class_3222 player;
    private final class_1263 container;
    private final Page page;
    public InventoryTemplate inventoryTemplate;
    private long lastClickTick;
    private boolean closing;
    private Button cursorButton;

    public GooeyContainer(@Nonnull class_3222 player, @Nonnull Page page) {
        super(page.getTemplate().getTemplateType().getContainerType(page.getTemplate()), 1);
        this.server = player.method_37908().method_8503();
        this.player = player;
        this.page = page;
        this.inventoryTemplate = page.getInventoryTemplate().orElse(null);
        this.container = new class_1277(page.getTemplate().getSize() + 36);
        this.bindSlots();
        this.bindPage();
    }

    private void bindPage() {
        this.page.subscribe((Object)this, this::refresh);
    }

    public void refresh() {
        this.unbindSlots();
        this.inventoryTemplate = this.page.getInventoryTemplate().orElse(null);
        this.bindSlots();
        this.openWindow();
    }

    private void bindSlots() {
        TemplateSlotDelegate delegate;
        int index;
        int i;
        List<TemplateSlotDelegate> delegates = this.page.getTemplate().getSlots();
        int slotIndex = 0;
        for (i = 0; i < delegates.size(); ++i) {
            index = i;
            delegate = delegates.get(i);
            TemplateSlot slot = new TemplateSlot(this.container, delegate, 0, 0);
            delegate.subscribe((Object)this, () -> this.updateSlotStack(index, this.getItemAtSlot(index), false));
            this.method_7621(slot);
            this.container.method_5447(slotIndex++, slot.method_7677());
        }
        if (this.inventoryTemplate == null) {
            for (i = 9; i < 36; ++i) {
                GooeyButton button = GooeyButton.of((class_1799)this.player.method_31548().field_7547.get(i));
                delegate = new TemplateSlotDelegate(button, i - 9);
                this.method_7621(new TemplateSlot(this.container, delegate, 0, 0));
                this.container.method_5447(slotIndex++, button.getDisplay());
            }
            for (i = 0; i < 9; ++i) {
                GooeyButton button = GooeyButton.of((class_1799)this.player.method_31548().field_7547.get(i));
                delegate = new TemplateSlotDelegate(button, i + 27);
                this.method_7621(new TemplateSlot(this.container, delegate, 0, 0));
                this.container.method_5447(slotIndex++, button.getDisplay());
            }
        } else {
            for (i = 0; i < this.inventoryTemplate.getSize(); ++i) {
                index = i;
                int itemSlot = i + this.page.getTemplate().getSize();
                TemplateSlotDelegate delegate2 = this.inventoryTemplate.getSlot(i);
                TemplateSlot slot = new TemplateSlot(this.container, delegate2, 0, 0);
                delegate2.subscribe((Object)this, () -> this.updateSlotStack(index, this.getItemAtSlot(itemSlot), true));
                this.method_7621(slot);
                this.container.method_5447(itemSlot, slot.method_7677());
            }
        }
    }

    private void unbindSlots() {
        this.field_7761.forEach(slot -> ((TemplateSlot)((Object)slot)).getDelegate().unsubscribe((Object)this));
        if (this.inventoryTemplate != null) {
            this.inventoryTemplate.getSlots().forEach(delegate -> delegate.unsubscribe((Object)this));
        }
        this.field_7761.clear();
    }

    private void updateSlotStack(int index, class_1799 stack, boolean playerInventory) {
        this.player.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.player.field_7512.method_37421(), playerInventory ? this.page.getTemplate().getSize() + index : index, stack));
    }

    private int getTemplateIndex(int slotIndex) {
        if (this.isSlotInPlayerInventory(slotIndex)) {
            return slotIndex - this.page.getTemplate().getSize();
        }
        return slotIndex;
    }

    private Template getTemplateFromIndex(int slotIndex) {
        if (this.isSlotInPlayerInventory(slotIndex)) {
            return this.inventoryTemplate;
        }
        return this.page.getTemplate();
    }

    private boolean isSlotInPlayerInventory(int slot) {
        int templateSize = this.page.getTemplate().getSize();
        return slot >= templateSize && slot - templateSize < this.player.field_7498.field_7761.size();
    }

    private class_1799 getItemAtSlot(int slot) {
        if (slot == -999 || slot >= this.field_7761.size()) {
            return class_1799.field_8037;
        }
        return ((class_1735)this.field_7761.get(slot)).method_7677();
    }

    public void open() {
        this.player.method_14247();
        this.player.field_7512 = this;
        this.player.field_13986 = this.player.field_7512.field_7763;
        this.openWindow();
        this.page.onOpen(new PageAction(this.player, this.page));
    }

    private void openWindow() {
        class_3944 openWindow = new class_3944(this.player.field_13986, this.page.getTemplate().getTemplateType().getContainerType(this.page.getTemplate()), this.page.getTitle());
        this.player.field_13987.method_14364((class_2596)openWindow);
        this.updateAllContainerContents();
        this.setPlayersCursor(class_1799.field_8037);
    }

    private void patchDesyncs(int slot, class_1713 clickType) {
        if (clickType == class_1713.field_7790 || clickType == class_1713.field_7796 || clickType == class_1713.field_7795) {
            this.updateSlotStack(this.getTemplateIndex(slot), this.getItemAtSlot(slot), this.isSlotInPlayerInventory(slot));
        } else if (clickType == class_1713.field_7794 || clickType == class_1713.field_7793) {
            this.updateAllContainerContents();
        }
    }

    public class_1799 method_7601(@NotNull class_1657 player, int i) {
        return class_1799.field_8037;
    }

    public void method_7593(int slot, int dragType, @NotNull class_1713 type, @NotNull class_1657 player) {
        if (slot == -1 || slot == -999) {
            if (this.cursorButton != null) {
                this.setPlayersCursor(this.cursorButton.getDisplay());
            }
            return;
        }
        class_1735 target = (class_1735)this.field_7761.get(slot);
        if (this.lastClickTick == (long)this.server.method_3780()) {
            if (type == class_1713.field_7790 && this.cursorButton != null) {
                class_1799 clickedItem = this.getItemAtSlot(slot);
                class_1799 cursorItem = this.cursorButton.getDisplay();
                if (clickedItem.method_7909() == cursorItem.method_7909() && class_1799.method_7984((class_1799)clickedItem, (class_1799)cursorItem)) {
                    class_1799 copy = this.getItemAtSlot(slot).method_7972();
                    copy.method_7939(copy.method_7947() + this.cursorButton.getDisplay().method_7947());
                    target.method_7667((class_1657)this.player, copy);
                }
                return;
            }
            this.patchDesyncs(slot, type);
            this.setPlayersCursor(this.cursorButton != null ? this.cursorButton.getDisplay() : class_1799.field_8037);
            return;
        }
        this.lastClickTick = this.server.method_3780();
        if (type == class_1713.field_7789 && dragType == 8) {
            Task.builder().execute(() -> {
                this.updateAllContainerContents();
                this.setPlayersCursor(this.cursorButton != null ? this.cursorButton.getDisplay() : class_1799.field_8037);
            }).build();
            return;
        }
        this.patchDesyncs(slot, type);
        Button button = this.getButton(slot);
        if (button instanceof Movable || this.cursorButton != null) {
            this.handleMovableButton(slot, dragType, type);
            return;
        }
        this.setPlayersCursor(class_1799.field_8037);
        if (type == class_1713.field_7791) {
            class_1799 inventory = this.player.method_31548().method_5438(dragType);
            this.updateSlotStack(27 + dragType, inventory, true);
            this.updateSlotStack(slot, this.getItemAtSlot(slot), false);
        }
        if (type == class_1713.field_7789) {
            this.updateSlotStack(this.getTemplateIndex(slot), class_1799.field_8037, this.isSlotInPlayerInventory(slot));
            return;
        }
        ButtonClick buttonClickType = this.getButtonClickType(type, dragType);
        if (button != null) {
            ButtonAction action = new ButtonAction(this.player, buttonClickType, button, this.page.getTemplate(), this.page, slot);
            button.onClick(action);
        }
    }

    private ButtonClick getButtonClickType(class_1713 type, int dragType) {
        return switch (type) {
            case class_1713.field_7790 -> {
                if (dragType == 0) {
                    yield ButtonClick.LEFT_CLICK;
                }
                yield ButtonClick.RIGHT_CLICK;
            }
            case class_1713.field_7796 -> ButtonClick.MIDDLE_CLICK;
            case class_1713.field_7794 -> {
                if (dragType == 0) {
                    yield ButtonClick.SHIFT_LEFT_CLICK;
                }
                yield ButtonClick.SHIFT_RIGHT_CLICK;
            }
            case class_1713.field_7795 -> ButtonClick.THROW;
            default -> ButtonClick.OTHER;
        };
    }

    private void handleMovableButton(int slot, int dragType, class_1713 clickType) {
        if (clickType == class_1713.field_7789 && slot == -999) {
            return;
        }
        Template template = this.getTemplateFromIndex(slot);
        if (template == null) {
            if (clickType == class_1713.field_7790 && this.isSlotOccupied(slot)) {
                this.setPlayersCursor(this.cursorButton != null ? this.cursorButton.getDisplay() : class_1799.field_8037);
                return;
            }
            if (clickType == class_1713.field_7789) {
                this.updateAllContainerContents();
            }
            if (this.cursorButton != null) {
                this.setPlayersCursor(this.cursorButton.getDisplay());
            }
        } else if (this.cursorButton == null) {
            this.onMovablePickup(slot, dragType, clickType);
        } else {
            this.onMovableDrop(slot, dragType, clickType);
        }
    }

    private void onMovablePickup(int slot, int dragType, class_1713 clickType) {
        Template template = this.getTemplateFromIndex(slot);
        int targetTemplateSlot = this.getTemplateIndex(slot);
        Button clickedButton = this.getButton(slot);
        if (slot == -999) {
            return;
        }
        this.setPlayersCursor(this.getItemAtSlot(slot));
        if (clickedButton == null) {
            return;
        }
        if (clickType == class_1713.field_7789 && dragType == 9) {
            this.setPlayersCursor(class_1799.field_8037);
            return;
        }
        ButtonClick click = this.getButtonClickType(clickType, dragType);
        MovableButtonAction action = new MovableButtonAction(this.player, click, clickedButton, template, this.page, targetTemplateSlot);
        clickedButton.onClick(action);
        ((Movable)clickedButton).onPickup(action);
        if (action.isCancelled()) {
            this.setPlayersCursor(class_1799.field_8037);
            this.updateSlotStack(targetTemplateSlot, clickedButton.getDisplay(), template instanceof InventoryTemplate);
        } else {
            this.cursorButton = clickedButton;
            this.setButton(slot, null);
            if (clickType == class_1713.field_7796 || clickType == class_1713.field_7794 || clickType == class_1713.field_7795) {
                this.setPlayersCursor(this.cursorButton.getDisplay());
            }
        }
    }

    private void onMovableDrop(int slot, int dragType, class_1713 clickType) {
        Template template = this.getTemplateFromIndex(slot);
        int targetTemplateSlot = this.getTemplateIndex(slot);
        if (clickType == class_1713.field_7793 || slot == -999) {
            this.setPlayersCursor(this.cursorButton.getDisplay());
            return;
        }
        if (this.isSlotOccupied(slot)) {
            this.setPlayersCursor(this.cursorButton.getDisplay());
            if (clickType == class_1713.field_7794 || clickType == class_1713.field_7796 || clickType == class_1713.field_7795) {
                this.method_7605();
            } else if (clickType == class_1713.field_7789) {
                this.updateSlotStack(this.getTemplateIndex(slot), this.getItemAtSlot(slot), this.isSlotInPlayerInventory(slot));
            }
        } else {
            ButtonClick click = this.getButtonClickType(clickType, dragType);
            MovableButtonAction action = new MovableButtonAction(this.player, click, this.cursorButton, template, this.page, targetTemplateSlot);
            this.cursorButton.onClick(action);
            ((Movable)this.cursorButton).onDrop(action);
            if (action.isCancelled()) {
                if (clickType == class_1713.field_7796) {
                    return;
                }
                this.setPlayersCursor(this.cursorButton.getDisplay());
                this.updateSlotStack(targetTemplateSlot, class_1799.field_8037, template instanceof InventoryTemplate);
                if (clickType == class_1713.field_7789) {
                    this.updateAllContainerContents();
                }
            } else {
                this.setButton(slot, this.cursorButton);
                this.cursorButton = null;
                this.setPlayersCursor(class_1799.field_8037);
                if (clickType == class_1713.field_7789) {
                    this.updateAllContainerContents();
                    this.setPlayersCursor(class_1799.field_8037);
                }
            }
        }
    }

    private boolean isSlotOccupied(int slot) {
        if (this.isSlotInPlayerInventory(slot) && this.inventoryTemplate == null) {
            return ((class_1735)this.player.field_7498.field_7761.get(this.getTemplateIndex(slot) + 9)).method_7681();
        }
        return this.getButton(slot) != null;
    }

    public Page getPage() {
        return this.page;
    }

    private void updateAllContainerContents() {
        this.refresh(this.player, this.player.field_7512, (class_2371<class_1799>)this.method_7602());
        this.player.field_7498.method_7623();
        if (this.inventoryTemplate != null) {
            this.refresh(this.player, (class_1703)this.player.field_7498, this.inventoryTemplate.getFullDisplay(this.player));
        } else {
            this.refresh(this.player, (class_1703)this.player.field_7498, (class_2371<class_1799>)this.player.field_7498.method_7602());
        }
    }

    private void refresh(class_3222 player, class_1703 menu, class_2371<class_1799> contents) {
        player.field_13987.method_14364((class_2596)new class_2649(menu.field_7763, menu.method_37421(), contents, player.method_5998(class_1268.field_5808)));
    }

    private void setPlayersCursor(class_1799 stack) {
        class_2653 setCursorSlot = new class_2653(-1, this.player.field_7512.method_37421(), 0, stack);
        this.player.field_13987.method_14364((class_2596)setCursorSlot);
    }

    private void setButton(int slot, Button button) {
        if (slot < 0) {
            return;
        }
        ((TemplateSlot)this.method_7611(slot)).setButton(button);
    }

    public void method_7595(@NotNull class_1657 player) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.page.onClose(new PageAction(this.player, this.page));
        this.page.unsubscribe((Object)this);
        this.field_7761.forEach(slot -> ((TemplateSlot)((Object)slot)).getDelegate().unsubscribe((Object)this));
        this.player.field_7498.method_7623();
        this.refresh(this.player, (class_1703)player.field_7498, (class_2371<class_1799>)player.field_7498.method_7602());
        this.setPlayersCursor(class_1799.field_8037);
        super.method_7595(player);
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return true;
    }

    private Button getButton(int slot) {
        if (slot < 0) {
            return null;
        }
        if (slot >= this.page.getTemplate().getSize()) {
            int targetedPlayerSlotIndex = slot - this.page.getTemplate().getSize();
            if (this.inventoryTemplate != null) {
                return this.inventoryTemplate.getSlot(targetedPlayerSlotIndex).getButton().orElse(null);
            }
            return null;
        }
        return this.page.getTemplate().getSlot(slot).getButton().orElse(null);
    }
}

