/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.gooeylibs2.api.template.types;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.TemplateType;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CraftingTableTemplate
extends Template {
    protected CraftingTableTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(TemplateType.CRAFTING_TABLE, slots);
    }

    public static Builder builder() {
        return new Builder();
    }

    public CraftingTableTemplate set(int index, @Nullable Button button) {
        this.getSlot(index).setButton(button);
        return this;
    }

    public CraftingTableTemplate setGrid(int row, int col, @Nullable Button button) {
        this.getSlot(row * 3 + col + 1).setButton(button);
        return this;
    }

    public CraftingTableTemplate setResultItem(@Nullable Button button) {
        this.getSlot(0).setButton(button);
        return this;
    }

    public CraftingTableTemplate fill(@Nullable Button button) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(button);
        }
        return this;
    }

    public CraftingTableTemplate fillFromList(@Nonnull List<Button> buttons) {
        Iterator<Button> iterator = buttons.iterator();
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(iterator.hasNext() ? iterator.next() : null);
        }
        return this;
    }

    public CraftingTableTemplate fillGrid(@Nullable Button button) {
        for (int i = 1; i < 10; ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(button);
        }
        return this;
    }

    public CraftingTableTemplate fillGridFromList(@Nonnull List<Button> buttons) {
        Iterator<Button> iterator = buttons.iterator();
        for (int i = 1; i < 10; ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(iterator.hasNext() ? iterator.next() : null);
        }
        return this;
    }

    public CraftingTableTemplate clear() {
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            this.getSlot(slotIndex).setButton(null);
        }
        return this;
    }

    @Override
    public CraftingTableTemplate clone() {
        TemplateSlotDelegate[] clonedSlots = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            Button button = this.getSlot(i).getButton().orElse(null);
            clonedSlots[i] = new TemplateSlotDelegate(button, i);
        }
        return new CraftingTableTemplate(clonedSlots);
    }

    public static class Builder {
        private CraftingTableTemplate templateInstance = new CraftingTableTemplate(TemplateHelper.slotsOf(10));

        public Builder set(int index, @Nullable Button button) {
            this.templateInstance.set(index, button);
            return this;
        }

        public Builder setGrid(int row, int col, @Nullable Button button) {
            this.templateInstance.setGrid(row, col, button);
            return this;
        }

        public Builder setResultItem(@Nullable Button button) {
            this.templateInstance.setResultItem(button);
            return this;
        }

        public Builder fill(@Nullable Button button) {
            this.templateInstance.fill(button);
            return this;
        }

        public Builder fillFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.fillFromList(buttons);
            return this;
        }

        public Builder fillGrid(@Nullable Button button) {
            this.templateInstance.fillGrid(button);
            return this;
        }

        public Builder fillGridFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.fillGridFromList(buttons);
            return this;
        }

        public CraftingTableTemplate build() {
            CraftingTableTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new CraftingTableTemplate(TemplateHelper.slotsOf(10));
            return templateToReturn;
        }
    }
}

