/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.gooeylibs2.api.template.types;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.TemplateType;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DispenserTemplate
extends Template {
    protected DispenserTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(TemplateType.DISPENSER, slots);
    }

    public TemplateSlotDelegate getSlot(int row, int col) {
        return this.getSlot(row * 3 + col);
    }

    public DispenserTemplate set(int index, @Nullable Button button) {
        this.getSlot(index).setButton(button);
        return this;
    }

    public DispenserTemplate set(int row, int col, @Nullable Button button) {
        return this.set(row * 3 + col, button);
    }

    public DispenserTemplate fill(@Nullable Button button) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(button);
        }
        return this;
    }

    public DispenserTemplate fillFromList(@Nonnull List<Button> buttons) {
        Iterator<Button> iterator = buttons.iterator();
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(iterator.hasNext() ? iterator.next() : null);
        }
        return this;
    }

    public DispenserTemplate clear() {
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            this.getSlot(slotIndex).setButton(null);
        }
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DispenserTemplate clone() {
        TemplateSlotDelegate[] clonedSlots = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            Button button = this.getSlot(i).getButton().orElse(null);
            clonedSlots[i] = new TemplateSlotDelegate(button, i);
        }
        return new DispenserTemplate(clonedSlots);
    }

    public static class Builder {
        private DispenserTemplate templateInstance = new DispenserTemplate(TemplateHelper.slotsOf(10));

        public Builder set(int index, @Nullable Button button) {
            this.templateInstance.set(index, button);
            return this;
        }

        public Builder set(int row, int col, @Nullable Button button) {
            this.templateInstance.set(row, col, button);
            return this;
        }

        public Builder fill(@Nullable Button button) {
            this.templateInstance.fill(button);
            return this;
        }

        public Builder fillFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.fillFromList(buttons);
            return this;
        }

        public DispenserTemplate build() {
            DispenserTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new DispenserTemplate(TemplateHelper.slotsOf(10));
            return templateToReturn;
        }
    }
}

