/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.gooeylibs2.api.template.types;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.TemplateType;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FurnaceTemplate
extends Template {
    public FurnaceTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(TemplateType.FURNACE, slots);
    }

    public TemplateSlotDelegate getInputMaterial() {
        return this.getSlot(0);
    }

    public TemplateSlotDelegate getFuel() {
        return this.getSlot(1);
    }

    public TemplateSlotDelegate getOutputMaterial() {
        return this.getSlot(2);
    }

    public FurnaceTemplate inputMaterial(@Nullable Button button) {
        this.getSlot(0).setButton(button);
        return this;
    }

    public FurnaceTemplate fuel(@Nullable Button button) {
        this.getSlot(1).setButton(button);
        return this;
    }

    public FurnaceTemplate outputMaterial(@Nullable Button button) {
        this.getSlot(2).setButton(button);
        return this;
    }

    public FurnaceTemplate clear() {
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            this.getSlot(slotIndex).setButton(null);
        }
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public FurnaceTemplate clone() {
        TemplateSlotDelegate[] clonedSlots = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            Button button = this.getSlot(i).getButton().orElse(null);
            clonedSlots[i] = new TemplateSlotDelegate(button, i);
        }
        return new FurnaceTemplate(clonedSlots);
    }

    public static class Builder {
        private FurnaceTemplate templateInstance = new FurnaceTemplate(TemplateHelper.slotsOf(3));

        public Builder inputMaterial(@Nullable Button button) {
            this.templateInstance.inputMaterial(button);
            return this;
        }

        public Builder fuel(@Nullable Button button) {
            this.templateInstance.fuel(button);
            return this;
        }

        public Builder outputMaterial(@Nullable Button button) {
            this.templateInstance.outputMaterial(button);
            return this;
        }

        public FurnaceTemplate build() {
            FurnaceTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new FurnaceTemplate(TemplateHelper.slotsOf(3));
            return templateToReturn;
        }
    }
}

