/*
 * Decompiled with CFR 0.152.
 */
package ca.landonjw.gooeylibs2.api.template.types;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.InventoryListenerButton;
import ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import ca.landonjw.gooeylibs2.api.template.LineType;
import ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;

public final class InventoryTemplate
extends ChestTemplate {
    protected InventoryTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(slots);
    }

    public class_1799 getDisplayForSlot(@Nonnull class_3222 player, int index) {
        Optional<Button> slot = this.getSlot(index).getButton();
        if (slot.isPresent() && slot.get() instanceof InventoryListenerButton) {
            return (class_1799)player.field_7512.method_7602().get(index + 9);
        }
        if (slot.isPresent()) {
            return slot.get().getDisplay();
        }
        return class_1799.field_8037;
    }

    @Override
    public InventoryTemplate clone() {
        TemplateSlotDelegate[] references = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            int row = i / 9;
            int col = i % 9;
            Optional<Button> button = this.getSlot(i).getButton();
            references[i] = new TemplateSlotDelegate(button.orElse(null), col + row * 9);
        }
        return new InventoryTemplate(references);
    }

    @Deprecated
    public class_2371<class_1799> getFullDisplay(@Nonnull class_3222 player) {
        int i;
        class_2371 displays = class_2371.method_10211();
        int PLAYER_INVENTORY_OFFSET = 8;
        for (i = 0; i <= PLAYER_INVENTORY_OFFSET; ++i) {
            displays.add((Object)class_1799.field_8037);
        }
        for (i = 0; i < this.getSize(); ++i) {
            displays.add((Object)this.getDisplayForSlot(player, i));
        }
        return displays;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InventoryTemplate templateInstance = new InventoryTemplate(TemplateHelper.slotsOf(36));

        public Builder set(int index, @Nullable Button button) {
            this.templateInstance.set(index, button);
            return this;
        }

        public Builder set(int row, int col, @Nullable Button button) {
            this.templateInstance.set(row, col, button);
            return this;
        }

        public Builder row(int row, @Nullable Button button) {
            this.templateInstance.row(row, button);
            return this;
        }

        public Builder rowFromList(int row, @Nonnull List<Button> buttons) {
            this.templateInstance.rowFromList(row, buttons);
            return this;
        }

        public Builder column(int col, @Nullable Button button) {
            this.templateInstance.column(col, button);
            return this;
        }

        public Builder columnFromList(int col, @Nonnull List<Button> buttons) {
            this.templateInstance.columnFromList(col, buttons);
            return this;
        }

        public Builder line(@Nonnull LineType lineType, int startRow, int startCol, int length, @Nullable Button button) {
            this.templateInstance.line(lineType, startRow, startCol, length, button);
            return this;
        }

        public Builder lineFromList(@Nonnull LineType lineType, int startRow, int startCol, int length, @Nonnull List<Button> buttons) {
            this.templateInstance.lineFromList(lineType, startRow, startCol, length, buttons);
            return this;
        }

        public Builder square(int startRow, int startCol, int size, @Nullable Button button) {
            this.templateInstance.square(startRow, startCol, size, button);
            return this;
        }

        public Builder squareFromList(int startRow, int startCol, int size, @Nonnull List<Button> buttons) {
            this.templateInstance.squareFromList(startRow, startCol, size, buttons);
            return this;
        }

        public Builder rectangle(int startRow, int startCol, int length, int width, @Nullable Button button) {
            this.templateInstance.rectangle(startRow, startCol, length, width, button);
            return this;
        }

        public Builder rectangleFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons) {
            this.templateInstance.rectangleFromList(startRow, startCol, length, width, buttons);
            return this;
        }

        public Builder border(int startRow, int startCol, int length, int width, @Nullable Button button) {
            this.templateInstance.border(startRow, startCol, length, width, button);
            return this;
        }

        public Builder borderFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons) {
            this.templateInstance.borderFromList(startRow, startCol, length, width, buttons);
            return this;
        }

        public Builder checker(int startRow, int startCol, int length, int width, @Nullable Button button, @Nullable Button button2) {
            this.templateInstance.checker(startRow, startCol, length, width, button, button2);
            return this;
        }

        public Builder checkerFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons, @Nonnull List<Button> buttons2) {
            this.templateInstance.checkerFromList(startRow, startCol, length, width, buttons, buttons2);
            return this;
        }

        public Builder fill(@Nullable Button button) {
            this.templateInstance.fill(button);
            return this;
        }

        public Builder fillFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.fillFromList(buttons);
            return this;
        }

        public InventoryTemplate build() {
            InventoryTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new InventoryTemplate(TemplateHelper.slotsOf(36));
            return templateToReturn;
        }
    }
}

