/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.core;

import com.blamejared.crafttweaker.api.plugin.IReplacerComponentRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingFilter;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2960;

final class ReplacerComponentsRegistrationHandler
implements IReplacerComponentRegistrationHandler {
    private final Collection<ITargetingFilter> filters = new ArrayList<ITargetingFilter>();
    private final Map<class_2960, ITargetingStrategy> strategies = new HashMap<class_2960, ITargetingStrategy>();

    ReplacerComponentsRegistrationHandler() {
    }

    static ReplacerComponentsRegistrationHandler of(Consumer<IReplacerComponentRegistrationHandler> consumer) {
        ReplacerComponentsRegistrationHandler handler = new ReplacerComponentsRegistrationHandler();
        consumer.accept(handler);
        return handler;
    }

    @Override
    public void registerTargetingFilter(ITargetingFilter filter) {
        this.filters.add(Objects.requireNonNull(filter));
    }

    @Override
    public void registerTargetingStrategy(class_2960 id, ITargetingStrategy strategy) {
        if (this.strategies.containsKey(id)) {
            throw new IllegalArgumentException("A targeting strategy with id " + id + " already exists");
        }
        this.strategies.put(id, strategy);
    }

    Collection<ITargetingFilter> filters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    Map<class_2960, ITargetingStrategy> strategies() {
        return Collections.unmodifiableMap(this.strategies);
    }
}

