/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.function.Consumer;
import me.timvinci.config.ConfigProperty;
import me.timvinci.config.PropertyRange;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public abstract class BaseConfigManager<T> {
    protected final Path configFilePath;
    protected T config;
    protected final Logger logger;

    protected BaseConfigManager(String configFileName, Logger logger) {
        this.configFilePath = FabricLoader.getInstance().getConfigDir().resolve(configFileName);
        this.config = this.getDefaultConfig();
        this.logger = logger;
    }

    protected abstract T getDefaultConfig();

    public void loadConfig() {
        CommentedFileConfig fileConfig = this.buildFileConfig(this.configFilePath);
        if (this.loadFileConfigFailed(fileConfig, "using default values for all properties")) {
            return;
        }
        if (!fileConfig.getFile().exists() || fileConfig.isEmpty()) {
            fileConfig.close();
            this.saveConfig();
        } else {
            this.loadAnnotatedProperties(fileConfig);
            fileConfig.close();
        }
    }

    public boolean saveConfig() {
        CommentedFileConfig fileConfig = this.buildFileConfig(this.configFilePath);
        if (this.loadFileConfigFailed(fileConfig, "couldn't save values to config file")) {
            return false;
        }
        boolean hasNoErrors = this.writeAnnotatedProperties(fileConfig);
        fileConfig.save();
        fileConfig.close();
        return hasNoErrors;
    }

    protected void loadAnnotatedProperties(CommentedFileConfig fileConfig) {
        for (Field field : this.config.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            if (field.trySetAccessible()) {
                ConfigProperty property = field.getAnnotation(ConfigProperty.class);
                String propertyKey = property.key();
                if (field.isAnnotationPresent(PropertyRange.class)) {
                    PropertyRange range = field.getAnnotation(PropertyRange.class);
                    this.loadIntegerProperty(fileConfig, propertyKey, value -> this.setFieldValue(field, value, propertyKey), range.min(), range.max());
                    continue;
                }
                if (field.getType().isEnum()) {
                    this.loadEnumProperty(fileConfig, propertyKey, value -> this.setFieldValue(field, value, propertyKey), field.getType());
                    continue;
                }
                this.loadProperty(fileConfig, propertyKey, value -> this.setFieldValue(field, value, propertyKey));
                continue;
            }
            this.logger.error("Failed to set field '{}' as accessible, please submit a github bug report about this.", (Object)field.getName());
        }
    }

    protected void setFieldValue(Field field, Object value, String propertyKey) {
        try {
            field.set(this.config, value);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Failed to set field value of configuration property '{}'.", (Object)propertyKey, (Object)e);
        }
    }

    protected boolean writeAnnotatedProperties(CommentedFileConfig fileConfig) {
        T newConfigInstance = this.getDefaultConfig();
        boolean hasNoErrors = true;
        boolean firstField = true;
        for (Field field : this.config.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            if (field.trySetAccessible()) {
                ConfigProperty property = field.getAnnotation(ConfigProperty.class);
                String propertyKey = property.key();
                Object fieldValue = this.getFieldValue(field, this.config, propertyKey);
                if (fieldValue != null) {
                    fileConfig.set(propertyKey, fieldValue);
                    Object propertyComment = property.comment();
                    if (!firstField) {
                        propertyComment = "==========\n" + (String)propertyComment;
                    }
                    if (field.isAnnotationPresent(PropertyRange.class)) {
                        PropertyRange range = field.getAnnotation(PropertyRange.class);
                        propertyComment = (String)propertyComment + "\nRange: " + range.min() + " to " + range.max() + ", inclusive";
                    }
                    propertyComment = (String)propertyComment + "\nDefault: " + this.getFieldValue(field, newConfigInstance, propertyKey).toString();
                    fileConfig.setComment(propertyKey, (String)propertyComment);
                } else if (hasNoErrors) {
                    hasNoErrors = false;
                }
            } else {
                this.logger.error("Failed to set field '{}' as accessible, please submit a github bug report about this.", (Object)field.getName());
                if (hasNoErrors) {
                    hasNoErrors = false;
                }
            }
            if (!firstField) continue;
            firstField = false;
        }
        return hasNoErrors;
    }

    protected Object getFieldValue(Field field, T instance, String propertyKey) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Failed to get field value of configuration property '{}'.", (Object)propertyKey, (Object)e);
            return null;
        }
    }

    protected <P> void loadProperty(CommentedFileConfig fileConfig, String propertyKey, Consumer<P> propertySetter) {
        if (this.missingProperty(fileConfig, propertyKey)) {
            return;
        }
        try {
            propertySetter.accept(fileConfig.get(propertyKey));
        }
        catch (ClassCastException e) {
            this.logger.error("Configuration property '{}' is of the wrong type, using default value instead.", (Object)propertyKey);
        }
    }

    protected <P extends Enum<P>> void loadEnumProperty(CommentedFileConfig fileConfig, String propertyKey, Consumer<P> propertySetter, Class<P> enumClass) {
        if (this.missingProperty(fileConfig, propertyKey)) {
            return;
        }
        String enumAsString = (String)fileConfig.get(propertyKey);
        try {
            P enumValue = Enum.valueOf(enumClass, enumAsString);
            propertySetter.accept(enumValue);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Configuration property '{}' isn't properly set in the config file, using default value instead.", (Object)propertyKey);
        }
    }

    protected void loadIntegerProperty(CommentedFileConfig fileConfig, String propertyKey, Consumer<Integer> propertySetter, int min, int max) {
        if (this.missingProperty(fileConfig, propertyKey)) {
            return;
        }
        int propertyValue = fileConfig.getInt(propertyKey);
        if (propertyValue >= min && propertyValue <= max) {
            propertySetter.accept(propertyValue);
        } else {
            this.logger.error("Configuration property '{}' isn't in its bound range, using default value instead.", (Object)propertyKey);
        }
    }

    private boolean missingProperty(CommentedFileConfig fileConfig, String propertyKey) {
        if (!fileConfig.contains(propertyKey)) {
            this.logger.error("Configuration property '{}' is missing from the config file, using default value instead.", (Object)propertyKey);
            return true;
        }
        return false;
    }

    private boolean loadFileConfigFailed(CommentedFileConfig fileConfig, String additionalInfo) {
        try {
            fileConfig.load();
            return false;
        }
        catch (ParsingException e) {
            this.logger.error("Configuration parsing failed, {}. Exception message: {}", new Object[]{additionalInfo, e.getMessage(), e});
            return true;
        }
    }

    private CommentedFileConfig buildFileConfig(Path configFilePath) {
        return (CommentedFileConfig)CommentedFileConfig.builder((Path)configFilePath).sync().autosave().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
    }

    public T getConfig() {
        return this.config;
    }
}

