/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.config;

import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import me.timvinci.TerrastorageClient;
import me.timvinci.config.BaseConfigManager;
import me.timvinci.config.ConfigProperty;
import me.timvinci.config.TerrastorageClientConfig;
import me.timvinci.util.LocalizedTextProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_7172;

@Environment(value=EnvType.CLIENT)
public class ClientConfigManager
extends BaseConfigManager<TerrastorageClientConfig> {
    private static ClientConfigManager instance;

    public ClientConfigManager() {
        super("terrastorage_client.toml", TerrastorageClient.CLIENT_LOGGER);
    }

    public static void init() {
        instance = new ClientConfigManager();
        instance.loadConfig();
    }

    public static ClientConfigManager getInstance() {
        return instance;
    }

    @Override
    protected TerrastorageClientConfig getDefaultConfig() {
        return new TerrastorageClientConfig();
    }

    public <E extends Enum<E>> class_7172<?>[] asOption() {
        ArrayList<class_7172> options = new ArrayList<class_7172>();
        class_2561[] optionButtonTooltipText = LocalizedTextProvider.getOptionButtonsTooltipText();
        int i = 0;
        for (Field field : ((TerrastorageClientConfig)this.config).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            if (field.trySetAccessible()) {
                ConfigProperty property = field.getAnnotation(ConfigProperty.class);
                String propertyKey = property.key();
                String translationKey = "terrastorage.option." + propertyKey;
                Object fieldValue = this.getFieldValue(field, (TerrastorageClientConfig)this.config, propertyKey);
                if (fieldValue == null) continue;
                class_7172 option = null;
                if (fieldValue.getClass().equals(Boolean.class)) {
                    option = class_7172.method_47604((String)translationKey, (class_7172.class_7277)class_7172.method_42717((class_2561)optionButtonTooltipText[i]), (text, value) -> class_2561.method_43471((String)(translationKey + (value != false ? ".true" : ".false"))), (boolean)((Boolean)fieldValue), newValue -> this.setFieldValue(field, newValue, propertyKey));
                } else if (fieldValue.getClass().isEnum()) {
                    Enum currentValue = (Enum)fieldValue;
                    Class enumClass = currentValue.getDeclaringClass();
                    option = new class_7172(translationKey, class_7172.method_42717((class_2561)optionButtonTooltipText[i]), (text, value) -> class_2561.method_43471((String)(translationKey + "." + value.name().toLowerCase(Locale.ENGLISH))), (class_7172.class_7178)new class_7172.class_7173(Arrays.asList((Enum[])enumClass.getEnumConstants()), Codec.STRING.xmap(string -> Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(e -> e.name().equalsIgnoreCase((String)string)).findFirst().orElse(null), newValue -> newValue.name().toLowerCase(Locale.ENGLISH))), (Object)currentValue, newValue -> this.setFieldValue(field, newValue, propertyKey));
                }
                if (option == null) continue;
                options.add(i++, option);
                continue;
            }
            this.logger.error("Failed to set field '{}' as accessible, please submit a github bug report about this.", (Object)field.getName());
        }
        return (class_7172[])options.toArray(class_7172[]::new);
    }
}

