/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.inventory;

import compasses.expandedstorage.api.ExpandedStorageAccessors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.timvinci.config.ConfigManager;
import me.timvinci.config.TerrastorageConfig;
import me.timvinci.inventory.CompleteInventoryState;
import me.timvinci.inventory.InventoryState;
import me.timvinci.item.GhostItemEntity;
import me.timvinci.util.SortType;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtils {
    public static boolean expandedStorageLoaded = false;

    public static void transferStack(class_1263 to, CompleteInventoryState receiverState, class_1799 stack) {
        class_1792 stackItem = stack.method_7909();
        if (receiverState.getNonFullItemSlots().containsKey(stackItem) && InventoryUtils.transferToExistingStack(to, receiverState, stack)) {
            return;
        }
        if (!receiverState.getEmptySlots().isEmpty()) {
            int emptySlot = receiverState.getEmptySlots().poll();
            to.method_5447(emptySlot, stack.method_51164());
            receiverState.setModified();
            if (stack.method_7947() != stack.method_7914()) {
                receiverState.getNonFullItemSlots().computeIfAbsent(stackItem, k -> new ArrayList()).add(emptySlot);
            }
        }
    }

    public static boolean transferToExistingStack(class_1263 to, InventoryState receiverState, class_1799 stackToTransfer) {
        class_1792 stackItem = stackToTransfer.method_7909();
        ArrayList<Integer> slotsWithItem = receiverState.getNonFullItemSlots().get(stackItem);
        Iterator<Integer> slotsIterator = slotsWithItem.iterator();
        while (slotsIterator.hasNext() && !stackToTransfer.method_7960()) {
            int transferAmount;
            int slotWithItem = slotsIterator.next();
            class_1799 existingStack = to.method_5438(slotWithItem);
            if (!Objects.equals(existingStack.method_7969(), stackToTransfer.method_7969())) continue;
            int spaceLeft = existingStack.method_7914() - existingStack.method_7947();
            if (spaceLeft <= stackToTransfer.method_7947()) {
                transferAmount = spaceLeft;
                slotsIterator.remove();
            } else {
                transferAmount = stackToTransfer.method_7947();
            }
            existingStack.method_7933(transferAmount);
            stackToTransfer.method_7934(transferAmount);
            receiverState.setModified();
        }
        if (slotsWithItem.isEmpty()) {
            receiverState.getNonFullItemSlots().remove(stackItem);
        }
        return stackToTransfer.method_7960();
    }

    /*
     * Exception decompiling
     */
    public static List<class_1799> combineAndSortInventory(class_1263 inventory, SortType type, int startIndex, int endIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isShulkerBox(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1747 && ((class_1747)itemStack.method_7909()).method_7711() instanceof class_2480;
    }

    public static List<Pair<class_1263, class_243>> getNearbyStorages(class_3222 player) {
        class_1937 world = player.method_37908();
        ArrayList<Pair<class_1263, class_243>> nearbyStorages = new ArrayList<Pair<class_1263, class_243>>();
        HashSet processedChests = new HashSet();
        int range = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getQuickStackRange();
        boolean performLosCheck = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getLineOfSightCheck();
        class_2338 playerPos = player.method_24515();
        class_2338.method_25996((class_2338)playerPos, (int)range, (int)range, (int)range).forEach(pos -> {
            class_1263 inventory;
            if (processedChests.contains(pos)) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_26215() || !state.method_31709()) {
                return;
            }
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5439() >= 27) {
                class_243 losPoint;
                if (performLosCheck) {
                    losPoint = InventoryUtils.hasLineOfSight(player, world, pos);
                    if (losPoint == class_243.field_1353) {
                        return;
                    }
                } else {
                    losPoint = pos.method_46558();
                }
                if (blockEntity instanceof class_2595) {
                    class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
                    if (chestType == class_2745.field_12569) {
                        nearbyStorages.add(Pair.of((Object)inventory, (Object)losPoint));
                        return;
                    }
                    class_2338 neighboringChestPos = InventoryUtils.getNeighboringChestPos(pos, chestType, (class_2350)state.method_11654((class_2769)class_2281.field_10768));
                    class_243 doubleChestLosPoint = InventoryUtils.getDoubleChestCenter(losPoint, neighboringChestPos.method_46558());
                    class_1263 neighboringChestInventory = (class_1263)world.method_8321(neighboringChestPos);
                    nearbyStorages.add(Pair.of((Object)new class_1258(inventory, neighboringChestInventory), (Object)doubleChestLosPoint));
                    processedChests.add(neighboringChestPos);
                } else if (expandedStorageLoaded) {
                    Optional attachedChestDirection = ExpandedStorageAccessors.getAttachedChestDirection((class_2680)state);
                    if (attachedChestDirection.isEmpty()) {
                        nearbyStorages.add(Pair.of((Object)inventory, (Object)losPoint));
                        return;
                    }
                    class_2338 neighboringChestPos = pos.method_10093((class_2350)attachedChestDirection.get());
                    class_243 doubleChestLosPoint = InventoryUtils.getDoubleChestCenter(losPoint, neighboringChestPos.method_46558());
                    class_1263 neighboringChestInventory = (class_1263)world.method_8321(neighboringChestPos);
                    nearbyStorages.add(Pair.of((Object)new class_1258(inventory, neighboringChestInventory), (Object)doubleChestLosPoint));
                    processedChests.add(neighboringChestPos);
                } else {
                    nearbyStorages.add(Pair.of((Object)inventory, (Object)losPoint));
                }
            }
        });
        class_238 searchBox = new class_238(playerPos).method_1014((double)range);
        world.method_18023(class_5575.method_31795(class_1297.class), searchBox, entity -> {
            class_1263 inventory;
            return entity instanceof class_1263 && (inventory = (class_1263)entity).method_5439() >= 27;
        }).forEach(entity -> {
            class_243 losPoint;
            if (performLosCheck) {
                losPoint = InventoryUtils.hasLineOfSightToEntity(player, world, entity);
                if (losPoint == class_243.field_1353) {
                    return;
                }
            } else {
                losPoint = entity.method_5829().method_1005();
            }
            nearbyStorages.add(Pair.of((Object)((class_1263)entity), (Object)losPoint));
        });
        return nearbyStorages;
    }

    private static class_2338 getNeighboringChestPos(class_2338 chestBlockPos, class_2745 chestType, class_2350 facing) {
        return chestBlockPos.method_10093(chestType == class_2745.field_12574 ? facing.method_10170() : facing.method_10160());
    }

    private static class_243 getDoubleChestCenter(class_243 losPoint, class_243 secondChestCenter) {
        return losPoint.method_1031(secondChestCenter.field_1352, losPoint.field_1351, secondChestCenter.field_1350).method_1021(0.5);
    }

    private static class_243 hasLineOfSight(class_3222 player, class_1937 world, class_2338 pos) {
        class_243[] pointsToCheck;
        class_243 playerEyes = player.method_33571();
        class_243 centerPos = pos.method_46558();
        for (class_243 end : pointsToCheck = new class_243[]{centerPos, centerPos.method_1031(0.0, 0.5, 0.0), centerPos.method_1031(0.0, -0.5, 0.0)}) {
            class_3959 context = new class_3959(playerEyes, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 hitResult = world.method_17742(context);
            if (!hitResult.method_17777().equals((Object)pos) && hitResult.method_17783() != class_239.class_240.field_1333) continue;
            return end;
        }
        return class_243.field_1353;
    }

    private static class_243 hasLineOfSightToEntity(class_3222 player, class_1937 world, class_1297 entity) {
        class_243 end;
        class_243 playerEyes = player.method_33571();
        class_3965 result = world.method_17742(new class_3959(playerEyes, end = entity.method_5829().method_1005(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return result.method_17783() == class_239.class_240.field_1333 ? end : class_243.field_1353;
    }

    public static void triggerFlyOutAnimation(class_3218 world, class_243 playerEyes, Map<class_243, ArrayList<class_1792>> animationMap) {
        int itemAnimationLength = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getItemAnimationLength();
        int itemAnimationInterval = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getItemAnimationInterval();
        for (Map.Entry<class_243, ArrayList<class_1792>> entry : animationMap.entrySet()) {
            class_243 targetPos = entry.getKey();
            class_243 itemVelocity = new class_243((targetPos.field_1352 - playerEyes.field_1352) / (double)itemAnimationLength, (targetPos.field_1351 - playerEyes.field_1351) / (double)itemAnimationLength, (targetPos.field_1350 - playerEyes.field_1350) / (double)itemAnimationLength);
            ArrayList<class_1792> items = entry.getValue();
            for (int i = 0; i < items.size(); ++i) {
                int movementDelay = i * itemAnimationInterval;
                GhostItemEntity ghostItem = new GhostItemEntity((class_1937)world, playerEyes.field_1352, playerEyes.field_1351, playerEyes.field_1350, items.get(i).method_7854(), itemVelocity, itemAnimationLength, movementDelay);
                world.method_8649((class_1297)ghostItem);
            }
        }
    }
}

