/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.network;

import me.timvinci.util.SortType;
import me.timvinci.util.StorageAction;
import me.timvinci.util.TerrastorageCore;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1735;
import net.minecraft.class_1736;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PacketRegistry {
    public static final class_2960 storageActionIdentifier = new class_2960("terrastorage", "storage_action");
    public static final class_2960 storageSortIdentifier = new class_2960("terrastorage", "storage_sort_action");
    public static final class_2960 renameIdentifier = new class_2960("terrastorage", "rename_action");
    public static final class_2960 playerSortIdentifier = new class_2960("terrastorage", "player_sort_action");
    public static final class_2960 blockRenamedIdentifier = new class_2960("terrastorage", "block_renamed_update");
    public static final class_2960 serverConfigIdentifier = new class_2960("terrastorage", "server_config_update");

    public static void registerPacketReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)storageActionIdentifier, (server, player, handler, buf, responseSender) -> {
            StorageAction action = (StorageAction)buf.method_10818(StorageAction.class);
            boolean hotbarProtection = buf.readBoolean();
            server.execute(() -> PacketRegistry.processStorageActionPacket(player, action, hotbarProtection));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)storageSortIdentifier, (server, player, handler, buf, responseSender) -> {
            SortType type = (SortType)buf.method_10818(SortType.class);
            server.execute(() -> PacketRegistry.processStorageSortPacket(player, type));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)renameIdentifier, (server, player, handler, buf, responseSender) -> {
            String newName = buf.method_19772();
            server.execute(() -> PacketRegistry.processRenamePacket(player, newName));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)playerSortIdentifier, (server, player, handler, buf, responseSender) -> {
            SortType type = (SortType)buf.method_10818(SortType.class);
            boolean hotbarProtection = buf.readBoolean();
            server.execute(() -> PacketRegistry.processPlayerSortPacket(player, type, hotbarProtection));
        });
    }

    private static void processStorageActionPacket(class_3222 player, StorageAction action, boolean hotbarProtection) {
        if (action == StorageAction.QUICK_STACK_TO_NEARBY) {
            TerrastorageCore.quickStackToNearbyStorages(player, hotbarProtection);
            return;
        }
        if (player.field_7512.field_7761.size() - 36 < 27) {
            return;
        }
        class_1263 storageInventory = ((class_1735)player.field_7512.field_7761.get((int)0)).field_7871;
        boolean storageIsShulkerBox = player.field_7512.field_7761.get(0) instanceof class_1736;
        switch (action) {
            case LOOT_ALL: {
                TerrastorageCore.lootAll(player.method_31548(), storageInventory, hotbarProtection);
                break;
            }
            case DEPOSIT_ALL: {
                TerrastorageCore.depositAll(player.method_31548(), storageInventory, hotbarProtection, storageIsShulkerBox);
                break;
            }
            case QUICK_STACK: {
                TerrastorageCore.quickStack(player.method_31548(), storageInventory, hotbarProtection);
                break;
            }
            case RESTOCK: {
                TerrastorageCore.restock(player.method_31548(), storageInventory, hotbarProtection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown storage action: " + String.valueOf((Object)action));
            }
        }
    }

    private static void processStorageSortPacket(class_3222 player, SortType type) {
        if (player.field_7512.field_7761.size() - 36 < 27) {
            return;
        }
        class_1263 storageInventory = ((class_1735)player.field_7512.field_7761.get((int)0)).field_7871;
        TerrastorageCore.sortStorageItems(storageInventory, type);
    }

    private static void processRenamePacket(class_3222 player, String newName) {
        if (player.field_7512 == null) {
            return;
        }
        TerrastorageCore.renameStorage(player, newName);
    }

    private static void processPlayerSortPacket(class_3222 player, SortType type, boolean hotbarProtection) {
        TerrastorageCore.sortPlayerItems(player.method_31548(), type, hotbarProtection);
    }
}

