/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5253;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class DecorationTableBlockEntity
extends class_2586 {
    public static final int TOP_INNER_TRIM_SLOT = 0;
    public static final int TOP_TRIM_SLOT = 1;
    public static final int SIDE_TRIM_SLOT = 2;
    public static final int BOTTOM_TRIM_SLOT = 3;
    public static final int TOP_CORE_SLOT = 4;
    public static final int SIDE_CORE_SLOT = 5;
    public static final int BOTTOM_CORE_SLOT = 6;
    public static final int RED_DYE_SLOT = 0;
    public static final int GREEN_DYE_SLOT = 1;
    public static final int BLUE_DYE_SLOT = 2;
    public static final int BLOCK_TOTAL_PARTS = 24;
    private static final int MAIN_COLOR_PARTS = 18;
    private static final int ACCENT_COLOR_PARTS = 6;
    private static final Map<Integer, Integer> DECORATIVE_SLOT_PARTS_NEEDED = Map.of(0, 1, 1, 1, 2, 4, 3, 1, 4, 3, 5, 12, 6, 3);
    private static final Set<class_1792> STORAGES_WIHOUT_TOP_INNER_TRIM = Set.of(ModBlocks.BARREL_ITEM, ModBlocks.COPPER_BARREL_ITEM, ModBlocks.IRON_BARREL_ITEM, ModBlocks.GOLD_BARREL_ITEM, ModBlocks.DIAMOND_BARREL_ITEM, ModBlocks.NETHERITE_BARREL_ITEM, ModBlocks.LIMITED_BARREL_1_ITEM, ModBlocks.LIMITED_COPPER_BARREL_1_ITEM, ModBlocks.LIMITED_IRON_BARREL_1_ITEM, ModBlocks.LIMITED_GOLD_BARREL_1_ITEM, ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM, ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM);
    private final Map<class_2960, Integer> remainingParts = new HashMap<class_2960, Integer>();
    private final ItemStackHandler decorativeBlocks = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return resource.getItem() instanceof class_1747 && !(resource.getItem() instanceof StorageBlockItem);
        }
    };
    private final ItemStackHandler dyes = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return switch (slot) {
                case 0 -> resource.toStack().method_31573(ConventionalItemTags.RED_DYES);
                case 1 -> resource.toStack().method_31573(ConventionalItemTags.GREEN_DYES);
                case 2 -> resource.toStack().method_31573(ConventionalItemTags.BLUE_DYES);
                default -> false;
            };
        }
    };
    private final ItemStackHandler storageBlock = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return resource.getItem() instanceof StorageBlockItem;
        }
    };
    private class_1799 result = class_1799.field_8037;
    private final Map<Integer, Boolean> slotMaterialInheritance = new HashMap<Integer, Boolean>();
    private int accentColor = -1;
    private int mainColor = -1;
    private final Set<class_2960> missingDyes = new HashSet<class_2960>();

    public void updateResultAndSetChanged() {
        this.updateResult();
        this.method_5431();
    }

    private void updateResult() {
        this.missingDyes.clear();
        class_1799 storage = this.storageBlock.getStackInSlot(0);
        if (storage.method_7960() || (InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks) || !(storage.method_7909() instanceof BarrelBlockItem) || this.isTintedStorage(storage)) && this.colorsTransparentOrSameAs(storage)) {
            this.result = class_1799.field_8037;
            return;
        }
        if (!(storage.method_7909() instanceof BarrelBlockItem) || InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks) || this.isTintedStorage(storage)) {
            class_1747 blockItem;
            this.result = storage.method_7972();
            this.result.method_7939(1);
            class_1792 class_17922 = this.result.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)blockItem;
                if (this.mainColor != -1) {
                    tintableBlockItem.setMainColor(this.result, this.mainColor & 0xFFFFFF);
                }
                if (this.accentColor != -1) {
                    tintableBlockItem.setAccentColor(this.result, this.accentColor & 0xFFFFFF);
                }
            }
            this.calculateMissingDyes(storage);
            return;
        }
        if (InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks)) {
            this.result = class_1799.field_8037;
            return;
        }
        EnumMap<BarrelMaterial, class_2960> materials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(storage));
        BarrelBlockItem.uncompactMaterials(materials);
        this.setMaterialsFromDecorativeBlocks(materials, !STORAGES_WIHOUT_TOP_INNER_TRIM.contains(storage.method_7909()));
        BarrelBlockItem.compactMaterials(materials);
        if (this.allMaterialsMatch(materials, BarrelBlockItem.getMaterials(storage))) {
            this.result = class_1799.field_8037;
            return;
        }
        this.result = storage.method_7972();
        this.result.method_7939(1);
        BarrelBlockItem.removeCoveredTints(this.result, materials);
        BarrelBlockItem.setMaterials(this.result, materials);
    }

    private boolean isTintedStorage(class_1799 storage) {
        return StorageBlockItem.getMainColorFromStack(storage).isPresent() || StorageBlockItem.getAccentColorFromStack(storage).isPresent();
    }

    private boolean allMaterialsMatch(Map<BarrelMaterial, class_2960> newMaterials, Map<BarrelMaterial, class_2960> currentMaterials) {
        if (newMaterials.size() != currentMaterials.size()) {
            return false;
        }
        for (Map.Entry<BarrelMaterial, class_2960> entry : newMaterials.entrySet()) {
            if (entry.getValue().equals((Object)currentMaterials.get((Object)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private void calculateMissingDyes(class_1799 storage) {
        if (!(this.dyes.getStackInSlot(0).method_7960() || this.dyes.getStackInSlot(1).method_7960() || this.dyes.getStackInSlot(2).method_7960())) {
            return;
        }
        HashMap<class_2960, Integer> partsNeeded = new HashMap<class_2960, Integer>();
        this.addDyePartsNeeded(storage, partsNeeded);
        for (Map.Entry entry : partsNeeded.entrySet()) {
            if (((class_2960)entry.getKey()).equals((Object)ConventionalItemTags.RED_DYES.comp_327()) && this.dyes.getStackInSlot(0).method_7960()) {
                this.missingDyes.add((class_2960)entry.getKey());
                continue;
            }
            if (((class_2960)entry.getKey()).equals((Object)ConventionalItemTags.GREEN_DYES.comp_327()) && this.dyes.getStackInSlot(1).method_7960()) {
                this.missingDyes.add((class_2960)entry.getKey());
                continue;
            }
            if (!((class_2960)entry.getKey()).equals((Object)ConventionalItemTags.BLUE_DYES.comp_327()) || !this.dyes.getStackInSlot(2).method_7960()) continue;
            this.missingDyes.add((class_2960)entry.getKey());
        }
    }

    public Set<class_2960> getMissingDyes() {
        return this.missingDyes;
    }

    private boolean colorsTransparentOrSameAs(class_1799 storage) {
        return !(this.mainColor != -1 && this.mainColor != StorageBlockItem.getMainColorFromStack(storage).orElse(-1) || this.accentColor != -1 && this.accentColor != StorageBlockItem.getAccentColorFromStack(storage).orElse(-1));
    }

    private void setMaterialsFromDecorativeBlocks(Map<BarrelMaterial, class_2960> materials, boolean supportsInnerTrim) {
        class_2960 topInnerTrimMaterialLocation = this.setMaterialFromBlock(0, null, materials, BarrelMaterial.TOP_INNER_TRIM, supportsInnerTrim);
        class_2960 topTrimMaterialLocation = this.setMaterialFromBlock(1, topInnerTrimMaterialLocation, materials, BarrelMaterial.TOP_TRIM, true);
        class_2960 sideTrimMaterialLocation = this.setMaterialFromBlock(2, topTrimMaterialLocation, materials, BarrelMaterial.SIDE_TRIM, true);
        this.setMaterialFromBlock(3, sideTrimMaterialLocation, materials, BarrelMaterial.BOTTOM_TRIM, true);
        class_2960 topMaterialLocation = this.setMaterialFromBlock(4, topTrimMaterialLocation, materials, BarrelMaterial.TOP, true);
        class_2960 sideMaterialLocation = this.setMaterialFromBlock(5, topMaterialLocation, materials, BarrelMaterial.SIDE, true);
        this.setMaterialFromBlock(6, sideMaterialLocation, materials, BarrelMaterial.BOTTOM, true);
    }

    @Nullable
    private class_2960 setMaterialFromBlock(int slotIndex, @Nullable class_2960 defaultMaterialLocation, Map<BarrelMaterial, class_2960> materials, BarrelMaterial material, boolean addToMaterials) {
        class_1799 decorativeBlock = this.decorativeBlocks.getStackInSlot(slotIndex);
        class_2960 materialLocation = this.getMaterialLocation(decorativeBlock).orElse((class_2960)(this.isSlotMaterialInherited(slotIndex) ? defaultMaterialLocation : null));
        if (materialLocation != null) {
            if (addToMaterials) {
                materials.put(material, materialLocation);
            }
            return materialLocation;
        }
        return null;
    }

    private Optional<class_2960> getMaterialLocation(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return Optional.of(class_7923.field_41175.method_10221((Object)blockItem.method_7711()));
        }
        return Optional.empty();
    }

    public DecorationTableBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE, pos, blockState);
    }

    public ItemStackHandler getDecorativeBlocks() {
        return this.decorativeBlocks;
    }

    public ItemStackHandler getDyes() {
        return this.dyes;
    }

    public ItemStackHandler getStorageBlock() {
        return this.storageBlock;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public class_1799 extractResult(int count) {
        class_1799 result = this.getResult();
        if (result.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 extracted = result.method_7972();
        extracted.method_7939(count);
        if (count >= result.method_7947()) {
            this.result = class_1799.field_8037;
        } else {
            result.method_7934(count);
        }
        this.method_5431();
        return extracted;
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.slotMaterialInheritance.getOrDefault(slot, true);
    }

    public class_1799 getInheritedItem(int childSlot) {
        while (this.isSlotMaterialInherited(childSlot)) {
            int parentSlot = this.getSlotInheritedFrom(childSlot);
            if (parentSlot == -1) {
                return class_1799.field_8037;
            }
            if (!this.decorativeBlocks.getStackInSlot(parentSlot).method_7960()) {
                return this.decorativeBlocks.getStackInSlot(parentSlot);
            }
            childSlot = parentSlot;
        }
        return class_1799.field_8037;
    }

    public int getSlotInheritedFrom(int slot) {
        return switch (slot) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 1;
            case 5 -> 4;
            case 6 -> 5;
            default -> -1;
        };
    }

    public void setSlotMaterialInheritance(int slot, boolean value) {
        if (value) {
            this.slotMaterialInheritance.remove(slot);
        } else {
            this.slotMaterialInheritance.put(slot, false);
        }
        this.updateResultAndSetChanged();
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.saveData(tag);
        return tag;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.decorativeBlocks.deserializeNBT(tag.method_10562("decorativeBlocks"));
        this.dyes.deserializeNBT(tag.method_10562("dyes"));
        this.storageBlock.deserializeNBT(tag.method_10562("storageBlock"));
        this.result = tag.method_10545("result") ? class_1799.method_7915((class_2487)tag.method_10562("result")) : class_1799.field_8037;
        this.slotMaterialInheritance.clear();
        class_2499 inheritance = tag.method_10554("slotMaterialInheritance", 10);
        for (int i = 0; i < inheritance.size(); ++i) {
            class_2487 slotTag = inheritance.method_10602(i);
            this.slotMaterialInheritance.put(slotTag.method_10550("slot"), slotTag.method_10577("value"));
        }
        this.remainingParts.clear();
        class_2499 remainingPartsTag = tag.method_10554("remainingParts", 10);
        for (int i = 0; i < remainingPartsTag.size(); ++i) {
            class_2487 partTag = remainingPartsTag.method_10602(i);
            class_2960 key = class_2960.method_12829((String)partTag.method_10558("key"));
            if (key == null) continue;
            this.remainingParts.put(key, partTag.method_10550("value"));
        }
        this.mainColor = tag.method_10550("mainColor");
        this.accentColor = tag.method_10550("accentColor");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.saveData(tag);
    }

    private void saveData(class_2487 tag) {
        tag.method_10566("decorativeBlocks", (class_2520)this.decorativeBlocks.serializeNBT());
        tag.method_10566("dyes", (class_2520)this.dyes.serializeNBT());
        tag.method_10566("storageBlock", (class_2520)this.storageBlock.serializeNBT());
        if (!this.result.method_7960()) {
            tag.method_10566("result", (class_2520)this.result.method_7953(new class_2487()));
        }
        class_2499 inheritance = new class_2499();
        this.slotMaterialInheritance.forEach((slot, value) -> {
            class_2487 slotTag = new class_2487();
            slotTag.method_10569("slot", slot.intValue());
            slotTag.method_10556("value", value.booleanValue());
            inheritance.add((Object)slotTag);
        });
        tag.method_10566("slotMaterialInheritance", (class_2520)inheritance);
        class_2499 remainingPartsTag = new class_2499();
        this.remainingParts.forEach((key, value) -> {
            class_2487 partTag = new class_2487();
            partTag.method_10582("key", key.toString());
            partTag.method_10569("value", value.intValue());
            remainingPartsTag.add((Object)partTag);
        });
        tag.method_10566("remainingParts", (class_2520)remainingPartsTag);
        tag.method_10569("mainColor", this.mainColor);
        tag.method_10569("accentColor", this.accentColor);
    }

    public void consumeIngredientsOnCraft() {
        if (InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks)) {
            this.consumeDyes();
        } else {
            this.consumeMaterials();
        }
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    private void consumeDyes() {
        class_1799 storageStack = this.storageBlock.getStackInSlot(0);
        HashMap<class_2960, Integer> partsNeeded = new HashMap<class_2960, Integer>();
        HashMap<class_2960, Integer> firstSlotWithMaterial = new HashMap<class_2960, Integer>();
        firstSlotWithMaterial.put(ConventionalItemTags.RED_DYES.comp_327(), 0);
        firstSlotWithMaterial.put(ConventionalItemTags.GREEN_DYES.comp_327(), 1);
        firstSlotWithMaterial.put(ConventionalItemTags.BLUE_DYES.comp_327(), 2);
        this.addDyePartsNeeded(storageStack, partsNeeded);
        if (partsNeeded.isEmpty()) {
            return;
        }
        this.consumePartsNeeded(partsNeeded, firstSlotWithMaterial, this.dyes);
    }

    private void addDyePartsNeeded(class_1799 storageStack, Map<class_2960, Integer> partsNeeded) {
        int[] rgbPartsNeeded;
        if (this.mainColor != -1 && this.mainColor != StorageBlockItem.getMainColorFromStack(storageStack).orElse(-1)) {
            rgbPartsNeeded = this.calculateRGBPartsNeeded(this.mainColor, 18);
            DecorationTableBlockEntity.addPartsNeededIfAny(rgbPartsNeeded, partsNeeded);
        }
        if (this.accentColor != -1 && this.accentColor != StorageBlockItem.getAccentColorFromStack(storageStack).orElse(-1)) {
            rgbPartsNeeded = this.calculateRGBPartsNeeded(this.accentColor, 6);
            DecorationTableBlockEntity.addPartsNeededIfAny(rgbPartsNeeded, partsNeeded);
        }
    }

    private static void addPartsNeededIfAny(int[] rgbPartsNeeded, Map<class_2960, Integer> partsNeeded) {
        DecorationTableBlockEntity.addPartsNeededIfAny(rgbPartsNeeded[0], partsNeeded, ConventionalItemTags.RED_DYES.comp_327());
        DecorationTableBlockEntity.addPartsNeededIfAny(rgbPartsNeeded[1], partsNeeded, ConventionalItemTags.GREEN_DYES.comp_327());
        DecorationTableBlockEntity.addPartsNeededIfAny(rgbPartsNeeded[2], partsNeeded, ConventionalItemTags.BLUE_DYES.comp_327());
    }

    private static void addPartsNeededIfAny(int parts, Map<class_2960, Integer> partsNeeded, class_2960 dyeName) {
        if (parts != 0) {
            partsNeeded.compute(dyeName, (location, partsTotal) -> partsTotal == null ? parts : partsTotal + parts);
        }
    }

    private int[] calculateRGBPartsNeeded(int color, int totalParts) {
        int i2;
        float[] ratios = new float[]{(float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f};
        float totalRaios = ratios[0] + ratios[1] + ratios[2];
        ratios[0] = ratios[0] / totalRaios;
        ratios[1] = ratios[1] / totalRaios;
        ratios[2] = ratios[2] / totalRaios;
        int n = ratios.length;
        int[] result = new int[n];
        double[] remainders = new double[n];
        double[] scaled = new double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            scaled[i3] = ratios[i3] * (float)totalParts;
            result[i3] = (int)scaled[i3];
            remainders[i3] = scaled[i3] - (double)result[i3];
        }
        int remaining = totalParts - Arrays.stream(result).sum();
        Integer[] indices = new Integer[n];
        for (i2 = 0; i2 < n; ++i2) {
            indices[i2] = i2;
        }
        Arrays.sort(indices, Comparator.comparingDouble(i -> -remainders[i]));
        for (i2 = 0; i2 < remaining; ++i2) {
            int n2 = indices[i2 % n];
            result[n2] = result[n2] + 1;
        }
        return result;
    }

    private void consumeMaterials() {
        HashMap<class_2960, Integer> partsNeeded = new HashMap<class_2960, Integer>();
        HashMap<class_2960, Integer> firstSlotWithMaterial = new HashMap<class_2960, Integer>();
        this.addMaterialPartsNeeded(partsNeeded, firstSlotWithMaterial);
        this.consumePartsNeeded(partsNeeded, firstSlotWithMaterial, this.decorativeBlocks);
    }

    private void addMaterialPartsNeeded(Map<class_2960, Integer> partsNeeded, Map<class_2960, Integer> firstSlotWithMaterial) {
        class_2960 topInnerTrimMaterialLocation = this.addMaterialCostForSlotAndGetMaterial(0, null, partsNeeded, firstSlotWithMaterial);
        class_2960 topTrimMaterialLocation = this.addMaterialCostForSlotAndGetMaterial(1, topInnerTrimMaterialLocation, partsNeeded, firstSlotWithMaterial);
        class_2960 sideTrimMaterialLocation = this.addMaterialCostForSlotAndGetMaterial(2, topTrimMaterialLocation, partsNeeded, firstSlotWithMaterial);
        this.addMaterialCostForSlotAndGetMaterial(3, sideTrimMaterialLocation, partsNeeded, firstSlotWithMaterial);
        class_2960 topMaterialLocation = this.addMaterialCostForSlotAndGetMaterial(4, topTrimMaterialLocation, partsNeeded, firstSlotWithMaterial);
        class_2960 sideMaterialLocation = this.addMaterialCostForSlotAndGetMaterial(5, topMaterialLocation, partsNeeded, firstSlotWithMaterial);
        this.addMaterialCostForSlotAndGetMaterial(6, sideMaterialLocation, partsNeeded, firstSlotWithMaterial);
    }

    public Map<class_2960, Integer> getPartsNeeded() {
        HashMap<class_2960, Integer> partsNeeded = new HashMap<class_2960, Integer>();
        class_1799 storageStack = this.storageBlock.getStackInSlot(0);
        if (InventoryHelper.isEmpty((SlottedStackStorage)this.decorativeBlocks) || !(storageStack.method_7909() instanceof BarrelBlockItem)) {
            this.addDyePartsNeeded(storageStack, partsNeeded);
        } else {
            this.addMaterialPartsNeeded(partsNeeded, new HashMap<class_2960, Integer>());
        }
        return partsNeeded;
    }

    private void consumePartsNeeded(Map<class_2960, Integer> partsNeeded, Map<class_2960, Integer> firstSlotWithMaterial, ItemStackHandler resources) {
        partsNeeded.forEach((material, parts) -> {
            int remainingParts = this.remainingParts.getOrDefault(material, 0);
            if (remainingParts >= parts) {
                if (remainingParts == parts) {
                    this.remainingParts.remove(material);
                } else {
                    this.remainingParts.put((class_2960)material, remainingParts - parts);
                }
            } else {
                if (firstSlotWithMaterial.get(material) == null) {
                    return;
                }
                int slotWithMaterial = (Integer)firstSlotWithMaterial.get(material);
                class_1799 stack = resources.getStackInSlot(slotWithMaterial);
                stack.method_7934(1);
                resources.setStackInSlot(slotWithMaterial, stack);
                this.remainingParts.put((class_2960)material, remainingParts + 24 - parts);
            }
        });
    }

    @Nullable
    private class_2960 addMaterialCostForSlotAndGetMaterial(int slotIndex, @Nullable class_2960 defaultMaterialLocation, Map<class_2960, Integer> partsNeeded, Map<class_2960, Integer> firstSlotWithMaterial) {
        boolean hasNoCost = slotIndex == 1 && defaultMaterialLocation != null;
        class_1799 decorativeBlock = this.decorativeBlocks.getStackInSlot(slotIndex);
        class_2960 materialLocation = this.getMaterialLocation(decorativeBlock).orElse((class_2960)(this.isSlotMaterialInherited(slotIndex) ? defaultMaterialLocation : null));
        if (hasNoCost) {
            return materialLocation;
        }
        if (materialLocation != null) {
            int parts = DECORATIVE_SLOT_PARTS_NEEDED.get(slotIndex);
            partsNeeded.compute(materialLocation, (key, value) -> value == null ? parts : value + parts);
            firstSlotWithMaterial.putIfAbsent(materialLocation, slotIndex);
        }
        return materialLocation;
    }

    public int getMainColor() {
        return this.mainColor;
    }

    public void setMainColor(int mainColor) {
        this.mainColor = mainColor;
        this.updateResultAndSetChanged();
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
        this.updateResultAndSetChanged();
    }

    public Map<class_2960, Integer> getPartsStored() {
        return this.remainingParts;
    }

    public void dropContents() {
        InventoryHelper.dropItems((SlottedStackStorage)this.decorativeBlocks, (class_1937)this.field_11863, (class_2338)this.field_11867);
        InventoryHelper.dropItems((SlottedStackStorage)this.dyes, (class_1937)this.field_11863, (class_2338)this.field_11867);
        InventoryHelper.dropItems((SlottedStackStorage)this.storageBlock, (class_1937)this.field_11863, (class_2338)this.field_11867);
    }
}

