/*
 * Decompiled with CFR 0.152.
 */
package net.leafenzo.mint.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class EmberBlock
extends class_2248
implements class_3737 {
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 DOWN_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<class_2350, class_2746> FACING_PROPERTIES;
    private static final Map SHAPES_FOR_DIRECTIONS;
    protected static final class_2350[] DIRECTIONS;
    private final ImmutableMap<class_2680, class_265> SHAPES;
    public static final class_2746 WATERLOGGED;
    private final boolean hasAllHorizontalDirections;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public EmberBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)EmberBlock.withAllDirections((class_2689<class_2248, class_2680>)this.field_10647).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.method_33615(EmberBlock::getShapeForState);
        this.hasAllHorizontalDirections = class_2350.class_2353.field_11062.method_29716().allMatch(this::canHaveDirection);
        this.canMirrorX = class_2350.class_2353.field_11062.method_29716().filter(class_2350.class_2351.field_11048).filter(this::canHaveDirection).count() % 2L == 0L;
        this.canMirrorZ = class_2350.class_2353.field_11062.method_29716().filter(class_2350.class_2351.field_11051).filter(this::canHaveDirection).count() % 2L == 0L;
    }

    public static Set<class_2350> collectDirections(class_2680 state) {
        if (!(state.method_26204() instanceof EmberBlock)) {
            return Set.of();
        }
        EnumSet<class_2350> set = EnumSet.noneOf(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            if (!EmberBlock.hasDirection(state, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    protected boolean canHaveDirection(class_2350 direction) {
        return true;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        for (class_2350 direction : DIRECTIONS) {
            if (!this.canHaveDirection(direction)) continue;
            builder.method_11667(new class_2769[]{EmberBlock.getProperty(direction)});
        }
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (!EmberBlock.hasAnyDirection(state)) {
            return class_2246.field_10124.method_9564();
        }
        return EmberBlock.hasDirection(state, direction) && !EmberBlock.canPlaceOn((class_1922)world, direction, neighborPos, neighborState) ? EmberBlock.disableDirection(state, EmberBlock.getProperty(direction)) : state;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (class_265)this.SHAPES.get((Object)state);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        boolean bl = false;
        for (class_2350 direction : DIRECTIONS) {
            if (!EmberBlock.hasDirection(state, direction)) continue;
            class_2338 blockPos = pos.method_10093(direction);
            if (!EmberBlock.canPlaceOn((class_1922)world, direction, blockPos, world.method_8320(blockPos))) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return EmberBlock.isNotFullBlock(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = world.method_8320(blockPos);
        return Arrays.stream(ctx.method_7718()).map(direction -> this.withDirection(blockState, (class_1922)world, blockPos, (class_2350)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean canGrowWithDirection(class_1922 world, class_2680 state, class_2338 pos, class_2350 direction) {
        if (!(!this.canHaveDirection(direction) || state.method_27852((class_2248)this) && EmberBlock.hasDirection(state, direction))) {
            class_2338 blockPos = pos.method_10093(direction);
            return EmberBlock.canPlaceOn(world, direction, blockPos, world.method_8320(blockPos));
        }
        return false;
    }

    @Nullable
    public class_2680 withDirection(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if (!this.canGrowWithDirection(world, state, pos, direction)) {
            return null;
        }
        class_2680 blockState = state.method_27852((class_2248)this) ? state : (this.isWaterlogged() && state.method_26227().method_33659((class_3611)class_3612.field_15910) ? (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : this.method_9564());
        return (class_2680)blockState.method_11657((class_2769)EmberBlock.getProperty(direction), (Comparable)Boolean.valueOf(true));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (!this.hasAllHorizontalDirections) {
            return state;
        }
        Objects.requireNonNull(rotation);
        return this.mirror(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11301 && !this.canMirrorX) {
            return state;
        }
        if (mirror == class_2415.field_11300 && !this.canMirrorZ) {
            return state;
        }
        Objects.requireNonNull(mirror);
        return this.mirror(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0));
    }

    private class_2680 mirror(class_2680 state, Function<class_2350, class_2350> mirror) {
        class_2680 blockState = state;
        for (class_2350 direction : DIRECTIONS) {
            if (!this.canHaveDirection(direction)) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)EmberBlock.getProperty(mirror.apply(direction)), (Comparable)((Boolean)state.method_11654((class_2769)EmberBlock.getProperty(direction))));
        }
        return blockState;
    }

    public static boolean hasDirection(class_2680 state, class_2350 direction) {
        class_2746 booleanProperty = EmberBlock.getProperty(direction);
        return state.method_28498((class_2769)booleanProperty) && (Boolean)state.method_11654((class_2769)booleanProperty) != false;
    }

    public static boolean canPlaceOn(class_1922 world, class_2350 direction, class_2338 pos, class_2680 state) {
        return class_2248.method_9501((class_265)state.method_26222(world, pos), (class_2350)direction.method_10153()) || class_2248.method_9501((class_265)state.method_26220(world, pos), (class_2350)direction.method_10153());
    }

    private boolean isWaterlogged() {
        return this.field_10647.method_11659().contains(class_2741.field_12508);
    }

    private static class_2680 disableDirection(class_2680 state, class_2746 direction) {
        class_2680 blockState = (class_2680)state.method_11657((class_2769)direction, (Comparable)Boolean.valueOf(false));
        return EmberBlock.hasAnyDirection(blockState) ? blockState : class_2246.field_10124.method_9564();
    }

    public static class_2746 getProperty(class_2350 direction) {
        return FACING_PROPERTIES.get(direction);
    }

    private static class_2680 withAllDirections(class_2689<class_2248, class_2680> stateManager) {
        class_2680 blockState = (class_2680)stateManager.method_11664();
        for (class_2746 booleanProperty : FACING_PROPERTIES.values()) {
            if (!blockState.method_28498((class_2769)booleanProperty)) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        for (class_2350 direction : DIRECTIONS) {
            if (!EmberBlock.hasDirection(state, direction)) continue;
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)((class_265)SHAPES_FOR_DIRECTIONS.get(direction)));
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    protected static boolean hasAnyDirection(class_2680 state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> EmberBlock.hasDirection(state, direction));
    }

    private static boolean isNotFullBlock(class_2680 state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> !EmberBlock.hasDirection(state, direction));
    }

    static {
        WATERLOGGED = class_2741.field_12508;
        FACING_PROPERTIES = class_2429.field_11329;
        SHAPES_FOR_DIRECTIONS = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), shapes -> {
            shapes.put(class_2350.field_11043, SOUTH_SHAPE);
            shapes.put(class_2350.field_11034, WEST_SHAPE);
            shapes.put(class_2350.field_11035, NORTH_SHAPE);
            shapes.put(class_2350.field_11039, EAST_SHAPE);
            shapes.put(class_2350.field_11036, UP_SHAPE);
            shapes.put(class_2350.field_11033, DOWN_SHAPE);
        });
        DIRECTIONS = class_2350.values();
    }
}

