/*
 * Decompiled with CFR 0.152.
 */
package net.leafenzo.mint.datageneration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.leafenzo.mint.ElsDyeMod;
import net.leafenzo.mint.block.ElsDyeModBlocks;
import net.leafenzo.mint.effect.ElsDyeModEffects;
import net.leafenzo.mint.registration.WoodSet;
import net.leafenzo.mint.util.ElsDyeModDyeColor;
import net.leafenzo.mint.util.ElsDyeModUtil;
import net.minecraft.class_1291;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.http.annotation.Experimental;

public class ElsDyeModEnglishLangProvider
extends FabricLanguageProvider {
    Set<String> usedTranslationKeys = new HashSet<String>();

    public ElsDyeModEnglishLangProvider(FabricDataOutput dataGenerator) {
        super(dataGenerator, "en_us");
    }

    private void generateTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, String key, String translation) {
        if (this.usedTranslationKeys.contains(key)) {
            return;
        }
        translationBuilder.add(key, translation);
        this.usedTranslationKeys.add(key);
    }

    private void generateTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, class_2248 block, String translation) {
        this.generateTranslation(translationBuilder, block.method_9539(), translation);
    }

    private void generateTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, class_1792 item, String translation) {
        this.generateTranslation(translationBuilder, item.method_7876(), translation);
    }

    private void generatePotionTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, String subKey, String effectName) {
        String potionKey = "item.minecraft.potion.effect." + subKey;
        this.generateTranslation(translationBuilder, potionKey, "Potion of " + effectName);
        String splashPotionKey = "item.minecraft.splash_potion.effect." + subKey;
        this.generateTranslation(translationBuilder, splashPotionKey, "Splash Potion of " + effectName);
        String lingeringPotionKey = "item.minecraft.lingering_potion.effect." + subKey;
        this.generateTranslation(translationBuilder, lingeringPotionKey, "Lingering Potion of " + effectName);
        String arrowKey = "item.minecraft.tipped_arrow.effect." + subKey;
        this.generateTranslation(translationBuilder, arrowKey, "Arrow of " + effectName);
    }

    private void generateShieldVariantTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (class_1767 color : ElsDyeModDyeColor.VALUES) {
            String key = "item.minecraft.shield." + color.method_7792();
            this.generateTranslation(translationBuilder, key, ElsDyeModUtil.toSentanceCase(color.method_7792() + "_shield"));
        }
    }

    private void generateBannerPatternColorTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (class_1767 color : ElsDyeModDyeColor.VALUES) {
            for (class_2960 id : class_7923.field_41165.method_10235()) {
                String key = "block.minecraft.banner." + id.method_12832();
                String baseKey = "block.minecraft.banner." + id.method_12832() + ".black";
                this.generateTranslation(translationBuilder, key + "." + color.method_7792(), ElsDyeModUtil.toSentanceCase(color.method_7792()) + " " + class_2477.method_10517().method_48307(baseKey).replaceAll("Black ", ""));
            }
        }
    }

    private void generateWoodsetTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (WoodSet woodSet : ElsDyeModBlocks.WOODSETS) {
            String key = woodSet.getChestBoatEntityType().method_5882();
            String baseKey = "entity.minecraft.chest_boat";
            this.generateTranslation(translationBuilder, key, class_2477.method_10517().method_48307(baseKey));
        }
    }

    @Experimental
    private void generateColoredBlockAndItemTranslationsForMod(FabricLanguageProvider.TranslationBuilder translationBuilder, String modId) {
        for (class_2960 id : ElsDyeModUtil.allBlockIdsInNamespace(modId)) {
            for (class_1767 color : ElsDyeModDyeColor.VALUES) {
                if (!id.method_12832().contains(color.method_7792())) continue;
                String key = "block." + modId + "." + id.method_12832();
                this.usedTranslationKeys.add(key);
                translationBuilder.add(key, ElsDyeModUtil.toSentanceCase(color.method_7792() + id.method_12832().replace(color.method_7792(), "")));
            }
        }
    }

    private void generateBannerTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, ArrayList<class_2248> BannerBlocks) {
        for (class_2248 block : BannerBlocks) {
            this.generateTranslation(translationBuilder, block.method_9539(), ElsDyeModUtil.toSentanceCase(class_7923.field_41175.method_10221((Object)block).method_12832()));
        }
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        String key;
        this.generateTranslation(translationBuilder, ElsDyeModEffects.MINT_CHILL.method_5567(), "Mint Chill");
        this.generatePotionTranslation(translationBuilder, "mint_chill", "Mint Chill");
        this.generatePotionTranslation(translationBuilder, "long_mint_chill", "Mint Chill");
        this.generatePotionTranslation(translationBuilder, "strong_mint_chill", "Mint Chill");
        this.generateTranslation(translationBuilder, ElsDyeModEffects.THORNS.method_5567(), "Thorns");
        this.generatePotionTranslation(translationBuilder, "thorns", "Thorns");
        this.generatePotionTranslation(translationBuilder, "long_thorns", "Thorns");
        this.generatePotionTranslation(translationBuilder, "strong_thorns", "Thorns");
        this.generateTranslation(translationBuilder, ElsDyeModBlocks.MINT_SPRIG_BLOCK, "Pile of Mint");
        this.generateTranslation(translationBuilder, ElsDyeModBlocks.WAXCAP_GILLS, "Waxcap Gill Block");
        this.generateTranslation(translationBuilder, ElsDyeModBlocks.WAXCAP_GILL_SLAB, "Waxcap Gills");
        this.generateTranslation(translationBuilder, ElsDyeModBlocks.AMBER_BLOCK, "Block of Amber");
        this.generateTranslation(translationBuilder, ElsDyeModBlocks.CINNABAR_BLOCK, "Block of Cinnabar");
        this.generateTranslation(translationBuilder, "subtitles.entity.beetle.ambient", "Beetle Clicks");
        this.generateTranslation(translationBuilder, "subtitles.entity.beetle.death", "Beetle Dies");
        this.generateTranslation(translationBuilder, "subtitles.entity.beetle.hurt", "Beetle Hurts");
        this.generateWoodsetTranslations(translationBuilder);
        this.generateBannerTranslations(translationBuilder, ElsDyeModBlocks.BANNER_BLOCKS);
        this.generateBannerPatternColorTranslations(translationBuilder);
        this.generateShieldVariantTranslations(translationBuilder);
        for (class_2960 id : ElsDyeModUtil.allBlockIdsInNamespace(ElsDyeMod.MOD_ID)) {
            key = ((class_2248)class_7923.field_41175.method_10223(id)).method_9539();
            if (this.usedTranslationKeys.contains(key)) continue;
            this.usedTranslationKeys.add(key);
            translationBuilder.add(key, ElsDyeModUtil.toSentanceCase(id.method_12832()));
        }
        for (class_2960 id : ElsDyeModUtil.allItemIdsInNamespace(ElsDyeMod.MOD_ID)) {
            key = ((class_1792)class_7923.field_41178.method_10223(id)).method_7876();
            if (this.usedTranslationKeys.contains(key)) continue;
            this.usedTranslationKeys.add(key);
            translationBuilder.add(key, ElsDyeModUtil.toSentanceCase(id.method_12832()));
        }
        for (class_2960 id : ElsDyeModUtil.allItemGroupIdsInNamespace(ElsDyeMod.MOD_ID)) {
            key = ((class_1761)class_7923.field_44687.method_10223(id)).method_7737().getString();
            if (this.usedTranslationKeys.contains(key)) continue;
            this.usedTranslationKeys.add(key);
            translationBuilder.add(key, ElsDyeModUtil.toSentanceCase(id.method_12832()));
        }
        for (class_2960 id : ElsDyeModUtil.allStatusEffectIdsInNamespace(ElsDyeMod.MOD_ID)) {
            key = ((class_1291)class_7923.field_41174.method_10223(id)).method_5567();
            if (this.usedTranslationKeys.contains(key)) continue;
            this.usedTranslationKeys.add(key);
            translationBuilder.add(key, ElsDyeModUtil.toSentanceCase(id.method_12832()));
        }
    }
}

