/*
 * Decompiled with CFR 0.152.
 */
package net.leafenzo.mint.registration;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.leafenzo.mint.block.ElsDyeModBlocks;
import net.leafenzo.mint.entity.ElsDyeModBoatEntity;
import net.leafenzo.mint.entity.ElsDyeModEntityTypes;
import net.leafenzo.mint.item.custom.ModBoatItem;
import net.leafenzo.mint.registration.ElsDyeModRegistryHelper;
import net.leafenzo.mint.registries.ElsDyeModFabricRegistries;
import net.leafenzo.mint.registry.tag.ElsDyeModTags;
import net.minecraft.class_1299;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2362;
import net.minecraft.class_2397;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2647;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8177;

public class WoodSet {
    private final List<class_2248> registeredBlocksList = new ArrayList<class_2248>();
    private final List<class_1792> registeredItemsList = new ArrayList<class_1792>();
    private final class_2960 name;
    private final class_3620 sideColor;
    private final class_3620 topColor;
    private final class_3620 leavesColor;
    private final WoodPreset woodPreset;
    private class_8177 blockSetType;
    private class_2440.class_2441 pressurePlateActivationRule;
    private class_4719 woodType;
    private final boolean isFlammable;
    private final boolean isUsedAsFuel;
    private class_2248 log;
    private class_2248 strippedLog;
    private class_2248 wood;
    private class_2248 strippedWood;
    private class_2248 leaves;
    private class_2248 sapling;
    private class_2248 pottedSapling;
    private class_2248 planks;
    private class_2248 stairs;
    private class_2248 slab;
    private class_2248 mosaic;
    private class_2248 mosaicStairs;
    private class_2248 mosaicSlab;
    private class_2248 fence;
    private class_2248 fenceGate;
    private class_2248 pressurePlate;
    private class_2248 button;
    private class_2248 door;
    private class_2248 trapDoor;
    private class_2248 sign;
    private class_2248 wallSign;
    private class_2248 hangingSign;
    private class_2248 hangingWallSign;
    private class_1792 signItem;
    private class_1792 hangingSignItem;
    private class_1792 boatItem;
    private class_1792 chestBoatItem;
    private class_6862<class_1792> itemLogsTag;
    private class_6862<class_2248> blockLogsTag;
    private final ElsDyeModBoatEntity.ModBoat boatType;
    private class_1299<class_1690> boatEntityType;
    private class_1299<class_1690> chestBoatEntityType;
    private final class_2647 saplingGenerator;
    private boolean hasLargeTree;
    private final boolean hasMosaic;

    public WoodSet(class_2960 name, class_3620 sideColor, class_3620 topColor, class_3620 leavesColor, ElsDyeModBoatEntity.ModBoat boatType, WoodPreset woodPreset, boolean hasMosaic, class_2647 saplingGenerator, boolean isFlammable, boolean isUsedAsFuel) {
        this.woodPreset = woodPreset;
        this.name = name;
        this.sideColor = sideColor;
        this.topColor = topColor;
        this.leavesColor = leavesColor;
        this.boatType = boatType;
        this.hasMosaic = hasMosaic;
        this.saplingGenerator = saplingGenerator;
        this.isFlammable = isFlammable;
        this.isUsedAsFuel = isUsedAsFuel;
        this.registerWoodSet();
    }

    private class_8177 woodType() {
        return this.blockSetType;
    }

    public class_2960 getNameID() {
        return this.name;
    }

    public String getName() {
        return this.name.method_12832();
    }

    public String getModID() {
        return this.name.method_12836();
    }

    public class_8177 getBlockSetType() {
        return this.blockSetType;
    }

    public class_2440.class_2441 getPressurePlateActivationRule() {
        return this.pressurePlateActivationRule;
    }

    public WoodPreset getWoodPreset() {
        return this.woodPreset;
    }

    public class_3620 getSideColor() {
        return this.sideColor;
    }

    public class_3620 getTopColor() {
        return this.topColor;
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    public class_2248 getButton() {
        return this.button;
    }

    public class_2248 getFence() {
        return this.fence;
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public class_2248 getSlab() {
        return this.slab;
    }

    public class_2248 getFenceGate() {
        return this.fenceGate;
    }

    public class_2248 getStairs() {
        return this.stairs;
    }

    public class_2248 getDoor() {
        return this.door;
    }

    public class_2248 getHangingSign() {
        return this.hangingSign;
    }

    public class_2248 getHangingWallSign() {
        return this.hangingWallSign;
    }

    public class_2248 getPressurePlate() {
        return this.pressurePlate;
    }

    public class_2248 getSign() {
        return this.sign;
    }

    public class_2248 getTrapDoor() {
        return this.trapDoor;
    }

    public class_2248 getWallSign() {
        return this.wallSign;
    }

    public class_1792 getHangingSignItem() {
        return this.hangingSignItem;
    }

    public class_1792 getSignItem() {
        return this.signItem;
    }

    public class_1792 getBoatItem() {
        return this.boatItem;
    }

    public class_1792 getChestBoatItem() {
        return this.chestBoatItem;
    }

    public class_2248 getLog() {
        return this.log;
    }

    public class_2248 getStrippedLog() {
        return this.strippedLog;
    }

    public class_2248 getWood() {
        return this.wood;
    }

    public class_2248 getStrippedWood() {
        return this.strippedWood;
    }

    public class_2248 getMosaic() {
        return this.mosaic;
    }

    public class_2248 getMosaicStairs() {
        return this.mosaicStairs;
    }

    public class_2248 getMosaicSlab() {
        return this.mosaicSlab;
    }

    public class_2248 getLeaves() {
        return this.leaves;
    }

    public class_2248 getSapling() {
        return this.sapling;
    }

    public class_2248 getPottedSapling() {
        return this.pottedSapling;
    }

    public ElsDyeModBoatEntity.ModBoat getBoatType() {
        return this.boatType;
    }

    public class_1299<class_1690> getBoatEntityType() {
        return this.boatEntityType;
    }

    public class_1299<class_1690> getChestBoatEntityType() {
        return this.chestBoatEntityType;
    }

    public class_6862<class_1792> getItemLogsTag() {
        return this.itemLogsTag;
    }

    public class_6862<class_2248> getBlockLogsTag() {
        return this.blockLogsTag;
    }

    public List<class_2248> getRegisteredBlocksList() {
        return this.registeredBlocksList;
    }

    public List<class_1792> getRegisteredItemsList() {
        return this.registeredItemsList;
    }

    private void registerWoodSet() {
        this.blockSetType = this.registerBlockSetType();
        this.woodType = new WoodTypeBuilder().register(this.getNameID(), this.getBlockSetType());
        this.log = this.registerLogBlock();
        this.strippedLog = this.registerStrippedLogBlock();
        StrippableBlockRegistry.register((class_2248)this.log, (class_2248)this.strippedLog);
        this.wood = this.registerWoodBlock();
        this.strippedWood = this.registerStrippedWoodBlock();
        StrippableBlockRegistry.register((class_2248)this.wood, (class_2248)this.strippedWood);
        if (this.hasDefaultLeaves()) {
            this.leaves = this.registerLeavesBlock();
            if (this.hasDefaultSapling()) {
                this.sapling = this.registerSaplingBlock(this.saplingGenerator);
                this.pottedSapling = this.registerPottedSaplingBlock(this.getSapling());
            }
        }
        this.planks = this.registerPlanksBlock();
        this.stairs = this.registerStairsBlock();
        this.slab = this.registerSlabBlock();
        this.fence = this.registerFenceBlock();
        this.fenceGate = this.registerFenceGateBlock();
        this.pressurePlateActivationRule = class_2440.class_2441.field_11361;
        this.pressurePlate = this.createPressurePlate();
        this.button = this.registerButtonBlock();
        this.door = this.registerDoorBlock();
        this.trapDoor = this.registerTrapdoorBlock();
        this.sign = this.registerSignBlock();
        this.wallSign = this.registerWallSignBlock();
        this.signItem = this.registerSignItem(this.sign, this.wallSign);
        this.hangingSign = this.registerHangingSignBlock();
        this.hangingWallSign = this.registerWallHangingSignBlock();
        this.hangingSignItem = this.registerHangingSignItem(this.hangingSign, this.hangingWallSign);
        this.boatEntityType = ElsDyeModEntityTypes.registerEntityType(this.getName() + "_boat", ElsDyeModEntityTypes.createBoatType(false, this.getBoatType()));
        this.chestBoatEntityType = ElsDyeModEntityTypes.registerEntityType(this.getName() + "_chest_boat", ElsDyeModEntityTypes.createBoatType(true, this.getBoatType()));
        this.boatItem = this.registerBoatItem();
        this.chestBoatItem = this.registerChestBoatItem();
        this.blockLogsTag = ElsDyeModTags.Blocks.getOrCreateTag(this.getName() + "_logs");
        this.itemLogsTag = ElsDyeModTags.Items.getOrCreateTag(this.getName() + "_logs");
        ElsDyeModBlocks.WOODSETS.add(this);
    }

    private class_2248 registerBlock(String blockID, class_2248 block) {
        class_2248 b = ElsDyeModRegistryHelper.BlockRegistry.registerBlock(blockID, block);
        this.registeredBlocksList.add(b);
        return b;
    }

    private class_2248 registerBlockWithoutBlockItem(String blockID, class_2248 block) {
        class_2248 b = ElsDyeModRegistryHelper.BlockRegistry.registerBlockWithoutBlockItem(blockID, block);
        this.registeredBlocksList.add(b);
        return b;
    }

    public class_1792 registerItem(String name, class_1792 item) {
        class_1792 i = ElsDyeModRegistryHelper.ItemRegistry.registerItem(name, item);
        this.registeredItemsList.add(i);
        return i;
    }

    private class_8177 registerBlockSetType() {
        if (this.woodPreset == WoodPreset.BAMBOO) {
            return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42833).register(this.getNameID());
        }
        if (this.getWoodPreset() == WoodPreset.FANCY) {
            return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42827).register(this.getNameID());
        }
        if (this.woodPreset == WoodPreset.NETHER) {
            return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42830).register(this.getNameID());
        }
        return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42823).register(this.getNameID());
    }

    private class_2465 createLogBlock(class_3620 topMapColor, class_3620 sideMapColor) {
        return new class_2465((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)this.getBase()).mapColor(state -> state.method_11654((class_2769)class_2465.field_11459) == class_2350.class_2351.field_11052 ? topMapColor : sideMapColor).instrument(class_2766.field_12651).strength(2.0f).sounds(this.woodType().comp_1290()));
    }

    private class_2248 registerLogBlock() {
        class_2248 b = this.registerBlock(this.getLogName(), (class_2248)this.createLogBlock(this.getTopColor(), this.getSideColor()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 5, 5);
            ElsDyeModBlocks.LOGS_THAT_BURN.add(b);
        } else {
            ElsDyeModBlocks.LOGS.add(b);
        }
        return b;
    }

    private class_2248 registerStrippedLogBlock() {
        class_2248 b = this.registerBlock("stripped_" + this.getLogName(), (class_2248)this.createLogBlock(this.getTopColor(), this.getTopColor()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 5, 5);
            ElsDyeModBlocks.LOGS_THAT_BURN.add(b);
        } else {
            ElsDyeModBlocks.LOGS.add(b);
        }
        return b;
    }

    private class_2248 registerWoodBlock() {
        class_2248 b = this.registerBlock(this.getWoodName(), (class_2248)this.createLogBlock(this.getSideColor(), this.getSideColor()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 5, 5);
            ElsDyeModBlocks.LOGS_THAT_BURN.add(b);
        } else {
            ElsDyeModBlocks.LOGS.add(b);
        }
        return b;
    }

    private class_2248 registerStrippedWoodBlock() {
        class_2248 b = this.registerBlock("stripped_" + this.getWoodName(), (class_2248)this.createLogBlock(this.getTopColor(), this.getTopColor()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 5, 5);
            ElsDyeModBlocks.LOGS_THAT_BURN.add(b);
        } else {
            ElsDyeModBlocks.LOGS.add(b);
        }
        return b;
    }

    private class_2248 registerLeavesBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_leaves", (class_2248)new class_2397(FabricBlockSettings.method_9630((class_4970)this.getBaseLeaves()).method_31710(this.leavesColor)));
        ElsDyeModFabricRegistries.registerCompostable((class_1935)b, 0.3f);
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 60, 30);
        }
        ElsDyeModBlocks.RENDER_LAYER_CUTOUT_MIPPED.add(b);
        ElsDyeModBlocks.HAS_FOLIAGE_COLOR_PROVIDER.add(b);
        ElsDyeModBlocks.LEAVES.add(b);
        return b;
    }

    private class_2248 registerLeavesBlock(String prefix) {
        class_2248 b = this.registerBlock(prefix + this.getName() + "_leaves", (class_2248)new class_2397(FabricBlockSettings.method_9630((class_4970)this.getBaseLeaves()).method_31710(this.leavesColor)));
        ElsDyeModFabricRegistries.registerCompostable((class_1935)b, 0.3f);
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 60, 30);
        }
        ElsDyeModBlocks.RENDER_LAYER_CUTOUT_MIPPED.add(b);
        ElsDyeModBlocks.HAS_FOLIAGE_COLOR_PROVIDER.add(b);
        ElsDyeModBlocks.LEAVES.add(b);
        return b;
    }

    private class_2248 registerPlanksBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_planks", new class_2248(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        ElsDyeModBlocks.PLANKS.add(b);
        return b;
    }

    private class_2248 registerStairsBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_stairs", (class_2248)new class_2510(this.getBase().method_9564(), FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        ElsDyeModBlocks.WOODEN_STAIRS.add(b);
        return b;
    }

    private class_2248 registerSlabBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_slab", (class_2248)new class_2482(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 150);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        ElsDyeModBlocks.WOODEN_SLABS.add(b);
        return b;
    }

    private class_2248 registerMosaicBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_mosaic", new class_2248(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        return b;
    }

    private class_2248 registerMosaicStairsBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_mosaic_stairs", (class_2248)new class_2510(this.getBase().method_9564(), FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        return b;
    }

    private class_2248 registerMosaicSlabBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_mosaic_slab", (class_2248)new class_2482(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 150);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        return b;
    }

    private class_2248 registerFenceBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_fence", (class_2248)new class_2354(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        ElsDyeModBlocks.WOODEN_FENCES.add(b);
        return b;
    }

    private class_2248 registerFenceGateBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_fence_gate", (class_2248)new class_2349(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()), this.getWoodType()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        if (this.isFlammable) {
            ElsDyeModFabricRegistries.registerFlammable(b, 20, 5);
        }
        ElsDyeModBlocks.FENCE_GATES.add(b);
        return b;
    }

    private class_2248 createPressurePlate() {
        class_2248 b = this.registerBlock(this.getName() + "_pressure_plate", (class_2248)new class_2440(this.pressurePlateActivationRule, FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()), this.getBlockSetType()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        ElsDyeModBlocks.WOODEN_PRESSURE_PLATES.add(b);
        return b;
    }

    private class_2248 registerButtonBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_button", (class_2248)new class_2269(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor()), this.getBlockSetType(), 30, true));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 100);
        }
        ElsDyeModBlocks.WOODEN_BUTTONS.add(b);
        return b;
    }

    private class_2248 registerDoorBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_door", (class_2248)new class_2323(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_50013().method_9626(this.getBlockSetType().comp_1290()).method_22488().method_31710(this.getTopColor()), this.getBlockSetType()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 200);
        }
        ElsDyeModBlocks.WOODEN_DOORS.add(b);
        return b;
    }

    private class_2248 registerTrapdoorBlock() {
        class_2248 b = this.registerBlock(this.getName() + "_trapdoor", (class_2248)new class_2533(FabricBlockSettings.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_22488().method_31710(this.getTopColor()), this.getBlockSetType()));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)b, 300);
        }
        ElsDyeModBlocks.WOODEN_TRAPDOORS.add(b);
        return b;
    }

    private class_2248 registerSignBlock() {
        class_2248 b = this.registerBlockWithoutBlockItem(this.getName() + "_sign", (class_2248)new class_2508(FabricBlockSettings.method_9630((class_4970)this.getSignBase()).method_31710(this.getTopColor()), this.getWoodType()));
        ElsDyeModBlocks.SIGNS.add(b);
        return b;
    }

    private class_2248 registerWallSignBlock() {
        class_2248 b = this.registerBlockWithoutBlockItem(this.getName() + "_wall_sign", (class_2248)new class_2551(FabricBlockSettings.method_9630((class_4970)this.getSignBase()).method_31710(this.getTopColor()).method_16228(this.getSign()), this.getWoodType()));
        ElsDyeModBlocks.SIGNS.add(b);
        return b;
    }

    private class_2248 registerHangingSignBlock() {
        class_2248 b = this.registerBlockWithoutBlockItem(this.getName() + "_hanging_sign", (class_2248)new class_7713(FabricBlockSettings.method_9630((class_4970)this.getHangingSignBase()).method_31710(this.getTopColor()), this.getWoodType()));
        ElsDyeModBlocks.SIGNS.add(b);
        return b;
    }

    private class_2248 registerWallHangingSignBlock() {
        class_2248 b = this.registerBlockWithoutBlockItem(this.getName() + "_wall_hanging_sign", (class_2248)new class_7715(FabricBlockSettings.method_9630((class_4970)this.getHangingSignBase()).method_31710(this.getTopColor()).method_16228(this.getHangingSign()), this.getWoodType()));
        ElsDyeModBlocks.SIGNS.add(b);
        return b;
    }

    public class_2248 registerSaplingBlock(class_2647 saplingGenerator) {
        class_2248 b = this.registerBlock(this.getName() + "_sapling", (class_2248)new class_2473(saplingGenerator, FabricBlockSettings.method_9630((class_4970)class_2246.field_10217)));
        ElsDyeModFabricRegistries.registerCompostable((class_1935)b, 0.3f);
        ElsDyeModBlocks.RENDER_LAYER_CUTOUT_MIPPED.add(b);
        ElsDyeModBlocks.SAPLINGS.add(b);
        return b;
    }

    public class_2248 registerSaplingBlock(String prefix, class_2647 saplingGenerator) {
        class_2248 b = this.registerBlock(prefix + this.getName() + "_sapling", (class_2248)new class_2473(saplingGenerator, FabricBlockSettings.method_9630((class_4970)class_2246.field_10217)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)b, (Object)Float.valueOf(0.3f));
        ElsDyeModBlocks.RENDER_LAYER_CUTOUT_MIPPED.add(b);
        ElsDyeModBlocks.SAPLINGS.add(b);
        return b;
    }

    public class_2248 registerPottedSaplingBlock(class_2248 sapling) {
        class_2248 b = this.registerBlockWithoutBlockItem("potted_" + this.getName() + "_sapling", (class_2248)new class_2362(sapling, (class_4970.class_2251)FabricBlockSettings.create().breakInstantly().nonOpaque().pistonBehavior(class_3619.field_15971)));
        ElsDyeModBlocks.RENDER_LAYER_CUTOUT_MIPPED.add(b);
        ElsDyeModBlocks.FLOWER_POT_FROM_BLOCK.put(sapling, (class_2362)b);
        return b;
    }

    public class_2248 registerPottedSaplingBlock(String prefix, class_2248 sapling) {
        class_2248 b = this.registerBlockWithoutBlockItem("potted_" + prefix + this.getName() + "_sapling", (class_2248)new class_2362(sapling, (class_4970.class_2251)FabricBlockSettings.create().breakInstantly().nonOpaque().pistonBehavior(class_3619.field_15971)));
        ElsDyeModBlocks.RENDER_LAYER_CUTOUT_MIPPED.add(b);
        ElsDyeModBlocks.FLOWER_POT_FROM_BLOCK.put(sapling, (class_2362)b);
        return b;
    }

    private class_1792 registerSignItem(class_2248 sign, class_2248 wallSign) {
        class_1792 i = this.registerItem(this.getName() + "_sign", (class_1792)new class_1822((class_1792.class_1793)new FabricItemSettings().maxCount(16), sign, wallSign));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)i, 200);
        }
        ElsDyeModRegistryHelper.ItemRegistry.SIGN_ITEMS.add(i);
        return i;
    }

    private class_1792 registerHangingSignItem(class_2248 hangingSign, class_2248 hangingWallSign) {
        class_1792 i = this.registerItem(this.getName() + "_hanging_sign", (class_1792)new class_7707(hangingSign, hangingWallSign, (class_1792.class_1793)new FabricItemSettings().maxCount(16)));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)i, 200);
        }
        ElsDyeModRegistryHelper.ItemRegistry.HANGING_SIGN_ITEMS.add(i);
        return i;
    }

    private class_1792 registerBoatItem() {
        class_1792 i = this.registerItem(this.getName() + "_boat", (class_1792)new ModBoatItem(false, this.getBoatType(), (class_1792.class_1793)new FabricItemSettings().maxCount(1)));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)i, 1200);
        }
        ElsDyeModRegistryHelper.ItemRegistry.BOAT_ITEMS.add(i);
        return i;
    }

    private class_1792 registerChestBoatItem() {
        class_1792 i = this.registerItem(this.getName() + "_chest_boat", (class_1792)new ModBoatItem(true, this.getBoatType(), (class_1792.class_1793)new FabricItemSettings().maxCount(1)));
        if (this.isUsedAsFuel) {
            ElsDyeModFabricRegistries.registerFuel((class_1935)i, 1200);
        }
        ElsDyeModRegistryHelper.ItemRegistry.CHEST_BOAT_ITEMS.add(i);
        return i;
    }

    private String getWoodName() {
        String name = this.getWoodPreset() == WoodPreset.NETHER ? this.getName() + "_hyphae" : this.getName() + "_wood";
        return name;
    }

    private String getLogName() {
        String name = this.getWoodPreset() == WoodPreset.BAMBOO ? this.getName() + "_block" : (this.getWoodPreset() == WoodPreset.NETHER ? this.getName() + "_stem" : this.getName() + "_log");
        return name;
    }

    private class_2248 getBaseLeaves() {
        class_2248 base = this.getWoodPreset() == WoodPreset.FANCY ? class_2246.field_28673 : class_2246.field_10503;
        return base;
    }

    private class_2248 getBase() {
        class_2248 base = this.getWoodPreset() == WoodPreset.BAMBOO ? class_2246.field_40294 : (this.getWoodPreset() == WoodPreset.FANCY ? class_2246.field_42751 : (this.getWoodPreset() == WoodPreset.NETHER ? class_2246.field_22126 : class_2246.field_10161));
        return base;
    }

    private class_2248 getSignBase() {
        class_2248 base = this.getWoodPreset() == WoodPreset.BAMBOO ? class_2246.field_40277 : (this.getWoodPreset() == WoodPreset.FANCY ? class_2246.field_42735 : (this.getWoodPreset() == WoodPreset.NETHER ? class_2246.field_22104 : class_2246.field_10121));
        return base;
    }

    private class_2248 getHangingSignBase() {
        class_2248 base = this.getWoodPreset() == WoodPreset.BAMBOO ? class_2246.field_40271 : (this.getWoodPreset() == WoodPreset.FANCY ? class_2246.field_42738 : (this.getWoodPreset() == WoodPreset.NETHER ? class_2246.field_40268 : class_2246.field_40262));
        return base;
    }

    public boolean hasDefaultLeaves() {
        return this.getWoodPreset() == WoodPreset.DEFAULT || this.getWoodPreset() == WoodPreset.FANCY || this.getWoodPreset() == WoodPreset.NO_SAPLING;
    }

    public boolean hasDefaultSapling() {
        return this.getWoodPreset() != WoodPreset.NO_SAPLING || this.getWoodPreset() != WoodPreset.NO_TREE;
    }

    public boolean hasBark() {
        return this.getWoodPreset() != WoodPreset.BAMBOO;
    }

    public boolean hasMosaic() {
        return this.hasMosaic;
    }

    public static enum WoodPreset {
        DEFAULT,
        NO_SAPLING,
        FANCY,
        NETHER,
        BAMBOO,
        NO_TREE;

    }
}

