/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import com.google.common.collect.Sets;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.ChunkChangeResponsePacket;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class RequestChunkChangePacket
extends BaseC2SMessage {
    private final ChunkChangeOp action;
    private final Set<XZ> chunks;

    public RequestChunkChangePacket(ChunkChangeOp action, Set<XZ> chunks) {
        this.action = action;
        this.chunks = chunks;
    }

    RequestChunkChangePacket(class_2540 buf) {
        this.action = (ChunkChangeOp)buf.method_10818(ChunkChangeOp.class);
        this.chunks = (Set)buf.method_34068(Sets::newHashSetWithExpectedSize, buf1 -> XZ.of((int)buf1.method_10816(), (int)buf1.method_10816()));
    }

    public MessageType getType() {
        return FTBChunksNet.REQUEST_CHUNK_CHANGE;
    }

    public void write(class_2540 buf) {
        buf.method_10817((Enum)this.action);
        buf.method_34062(this.chunks, (buf1, xz) -> {
            buf1.method_10804(xz.x());
            buf1.method_10804(xz.z());
        });
    }

    public void handle(NetworkManager.PacketContext context) {
        class_3222 player = (class_3222)context.getPlayer();
        class_2168 source = player.method_5671();
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        Function<XZ, ClaimResult> consumer = switch (this.action) {
            default -> throw new IncompatibleClassChangeError();
            case ChunkChangeOp.CLAIM -> pos -> data.claim(source, pos.dim(player.method_37908()), false);
            case ChunkChangeOp.UNCLAIM -> pos -> data.unclaim(source, pos.dim(player.method_37908()), false);
            case ChunkChangeOp.LOAD -> pos -> data.forceLoad(source, pos.dim(player.method_37908()), false);
            case ChunkChangeOp.UNLOAD -> pos -> data.unForceLoad(source, pos.dim(player.method_37908()), false);
        };
        EnumMap<ClaimResult.StandardProblem, Integer> problems = new EnumMap<ClaimResult.StandardProblem, Integer>(ClaimResult.StandardProblem.class);
        int changed = 0;
        for (XZ pos2 : this.chunks) {
            ClaimResult r = consumer.apply(pos2);
            if (!r.isSuccess()) {
                FTBChunks.LOGGER.debug(String.format("%s tried to %s @ %s:%d:%d but got result %s", player.method_5820(), this.action.name, player.method_37908().method_27983().method_29177(), pos2.x(), pos2.z(), r));
                if (!(r instanceof ClaimResult.StandardProblem)) continue;
                ClaimResult.StandardProblem cr = (ClaimResult.StandardProblem)r;
                problems.put(cr, problems.getOrDefault(cr, 0) + 1);
                continue;
            }
            ++changed;
        }
        new ChunkChangeResponsePacket(this.chunks.size(), changed, problems).sendTo(player);
        SendGeneralDataPacket.send((ChunkTeamData)data, player);
    }

    public static enum ChunkChangeOp {
        CLAIM("claim"),
        UNCLAIM("unclaim"),
        LOAD("load"),
        UNLOAD("unload");

        private final String name;

        private ChunkChangeOp(String name) {
            this.name = name;
        }

        public static ChunkChangeOp create(boolean isLeftMouse, boolean isShift) {
            return isShift ? (isLeftMouse ? LOAD : UNLOAD) : (isLeftMouse ? CLAIM : UNCLAIM);
        }
    }
}

