/*
 * Decompiled with CFR 0.152.
 */
package com.rafacasari.mod.cobbledex.network.server.handlers;

import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.rafacasari.mod.cobbledex.Cobbledex;
import com.rafacasari.mod.cobbledex.api.CobbledexDiscovery;
import com.rafacasari.mod.cobbledex.api.PokedexRewardHistory;
import com.rafacasari.mod.cobbledex.api.PokedexRewards;
import com.rafacasari.mod.cobbledex.network.INetworkPacket;
import com.rafacasari.mod.cobbledex.network.server.IServerNetworkPacketHandler;
import com.rafacasari.mod.cobbledex.network.server.packets.ClaimRewardPacket;
import com.rafacasari.mod.cobbledex.utils.MiscUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/rafacasari/mod/cobbledex/network/server/handlers/ClaimRewardPacketHandler;", "Lcom/rafacasari/mod/cobbledex/network/server/IServerNetworkPacketHandler;", "Lcom/rafacasari/mod/cobbledex/network/server/packets/ClaimRewardPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/rafacasari/mod/cobbledex/network/server/packets/ClaimRewardPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "common"})
@SourceDebugExtension(value={"SMAP\nClaimRewardPacketHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimRewardPacketHandler.kt\ncom/rafacasari/mod/cobbledex/network/server/handlers/ClaimRewardPacketHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n288#2,2:72\n*S KotlinDebug\n*F\n+ 1 ClaimRewardPacketHandler.kt\ncom/rafacasari/mod/cobbledex/network/server/handlers/ClaimRewardPacketHandler\n*L\n37#1:72,2\n*E\n"})
public final class ClaimRewardPacketHandler
implements IServerNetworkPacketHandler<ClaimRewardPacket> {
    @NotNull
    public static final ClaimRewardPacketHandler INSTANCE = new ClaimRewardPacketHandler();

    private ClaimRewardPacketHandler() {
    }

    @Override
    public void handle(@NotNull ClaimRewardPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        Object v0;
        PokedexRewardHistory playerHistory;
        block5: {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!Cobbledex.INSTANCE.getConfig().getCaughtRewards()) {
                MiscUtils.INSTANCE.logWarn(player.method_5477().getString() + " tried to claim a reward (" + packet.getRewardId() + ") but CaughtRewards is disabled on this server");
                return;
            }
            playerHistory = PokedexRewardHistory.Companion.getPlayerRewards(player);
            if (playerHistory.getReceived().contains(packet.getRewardId())) {
                MiscUtils.INSTANCE.logWarn(player.method_5477().getString() + " tried to claim a reward (" + packet.getRewardId() + ") but they already got this reward");
                return;
            }
            PokedexRewards rewardManager = Cobbledex.INSTANCE.getRewardManager();
            Iterable $this$firstOrNull$iv = rewardManager.getRewards();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PokedexRewards.PokedexReward it = (PokedexRewards.PokedexReward)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)packet.getRewardId())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        PokedexRewards.PokedexReward targetReward = v0;
        if (targetReward == null) {
            MiscUtils.INSTANCE.logWarn(player.method_5477().getString() + " tried to claim a reward (" + packet.getRewardId() + ") but this reward doesn't exist!");
            return;
        }
        CobbledexDiscovery playerDiscovery = CobbledexDiscovery.Companion.getPlayerData(player);
        if (playerDiscovery.getTotalCaught() < targetReward.getPokemonCaught()) {
            MiscUtils.INSTANCE.logWarn(player.method_5477().getString() + " tried to claim a reward (" + packet.getRewardId() + ") but doesn't meet the requirements!");
            return;
        }
        class_2960 identifier = new class_2960(targetReward.getItemId());
        Object object = class_7923.field_41178.method_10223(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        class_1792 item = (class_1792)object;
        class_1799 itemStack = new class_1799((class_1935)item, targetReward.getQuantity());
        PlayerExtensionsKt.giveOrDropItemStack$default((class_1657)((class_1657)player), (class_1799)itemStack, (boolean)false, (int)2, null);
        Object[] bl = new class_5250[2];
        bl[0] = TextKt.bold((class_5250)TextKt.text((String)(targetReward.getQuantity() + "x")));
        class_5250 class_52502 = class_5250.method_43477((class_7417)item.method_7848().method_10851());
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"of(...)");
        bl[1] = TextKt.bold((class_5250)class_52502);
        class_5250 itemNameBuilder = MiscUtils.INSTANCE.appendWithSeparator(CollectionsKt.mutableListOf((Object[])bl), " ");
        Object[] objectArray = new Object[]{itemNameBuilder, TextKt.bold((class_5250)TextKt.text((String)String.valueOf(targetReward.getPokemonCaught())))};
        class_5250 message = MiscUtils.INSTANCE.cobbledexTextTranslation("reward_received", objectArray);
        player.method_43496((class_2561)message);
        playerHistory.getReceived().add(targetReward.getId());
    }

    @Override
    public void handleOnNettyThread(@NotNull ClaimRewardPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        IServerNetworkPacketHandler.DefaultImpls.handleOnNettyThread(this, (INetworkPacket)packet, server, player);
    }
}

