/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.config.FightOrFlightCommonConfigModel;
import me.rufia.fightorflight.goals.CaughtByTargetGoal;
import me.rufia.fightorflight.goals.PokemonAvoidGoal;
import me.rufia.fightorflight.goals.PokemonMeleeAttackGoal;
import me.rufia.fightorflight.goals.PokemonNearestAttackableTargetGoal;
import me.rufia.fightorflight.goals.PokemonOwnerHurtByTargetGoal;
import me.rufia.fightorflight.goals.PokemonOwnerHurtTargetGoal;
import me.rufia.fightorflight.goals.PokemonPanicGoal;
import me.rufia.fightorflight.goals.PokemonProactiveTargetGoal;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import org.apache.logging.log4j.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonFightOrFlight {
    public static final String MODID = "fightorflight";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fightorflight");
    public static final float AUTO_AGGRO_THRESHOLD = 50.0f;
    private static FightOrFlightCommonConfigModel config;
    private static TriConsumer<PokemonEntity, Integer, class_1352> goalAdder;

    public static FightOrFlightCommonConfigModel config() {
        return config;
    }

    public static void init(TriConsumer<PokemonEntity, Integer, class_1352> goalAdder) {
        CobblemonFightOrFlight.goalAdder = goalAdder;
        AutoConfig.register(FightOrFlightCommonConfigModel.class, JanksonConfigSerializer::new);
        config = (FightOrFlightCommonConfigModel)AutoConfig.getConfigHolder(FightOrFlightCommonConfigModel.class).getConfig();
    }

    public static void addPokemonGoal(PokemonEntity pokemonEntity) {
        float fleeSpeed = 1.5f;
        float pursuitSpeed = 1.2f;
        goalAdder.accept((Object)pokemonEntity, (Object)3, (Object)new PokemonAvoidGoal((class_1314)pokemonEntity, 48.0f, 1.0f, fleeSpeed));
        goalAdder.accept((Object)pokemonEntity, (Object)3, (Object)new PokemonMeleeAttackGoal((class_1314)pokemonEntity, pursuitSpeed, true));
        goalAdder.accept((Object)pokemonEntity, (Object)4, (Object)new PokemonPanicGoal((class_1314)pokemonEntity, fleeSpeed));
        goalAdder.accept((Object)pokemonEntity, (Object)1, (Object)new PokemonOwnerHurtByTargetGoal(pokemonEntity));
        goalAdder.accept((Object)pokemonEntity, (Object)2, (Object)new PokemonOwnerHurtTargetGoal(pokemonEntity));
        goalAdder.accept((Object)pokemonEntity, (Object)3, (Object)new class_1399((class_1314)pokemonEntity, new Class[0]));
        goalAdder.accept((Object)pokemonEntity, (Object)4, (Object)new CaughtByTargetGoal((class_1308)pokemonEntity));
        goalAdder.accept((Object)pokemonEntity, (Object)5, new PokemonNearestAttackableTargetGoal<class_1657>((class_1308)pokemonEntity, class_1657.class, 48.0f, true, true));
        goalAdder.accept((Object)pokemonEntity, (Object)6, new PokemonProactiveTargetGoal<class_1308>((class_1308)pokemonEntity, class_1308.class, 5, false, false, arg -> arg instanceof class_1569 && !(arg instanceof class_1548)));
    }

    public static double getFightOrFlightCoefficient(PokemonEntity pokemonEntity) {
        boolean darkLightLevelModifier;
        if (!CobblemonFightOrFlight.config().do_pokemon_attack) {
            return -100.0;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (CobblemonFightOrFlight.SpeciesAlwaysAggro(pokemon.getSpecies().getName().toLowerCase())) {
            return 100.0;
        }
        if (CobblemonFightOrFlight.SpeciesNeverAggro(pokemon.getSpecies().getName().toLowerCase())) {
            return -100.0;
        }
        double pkmnLevel = pokemon.getLevel();
        double lowStatPenalty = pkmnLevel * 1.5 + 30.0;
        double levelAggressionCoefficient = (double)(pokemon.getAttack() + pokemon.getSpecialAttack()) - lowStatPenalty;
        double atkDefRatioCoefficient = pokemon.getAttack() + pokemon.getSpecialAttack() - (pokemon.getDefence() + pokemon.getSpecialDefence());
        double natureAggressionCoefficient = 0.0;
        double darknessAggressionCoefficient = 0.0;
        switch (pokemon.getNature().getDisplayName().toLowerCase()) {
            case "cobblemon.nature.docile": 
            case "cobblemon.nature.timid": 
            case "cobblemon.nature.gentle": 
            case "cobblemon.nature.careful": {
                natureAggressionCoefficient = -2.0;
                break;
            }
            case "cobblemon.nature.relaxed": 
            case "cobblemon.nature.lax": 
            case "cobblemon.nature.quiet": 
            case "cobblemon.nature.bashful": 
            case "cobblemon.nature.calm": {
                natureAggressionCoefficient = -1.0;
                break;
            }
            case "cobblemon.nature.sassy": 
            case "cobblemon.nature.hardy": 
            case "cobblemon.nature.bold": 
            case "cobblemon.nature.impish": 
            case "cobblemon.nature.hasty": {
                natureAggressionCoefficient = 1.0;
                break;
            }
            case "cobblemon.nature.brave": 
            case "cobblemon.nature.rash": 
            case "cobblemon.nature.adamant": 
            case "cobblemon.nature.naughty": {
                natureAggressionCoefficient = 2.0;
                break;
            }
            default: {
                natureAggressionCoefficient = 0.0;
            }
        }
        ElementalType typePrimary = pokemon.getPrimaryType();
        ElementalType typeSecondary = pokemon.getSecondaryType();
        if (typeSecondary == null) {
            typeSecondary = typePrimary;
        }
        boolean ghostLightLevelModifier = CobblemonFightOrFlight.config().ghost_light_level_aggro && (typePrimary.getName() == "ghost" || typeSecondary.getName() == "ghost");
        boolean bl = darkLightLevelModifier = CobblemonFightOrFlight.config().dark_light_level_aggro && (typePrimary.getName() == "dark" || typeSecondary.getName() == "dark");
        if (ghostLightLevelModifier || darkLightLevelModifier) {
            int skyDarken = pokemonEntity.method_37908().method_8594();
            int lightLevel = pokemonEntity.method_37908().method_22335(pokemonEntity.method_24515(), skyDarken);
            if (lightLevel <= 7) {
                darknessAggressionCoefficient = pkmnLevel;
            } else if (lightLevel >= 12) {
                darknessAggressionCoefficient -= pkmnLevel;
            }
        }
        levelAggressionCoefficient = Math.max(-(pkmnLevel + 5.0), Math.min(pkmnLevel, 1.5 * levelAggressionCoefficient));
        atkDefRatioCoefficient = Math.max(-pkmnLevel, 1.0 * atkDefRatioCoefficient);
        natureAggressionCoefficient = pkmnLevel * 0.5 * natureAggressionCoefficient;
        double finalResult = levelAggressionCoefficient + atkDefRatioCoefficient + natureAggressionCoefficient + darknessAggressionCoefficient;
        return finalResult;
    }

    public static boolean SpeciesAlwaysAggro(String speciesName) {
        for (String aggroSpecies : CobblemonFightOrFlight.config().always_aggro) {
            if (!aggroSpecies.equals(speciesName)) continue;
            return true;
        }
        return false;
    }

    public static boolean SpeciesNeverAggro(String speciesName) {
        for (String passiveSpecies : CobblemonFightOrFlight.config().never_aggro) {
            if (!passiveSpecies.equals(speciesName)) continue;
            return true;
        }
        return false;
    }

    public static void PokemonEmoteAngry(class_1308 mob) {
        double particleSpeed = Math.random();
        double particleAngle = Math.random() * 2.0 * Math.PI;
        double particleXSpeed = Math.cos(particleAngle) * particleSpeed;
        double particleYSpeed = Math.sin(particleAngle) * particleSpeed;
        class_1937 class_19372 = mob.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_14199((class_2394)class_2398.field_11231, mob.method_19538().field_1352, mob.method_5829().field_1325, mob.method_19538().field_1350, 1, particleXSpeed, 0.5, particleYSpeed, 1.0);
        } else {
            mob.method_37908().method_8406((class_2394)class_2398.field_11231, mob.method_19538().field_1352, mob.method_5829().field_1325, mob.method_19538().field_1350, particleXSpeed, 0.5, particleYSpeed);
        }
    }
}

