/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.drum;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DominantDrumType;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumButtonType;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumNoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.DrumOptionsScren;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_7849;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AratakisGreatAndGloriousDrumScreen
extends InstrumentScreen {
    public static final class_2960 INSTRUMENT_ID = new class_2960("genshinstrument", "glorious_drum");
    public static final String[] NOTE_LAYOUT = new String[]{"D", "G"};
    private final HashMap<class_3675.class_306, NoteButton> notes = new HashMap();
    public static final InstrumentThemeLoader THEME_LOADER = new InstrumentThemeLoader(INSTRUMENT_ID);

    @Override
    public class_2960 getInstrumentId() {
        return INSTRUMENT_ID;
    }

    @Override
    public Map<class_3675.class_306, NoteButton> noteMap() {
        return this.notes;
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new DrumOptionsScren(this);
    }

    @Override
    protected void method_25426() {
        this.initOptionsButton(this.field_22790 / 2 + 25);
        class_7849 layout1 = this.createRow(DrumButtonType.DON, 2.0f);
        class_7849 layout2 = this.createRow(DrumButtonType.KA, 1.3f);
        layout1.method_48222();
        layout2.method_48222();
        layout1.method_48229((this.field_22789 - layout1.method_25368()) / 2, (int)((float)this.field_22790 * 0.8f));
        layout2.method_48229((this.field_22789 - layout2.method_25368()) / 2, layout1.method_46427() - layout1.method_25364() / 2);
        layout1.method_48222();
        layout2.method_48222();
        layout1.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        layout2.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.notesIterable().forEach(NoteButton::init);
        super.method_25426();
    }

    private class_7849 createRow(DrumButtonType type, float widthPercent) {
        class_7849 layout = new class_7849(0, 0, (int)((float)this.field_22789 / widthPercent), this.getNoteSize(), class_7849.class_7851.field_40789);
        this.createButton(type, layout, false);
        this.createButton(type, layout, true);
        return layout;
    }

    private DrumNoteButton createButton(DrumButtonType btnType, class_7849 container, boolean isRight) {
        DrumNoteButton btn = new DrumNoteButton(btnType, isRight, this);
        container.method_46495((class_8021)btn);
        this.notes.put(btn.getKey(), btn);
        return btn;
    }

    @Override
    public String[] noteLayout() {
        return NOTE_LAYOUT;
    }

    @Override
    public InstrumentThemeLoader getThemeLoader() {
        return THEME_LOADER;
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return new InstrumentMidiReceiver(this){
            private static boolean donRight = false;
            private static boolean kaRight = false;

            @Override
            @Nullable
            protected NoteButton handleMidiPress(int note, int key) {
                boolean isKa = AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.KA || AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.BOTH && note >= 12;
                AratakisGreatAndGloriousDrumScreen.this.setPitch(note - (isKa ? 19 : 2));
                for (NoteButton noteButton : AratakisGreatAndGloriousDrumScreen.this.notesIterable()) {
                    DrumNoteButton dnb = (DrumNoteButton)noteButton;
                    if (dnb.btnType != (isKa ? DrumButtonType.KA : DrumButtonType.DON)) continue;
                    if (isKa) {
                        if (dnb.isRight != kaRight) continue;
                        kaRight = !kaRight;
                        return dnb;
                    }
                    if (dnb.isRight != donRight) continue;
                    donRight = !donRight;
                    return dnb;
                }
                return null;
            }

            @Override
            protected NoteButton getLowestNote() {
                return AratakisGreatAndGloriousDrumScreen.this.notes.values().stream().map(btn -> (DrumNoteButton)((Object)btn)).filter(btn -> btn.btnType == this.getDrumTypeOf(DrumButtonType.DON)).findFirst().get();
            }

            @Override
            protected NoteButton getHighestNote() {
                return AratakisGreatAndGloriousDrumScreen.this.notes.values().stream().map(btn -> (DrumNoteButton)((Object)btn)).filter(btn -> btn.btnType == this.getDrumTypeOf(DrumButtonType.KA)).findFirst().get();
            }

            private DrumButtonType getDrumTypeOf(DrumButtonType btnType) {
                DominantDrumType ddt = AratakisGreatAndGloriousDrumScreen.ddt();
                return ddt == DominantDrumType.BOTH ? btnType : (ddt == DominantDrumType.DON ? DrumButtonType.DON : DrumButtonType.KA);
            }

            @Override
            protected int minMidiNote() {
                return AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.BOTH || AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.DON ? -10 : 7;
            }

            @Override
            protected int maxMidiNote() {
                return AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.BOTH || AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.KA ? 32 : 15;
            }
        };
    }

    private static DominantDrumType ddt() {
        return (DominantDrumType)((Object)ModClientConfigs.DOMINANT_DRUM_TYPE.get());
    }
}

