/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.label.NoteGridLabel;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentMidiReceiver;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.NoteGrid;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.GridInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteGridButtonIdentifier;
import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_7838;

@Environment(value=EnvType.CLIENT)
public abstract class GridInstrumentScreen
extends InstrumentScreen {
    public static final String[] NOTE_LAYOUT = new String[]{"C", "D", "E", "F", "G", "A", "B"};
    public static final int DEF_ROWS = 7;
    public static final int DEF_COLUMNS = 3;
    public static final int CLEF_WIDTH = 26;
    public static final int CLEF_HEIGHT = 52;
    protected class_7838 grid;
    public final NoteGrid noteGrid = this.initNoteGrid();
    private final Map<class_3675.class_306, NoteButton> noteMap = this.noteGrid.genKeyboardMap(InstrumentKeyMappings.GRID_INSTRUMENT_MAPPINGS);

    public int columns() {
        return 3;
    }

    public int rows() {
        return 7;
    }

    public abstract NoteSound[] getInitSounds();

    @Override
    public void setNoteSounds(NoteSound[] sounds) {
        this.noteGrid.setNoteSounds(sounds);
    }

    public boolean isSSTI() {
        return false;
    }

    @Override
    public void setPitch(int pitch) {
        if (!this.isSSTI()) {
            super.setPitch(pitch);
        }
    }

    @Override
    protected void initPitch(Consumer<Integer> pitchConsumer) {
        if (!this.isSSTI()) {
            super.initPitch(pitchConsumer);
        }
    }

    @Override
    protected boolean identifyByPitch() {
        return this.isSSTI();
    }

    @Override
    public NoteButton getNoteButton(NoteButtonIdentifier noteIdentifier) throws IndexOutOfBoundsException, NoSuchElementException {
        if (!(noteIdentifier instanceof NoteGridButtonIdentifier)) {
            return super.getNoteButton(noteIdentifier);
        }
        return this.getNoteButton((NoteGridButtonIdentifier)noteIdentifier);
    }

    public NoteButton getNoteButton(NoteGridButtonIdentifier noteIdentifier) throws IndexOutOfBoundsException {
        return this.getNoteButton(noteIdentifier.row, this.noteGrid.getFlippedColumn(noteIdentifier.column));
    }

    public NoteButton getNoteButton(int row, int column) throws IndexOutOfBoundsException {
        return this.noteGrid.getNoteButton(row, column);
    }

    public NoteButton getNoteButtonByMIDINote(int note) {
        return this.getNoteButton(note % this.rows(), note / this.rows());
    }

    public NoteGridButton createNote(int row, int column, int pitch) {
        return new NoteGridButton(row, column, this, pitch);
    }

    public NoteGridButton createNote(int row, int column) {
        return new NoteGridButton(row, column, this);
    }

    public static NoteLabelSupplier getInitLabelSupplier() {
        return ((NoteGridLabel)ModClientConfigs.GRID_LABEL_TYPE.get()).getLabelSupplier();
    }

    public NoteGrid initNoteGrid() {
        return this.isSSTI() ? new NoteGrid(this, NoteSound.MIN_PITCH) : new NoteGrid(this);
    }

    @Override
    public Map<class_3675.class_306, NoteButton> noteMap() {
        return this.noteMap;
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new GridInstrumentOptionsScreen(this);
    }

    @Override
    public String[] noteLayout() {
        return NOTE_LAYOUT;
    }

    @Override
    protected void method_25426() {
        this.grid = this.noteGrid.initNoteGridLayout(0.9f, this.field_22789, this.field_22790);
        this.grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.initOptionsButton(this.grid.method_46427() - 15);
        super.method_25426();
    }

    @Override
    public void renderInstrument(class_332 gui, int pMouseX, int pMouseY, float pPartialTick) {
        if (((Boolean)ModClientConfigs.RENDER_BACKGROUND.get()).booleanValue()) {
            RenderSystem.enableBlend();
            ClientUtil.setShaderColor(Color.WHITE, 0.6f);
            this.renderInstrumentBackground(gui);
            ClientUtil.resetShaderColor();
        }
        super.renderInstrument(gui, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderInstrumentBackground(class_332 gui) {
        int clefX = this.grid.method_46426() - this.getNoteSize() + 8;
        if (this.columns() == 3) {
            this.renderClef(gui, 0, clefX, "treble");
            this.renderClef(gui, 1, clefX, "alto");
            this.renderClef(gui, 2, clefX, "bass");
        }
        for (int i = 0; i < this.columns(); ++i) {
            this.renderStaff(gui, i);
        }
    }

    protected void renderClef(class_332 gui, int index, int x, String clefName) {
        RenderSystem.enableBlend();
        gui.method_25290(GridInstrumentScreen.getInternalResourceFromGlob("background/clef/" + clefName + ".png"), x, this.grid.method_46427() + NoteGrid.getPaddingVert() + this.getLayerAddition(index) - 5, 0.0f, 0.0f, 26, 52, 26, 52);
        RenderSystem.disableBlend();
    }

    protected void renderStaff(class_332 gui, int index) {
        RenderSystem.enableBlend();
        gui.method_25290(GridInstrumentScreen.getInternalResourceFromGlob("background/staff.png"), this.grid.method_46426() + 2, this.grid.method_46427() + NoteGrid.getPaddingVert() + this.getLayerAddition(index), 0.0f, 0.0f, this.grid.method_25368() - 5, this.getNoteSize(), this.grid.method_25368() - 5, this.getNoteSize());
        RenderSystem.disableBlend();
    }

    protected int getLayerAddition(int index) {
        return index * (this.getNoteSize() + NoteGrid.getPaddingVert() * 2);
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return this.rows() != 7 || this.isSSTI() ? null : new GridInstrumentMidiReceiver(this);
    }
}

