/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.NoteAnimationController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class NoteButtonRenderer {
    protected static final class_310 MINECRAFT = class_310.method_1551();
    private static final double SHARP_MULTIPLIER = 0.9;
    protected static final double NOTE_DUR = 0.15;
    protected static final double NOTE_TARGET_VAL = 9.0;
    public final NoteButton noteButton;
    protected final InstrumentScreen instrumentScreen;
    protected final class_2960 rootLocation;
    protected final class_2960 accidentalsLocation;
    protected final class_2960 notePressedLocation;
    protected final class_2960 noteReleasedLocation;
    protected final class_2960 noteHoverLocation;
    protected Supplier<class_2960> noteTextureProvider;
    public final NoteAnimationController noteAnimation;
    public boolean foreignPlaying = false;
    protected final ArrayList<NoteRing> rings = new ArrayList();
    private int labelX;
    private int labelY;

    protected NoteAnimationController initNoteAnimation() {
        return new NoteAnimationController(0.15, 9.0, this.noteButton);
    }

    public NoteButtonRenderer(NoteButton noteButton, Supplier<class_2960> noteTextureProvider) {
        this.noteButton = noteButton;
        this.noteTextureProvider = noteTextureProvider;
        this.instrumentScreen = noteButton.instrumentScreen;
        this.noteAnimation = this.initNoteAnimation();
        this.rootLocation = this.instrumentScreen.getResourceFromRoot("note");
        this.accidentalsLocation = this.getResourceFromRoot("accidentals.png");
        this.notePressedLocation = this.getResourceFromRoot("note/pressed.png");
        this.noteReleasedLocation = this.getResourceFromRoot("note/released.png");
        this.noteHoverLocation = this.getResourceFromRoot("note/hovered.png");
    }

    public void render(class_332 gui, int mouseX, int mouseY, float partialTick, InstrumentThemeLoader themeLoader) {
        RenderSystem.enableBlend();
        this.rings.removeIf(ring -> !ring.isPlaying());
        this.rings.forEach(ring -> ring.render(gui, themeLoader));
        this.renderNoteButton(gui, themeLoader);
        this.renderNote(gui, themeLoader);
        this.renderLabel(gui, themeLoader);
        this.renderAccidentals(gui, themeLoader);
        this.noteAnimation.update();
    }

    protected void renderNoteButton(class_332 gui, InstrumentThemeLoader themeLoader) {
        class_2960 noteLocation = this.noteButton.isPlaying() ? (this.foreignPlaying ? this.noteHoverLocation : this.notePressedLocation) : (this.noteButton.method_25367() ? this.noteHoverLocation : this.noteReleasedLocation);
        gui.method_25290(noteLocation, this.noteButton.method_46426(), this.noteButton.method_46427(), 0.0f, 0.0f, this.noteButton.method_25368(), this.noteButton.method_25364(), this.noteButton.method_25368(), this.noteButton.method_25364());
    }

    protected void renderNote(class_332 gui, InstrumentThemeLoader themeLoader) {
        int noteWidth = this.noteButton.method_25368() / 2;
        int noteHeight = this.noteButton.method_25364() / 2;
        ClientUtil.setShaderColor(this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.notePressed() : themeLoader.noteReleased());
        gui.method_25290(this.noteTextureProvider.get(), this.noteButton.method_46426() + noteWidth / 2, this.noteButton.method_46427() + noteHeight / 2, 0.0f, 0.0f, noteWidth, noteHeight, noteWidth, this.noteButton.method_25364() / 2);
        ClientUtil.resetShaderColor();
    }

    public void setLabelX(int labelX) {
        this.labelX = labelX;
    }

    public void setLabelY(int labelY) {
        this.labelY = labelY;
    }

    protected void renderLabel(class_332 gui, InstrumentThemeLoader themeLoader) {
        gui.method_27534(NoteButtonRenderer.MINECRAFT.field_1772, this.noteButton.method_25369(), this.labelX, this.labelY, (this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.labelPressed() : themeLoader.labelReleased()).getRGB());
    }

    protected void renderAccidentals(class_332 gui, InstrumentThemeLoader themeLoader) {
        RenderSystem.enableBlend();
        switch (this.noteButton.getNotation()) {
            case NONE: {
                break;
            }
            case FLAT: {
                this.renderAccidental(gui, 0);
                break;
            }
            case SHARP: {
                this.renderAccidental(gui, 1);
                break;
            }
            case DOUBLE_FLAT: {
                this.renderAccidental(gui, 0, -6, -3);
                this.renderAccidental(gui, 0, 5, 2);
                break;
            }
            case DOUBLE_SHARP: {
                this.renderAccidental(gui, 2, -1, 0);
            }
        }
    }

    protected void renderAccidental(class_332 gui, int index) {
        this.renderAccidental(gui, index, 0, 0);
    }

    protected void renderAccidental(class_332 gui, int index, int offsetX, int offsetY) {
        double textureMultiplier = (double)this.noteButton.method_25368() * (index == 1 ? 0.9 : 1.0) * 2.0;
        int textureWidth = (int)textureMultiplier;
        int textureHeight = (int)textureMultiplier - 1;
        int spritePartWidth = textureWidth / 3 + 1;
        gui.method_25290(this.accidentalsLocation, this.noteButton.method_46426() - 9 + offsetX, this.noteButton.method_46427() - 5 + offsetY, (float)(spritePartWidth * index), this.noteButton.isPlaying() ? (float)((textureHeight + 1) / 2) : 0.0f, spritePartWidth - 1, textureHeight / 2, textureWidth, textureHeight);
    }

    public void playNoteAnimation(boolean isForeign) {
        this.foreignPlaying = isForeign;
        this.noteAnimation.play(isForeign);
        this.addRing();
    }

    public void addRing() {
        NoteRing ring = new NoteRing(this.noteButton, this.foreignPlaying);
        this.rings.add(ring);
        ring.playAnim();
    }

    public void resetAnimations() {
        this.rings.clear();
        this.noteAnimation.stop();
    }

    protected class_2960 getResourceFromRoot(String path) {
        return CommonUtil.getResourceFrom(this.rootLocation, path);
    }
}

