/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation;

import com.cstav.genshinstrument.client.AnimationController;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RingAnimationController
extends AnimationController {
    public static final float INIT_ALPHA = -0.08f;
    protected final double initSize;
    protected final NoteRing ring;
    protected final double ringSizeMultiplier;
    private double dSize;

    public RingAnimationController(double duration, double ringSizeMultiplier, NoteRing ring) {
        super(duration, 1.1f);
        this.ringSizeMultiplier = ringSizeMultiplier;
        this.ring = ring;
        this.initSize = (double)ring.note.instrumentScreen.getNoteSize() * 0.8;
    }

    @Override
    protected void animFrame(double targetTime, double deltaValue) {
        this.ring.size = (int)(this.dSize += deltaValue * this.ringSizeMultiplier);
        this.ring.alpha = (double)this.getAnimTime() < targetTime / 1.75 ? (this.ring.alpha += (float)(deltaValue * 1.5)) : (this.ring.alpha -= (float)deltaValue);
    }

    @Override
    protected void resetAnimVars() {
        super.resetAnimVars();
        this.dSize = this.initSize;
        this.ring.size = (int)this.dSize;
        this.ring.alpha = -0.08f;
    }

    public void play(float initAlpha) {
        this.play();
        this.ring.alpha = initAlpha;
    }
}

