/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.HeldNoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.IHoldableNoteButton;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class HeldGridNoteButton
extends NoteGridButton
implements IHoldableNoteButton {
    private boolean isHeld = false;
    private HeldNoteSound heldNoteSound;
    private int pressedCounter = 0;

    public HeldGridNoteButton(int row, int column, GridInstrumentScreen instrumentScreen, HeldNoteSound[] heldNoteSounds) {
        super(row, column, instrumentScreen);
        this.heldNoteSound = heldNoteSounds[this.posToIndex()];
    }

    public HeldGridNoteButton(int row, int column, GridInstrumentScreen instrumentScreen, int pitch, HeldNoteSound[] heldNoteSounds) {
        super(row, column, instrumentScreen, pitch);
        this.heldNoteSound = heldNoteSounds[this.posToIndex()];
    }

    @Override
    public void setSound(NoteSound sound) {
        GInstrumentMod.LOGGER.warn("Attempted to set the sound of a held note button; ignoring");
    }

    @Override
    public HeldNoteSound getHeldNoteSound() {
        return this.heldNoteSound;
    }

    @Override
    public void setHeldNoteSound(HeldNoteSound heldNoteSound) {
        this.heldNoteSound = heldNoteSound;
    }

    @Override
    public boolean isPlaying() {
        return this.isHeld();
    }

    @Override
    public boolean isHeld() {
        return this.isHeld;
    }

    @Override
    public void setHeld(boolean held) {
        this.isHeld = held;
    }

    @Override
    public void release() {
        this.releaseHeld(false);
    }

    @Override
    public void releaseHeld(int notePitch, boolean targetPitch, HeldNoteSound heldSound) {
        super.release();
        IHoldableNoteButton.super.releaseHeld(notePitch, targetPitch, heldSound);
    }

    @Override
    protected void playLocalSound(NoteSound sound, int pitch) {
        this.playLocalHeldSound(sound, pitch);
    }

    @Override
    protected void sendNotePlayPacket(NoteSound sound, int pitch) {
        this.sendNoteHeldPacket(sound, pitch, HeldSoundPhase.ATTACK);
    }

    @Override
    public void playAttackAnimation(boolean isForeign) {
        ++this.pressedCounter;
        IHoldableNoteButton.super.playAttackAnimation(isForeign);
    }

    @Override
    public void playReleaseAnimation(boolean isForeign) {
        this.pressedCounter = Math.max(0, this.pressedCounter - 1);
        IHoldableNoteButton.super.playReleaseAnimation(isForeign);
    }

    @Override
    protected HeldNoteButtonRenderer initNoteRenderer() {
        return new HeldNoteButtonRenderer(this, this::getTextureAtRow);
    }

    @Override
    public boolean releaseAnimationPlayable() {
        return this.pressedCounter == 0;
    }
}

