/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.vintagelyre;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentMidiReceiver;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.vintagelyre.VintageNoteButton;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.VintageLyreOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.client.midi.MidiOverflowResult;
import com.cstav.genshinstrument.client.midi.PressedMIDINote;
import com.cstav.genshinstrument.sound.GISounds;
import com.cstav.genshinstrument.sound.NoteSound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class VintageLyreScreen
extends GridInstrumentScreen {
    public static final class_2960 INSTRUMENT_ID = new class_2960("genshinstrument", "vintage_lyre");
    public static final String[] NOTE_LAYOUT = new String[]{"C", "Db", "Eb", "F", "G", "Ab", "Bb", "C", "D", "Eb", "F", "G", "A", "Bb", "C", "D", "Eb", "F", "G", "A", "Bb"};
    public static final InstrumentThemeLoader THEME_LOADER = new InstrumentThemeLoader(INSTRUMENT_ID);

    @Override
    public class_2960 getInstrumentId() {
        return INSTRUMENT_ID;
    }

    @Override
    public NoteSound[] getInitSounds() {
        return GISounds.VINTAGE_LYRE_NOTE_SOUNDS;
    }

    @Override
    public String[] noteLayout() {
        return this.shouldSoundNormalize() ? GridInstrumentScreen.NOTE_LAYOUT : NOTE_LAYOUT;
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new VintageLyreOptionsScreen(this);
    }

    public boolean shouldSoundNormalize() {
        return (Boolean)ModClientConfigs.NORMALIZE_VINTAGE_LYRE.get() != false && this.getPitch() != NoteSound.MAX_PITCH;
    }

    @Override
    public VintageNoteButton createNote(int row, int column) {
        return new VintageNoteButton(row, column, this);
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return new GridInstrumentMidiReceiver(this){

            @Override
            protected PressedMIDINote playNote(NoteButton noteBtn, @Nullable MidiOverflowResult midiOverflow, int basePitch) {
                if (midiOverflow == null || midiOverflow.type() != MidiOverflowResult.OverflowType.TOP) {
                    return super.playNote(noteBtn, midiOverflow, basePitch);
                }
                int offsetFix = VintageLyreScreen.this.shouldSoundNormalize() ? 1 : (((VintageNoteButton)noteBtn).isDefaultFlat() ? 0 : 1);
                int newPitch = basePitch + offsetFix;
                if (newPitch + midiOverflow.pitchOffset() > NoteSound.MAX_PITCH) {
                    return null;
                }
                return super.playNote(noteBtn, midiOverflow, newPitch);
            }
        };
    }

    @Override
    public InstrumentThemeLoader getThemeLoader() {
        return THEME_LOADER;
    }
}

