/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.INoteLabel;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.midi.MidiOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.CommonUtil;
import com.cstav.genshinstrument.util.LabelUtil;
import com.ibm.icu.text.DecimalFormat;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7845;
import net.minecraft.class_7849;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class InstrumentOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final class_5250 MIDI_OPTIONS = class_2561.method_43471((String)"label.genshinstrument.midiOptions");
    private static final String SOUND_CHANNEL_KEY = "button.genshinstrument.audioChannels";
    private static final String STOP_MUSIC_KEY = "button.genshinstrument.stop_music_on_play";
    @Nullable
    protected final INoteLabel[] labels = this.getLabels();
    @Nullable
    protected INoteLabel currLabel;

    public abstract INoteLabel[] getLabels();

    public abstract INoteLabel getCurrentLabel();

    public boolean isPitchSliderEnabled() {
        return true;
    }

    public InstrumentOptionsScreen(@Nullable InstrumentScreen screen) {
        super((class_2561)class_2561.method_43471((String)"button.genshinstrument.instrumentOptions"), screen);
    }

    public InstrumentOptionsScreen(class_437 lastScreen) {
        super((class_2561)class_2561.method_43471((String)"button.genshinstrument.instrumentOptions"), lastScreen);
    }

    protected void method_25426() {
        this.currLabel = this.getCurrentLabel();
        class_7845 grid = ClientUtil.createSettingsGrid();
        this.initOptionsGrid(grid, grid.method_47610(2));
        grid.method_48222();
        ClientUtil.alignGrid((class_8133)grid, this.field_22789, this.field_22790);
        grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        int buttonsY = ClientUtil.lowerButtonsY(grid.method_46427(), grid.method_25364(), this.field_22790);
        int buttonsWidth = 150;
        class_4185 doneBtn = class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.method_25419()).method_46432(150).method_46431();
        if (!this.isOverlay || ((InstrumentScreen)((Object)this.instrumentScreen.get())).isMidiInstrument()) {
            class_7849 buttonLayout = new class_7849(grid.method_46426() + this.getSmallButtonWidth() - 150 + 4, buttonsY, 308, this.getButtonHeight(), class_7849.class_7851.field_40789);
            class_4185 midiOptions = class_4185.method_46430((class_2561)MIDI_OPTIONS.method_27661().method_27693("..."), btn -> this.openMidiOptions()).method_46432(150).method_46431();
            buttonLayout.method_46495((class_8021)midiOptions);
            buttonLayout.method_46495((class_8021)doneBtn);
            buttonLayout.method_48222();
            buttonLayout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
        } else {
            doneBtn.method_48229((this.field_22789 - doneBtn.method_25368()) / 2, buttonsY);
            this.method_37063((class_364)doneBtn);
        }
    }

    protected void initAudioSection(class_7845 grid, class_7845.class_7939 rowHelper) {
        class_5676 instrumentChannel = class_5676.method_32606(soundType -> class_2561.method_43471((String)("button.genshinstrument.audioChannels." + soundType.getKey()))).method_32624((Object[])InstrumentChannelType.values()).method_32619((Object)((InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get()))).method_32618(soundType -> class_7919.method_47407((class_2561)(switch (soundType) {
            case InstrumentChannelType.MIXED -> InstrumentOptionsScreen.translatableArgs("button.genshinstrument.audioChannels.mixed.tooltip", 5.5);
            case InstrumentChannelType.STEREO -> class_2561.method_43471((String)"button.genshinstrument.audioChannels.stereo.tooltip");
            default -> class_5244.field_39003;
        }))).method_32617(0, 0, this.getBigButtonWidth(), 20, (class_2561)class_2561.method_43471((String)SOUND_CHANNEL_KEY), this::onChannelTypeChanged);
        rowHelper.method_47613((class_8021)instrumentChannel, 2);
        if (this.isPitchSliderEnabled()) {
            SliderButton pitchSlider = new SliderButton(this.getSmallButtonWidth(), this.getPitch(), NoteSound.MIN_PITCH, NoteSound.MAX_PITCH){
                private static final DecimalFormat D_FORMAT = new DecimalFormat("0.00");
                private int pitch;
                {
                    this.pitch = InstrumentOptionsScreen.this.getPitch();
                }

                @Override
                public class_2561 method_25369() {
                    return class_2561.method_43471((String)"button.genshinstrument.pitch").method_27693(": " + LabelUtil.formatNoteName(LabelUtil.getNoteName(this.pitch, GridInstrumentScreen.NOTE_LAYOUT, 0), false) + " (" + D_FORMAT.format((double)NoteSound.getPitchByNoteOffset(this.pitch)) + ")");
                }

                protected void method_25344() {
                    this.pitch = (int)this.getValueClamped();
                    InstrumentOptionsScreen.this.onPitchChanged(this, this.pitch);
                }
            };
            rowHelper.method_47612((class_8021)pitchSlider);
        }
        SliderButton volumeSlider = new SliderButton(this.getSmallButtonWidth(), this.getVolume(), 0.0, 1.0){

            @Override
            public class_2561 method_25369() {
                return class_2561.method_43471((String)"button.genshinstrument.volume").method_27693(": " + (int)(this.field_22753 * 100.0) + "%");
            }

            protected void method_25344() {
                InstrumentOptionsScreen.this.onVolumeChanged(this, this.field_22753);
            }
        };
        rowHelper.method_47612((class_8021)volumeSlider);
    }

    protected void initVisualsSection(class_7845 grid, class_7845.class_7939 rowHelper) {
        class_5676 stopMusic = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.STOP_MUSIC_ON_PLAY.get())).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43469((String)"button.genshinstrument.stop_music_on_play.tooltip", (Object[])new Object[]{10.0}))).method_32617(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)STOP_MUSIC_KEY), this::onMusicStopChanged);
        rowHelper.method_47612((class_8021)stopMusic);
        class_5676 sharedInstrument = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get())).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"button.genshinstrument.shared_instrument.tooltip"))).method_32617(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.shared_instrument"), this::onSharedInstrumentChanged);
        rowHelper.method_47612((class_8021)sharedInstrument);
        class_5676 accurateNotes = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333).method_32619((Object)((Boolean)ModClientConfigs.ACCURATE_NOTES.get())).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"button.genshinstrument.accurate_notes.tooltip"))).method_32617(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.accurate_notes"), this::onAccurateNotesChanged);
        rowHelper.method_47612((class_8021)accurateNotes);
        if (this.labels != null) {
            class_5676 labelType = class_5676.method_32606(label -> class_2561.method_43471((String)label.getKey())).method_32624((Object[])this.labels).method_32619((Object)this.currLabel).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)(value.getKey() + ".description")))).method_32617(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (class_2561)class_2561.method_43471((String)"button.genshinstrument.label"), this::onLabelChanged);
            rowHelper.method_47613((class_8021)labelType, 2);
        }
    }

    protected void initOptionsGrid(class_7845 grid, class_7845.class_7939 rowHelper) {
        this.initAudioSection(grid, rowHelper);
        rowHelper.method_47613((class_8021)class_7852.method_46513((int)7), 2);
        this.initVisualsSection(grid, rowHelper);
    }

    private int getPitch() {
        return this.instrumentScreen.map(InstrumentScreen::getPitch).orElseGet((Supplier<Integer>)ModClientConfigs.PITCH);
    }

    private double getVolume() {
        return this.instrumentScreen.map(screen -> screen.volume()).orElseGet((Supplier<Double>)ModClientConfigs.VOLUME);
    }

    protected void onPitchChanged(class_357 slider, int pitch) {
        this.instrumentScreen.ifPresentOrElse(screen -> {
            if (screen.getPitch() == pitch) {
                return;
            }
            screen.setPitch(pitch);
            this.savePitch(pitch);
        }, () -> this.queueToSave("pitch", () -> this.savePitch(pitch)));
    }

    protected void savePitch(int newPitch) {
        ModClientConfigs.PITCH.set((Object)newPitch);
    }

    protected void onVolumeChanged(class_357 slider, double volume) {
        int newVolume = (int)(volume * 100.0);
        this.instrumentScreen.ifPresent(screen -> {
            screen.volume = newVolume;
        });
        this.queueToSave("volume", () -> this.saveVolume((double)newVolume / 100.0));
    }

    protected void saveVolume(double newVolume) {
        ModClientConfigs.VOLUME.set((Object)CommonUtil.round(newVolume, 4));
    }

    protected void onLabelChanged(class_5676<INoteLabel> button, INoteLabel label) {
        this.instrumentScreen.ifPresent(screen -> screen.setLabelSupplier(label.getLabelSupplier()));
        this.saveLabel(label);
    }

    protected abstract void saveLabel(INoteLabel var1);

    protected void onChannelTypeChanged(class_5676<InstrumentChannelType> button, InstrumentChannelType type) {
        ModClientConfigs.CHANNEL_TYPE.set((Object)type);
    }

    protected void onMusicStopChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.STOP_MUSIC_ON_PLAY.set((Object)value);
    }

    protected void onSharedInstrumentChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.SHARED_INSTRUMENT.set((Object)value);
    }

    protected void onAccurateNotesChanged(class_5676<Boolean> button, boolean value) {
        ModClientConfigs.ACCURATE_NOTES.set((Object)value);
        this.instrumentScreen.ifPresent(screen -> screen.notesIterable().forEach(NoteButton::updateNoteLabel));
    }

    protected void openMidiOptions() {
        this.field_22787.method_1507((class_437)new MidiOptionsScreen((class_2561)MIDI_OPTIONS, (class_437)this, this.instrumentScreen));
    }

    @Override
    public void method_25419() {
        if (!this.isOverlay) {
            super.method_25419();
            return;
        }
        this.saveOptions();
        ((InstrumentScreen)((Object)this.instrumentScreen.get())).onOptionsClose();
    }

    private static class_5250 translatableArgs(String key, Object arg) {
        return class_2561.method_43470((String)class_2561.method_43471((String)key).getString().replace("%s", arg.toString()));
    }
}

