/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.midi;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.event.MidiEvent;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public abstract class MidiController {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LinkedHashMap<MidiDevice.Info, MidiDevice> DEVICES = new LinkedHashMap();
    private static MidiDevice currDevice;
    private static Transmitter deviceTransmitter;
    private static MidiDevice.Info info;
    private static boolean isTransmitting;

    public static void reloadDevices() {
        MidiDevice.Info[] infos;
        LOGGER.info("Reloading MIDI devices...");
        DEVICES.clear();
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                device.getTransmitter();
                DEVICES.put(info, device);
            }
            catch (MidiUnavailableException e) {
                LOGGER.warn("MIDI device " + info.getName().strip() + " cannot transmit MIDI; omitting!");
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error occurred while trying to obtain MIDI device!", (Throwable)e);
            }
        }
    }

    public static boolean reloadIfEmpty() {
        if (DEVICES.isEmpty()) {
            MidiController.reloadDevices();
        }
        return DEVICES.isEmpty();
    }

    public static void loadDevice(int infoIndex) {
        if (MidiController.reloadIfEmpty()) {
            LOGGER.warn("Attempted to load MIDI device #" + infoIndex + ", but there are no devices available!");
            return;
        }
        MidiController.unloadDevice();
        info = MidiController.getInfoFromIndex(infoIndex);
        currDevice = DEVICES.get(info);
    }

    public static void unloadDevice() {
        if (deviceTransmitter != null) {
            deviceTransmitter.close();
        }
        if (currDevice != null) {
            currDevice.close();
        }
        isTransmitting = false;
    }

    public static void loadByConfigs() {
        if (!((Boolean)ModClientConfigs.MIDI_ENABLED.get()).booleanValue()) {
            MidiController.unloadDevice();
            return;
        }
        int infoIndex = (Integer)ModClientConfigs.MIDI_DEVICE_INDEX.get();
        if (infoIndex == -1) {
            return;
        }
        MidiController.reloadIfEmpty();
        if (infoIndex > DEVICES.size() - 1) {
            LogUtils.getLogger().warn("MIDI device out of range; setting device to none");
            ModClientConfigs.MIDI_DEVICE_INDEX.set((Object)-1);
            return;
        }
        if (!MidiController.isLoaded(infoIndex)) {
            MidiController.loadDevice(infoIndex);
            MidiController.openForListen();
        }
    }

    public static MidiDevice getCurrDevice() {
        return currDevice;
    }

    public static Transmitter getDeviceTransmitter() {
        return deviceTransmitter;
    }

    public static boolean isLoaded(int infoIndex) {
        return info != null && info.equals(MidiController.getInfoFromIndex(infoIndex));
    }

    public static void openForListen() {
        if (isTransmitting || currDevice == null) {
            return;
        }
        try {
            currDevice.open();
            deviceTransmitter = currDevice.getTransmitter();
            deviceTransmitter.setReceiver(new Receiver(){

                @Override
                public void send(MidiMessage message, long timeStamp) {
                    class_310.method_1551().execute(() -> {
                        try {
                            ((MidiEvent)MidiEvent.EVENT.invoker()).triggered(new MidiEvent.MidiEventArgs(message, timeStamp));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }

                @Override
                public void close() {
                }
            });
            isTransmitting = true;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while opening MIDI device for listen!\nDevice: " + MidiController.infoAsString(info), (Throwable)e);
        }
    }

    public static boolean isTransmitting() {
        return isTransmitting;
    }

    public static int getInfoSerial(MidiDevice.Info info) {
        int i = 0;
        for (MidiDevice.Info _info : DEVICES.keySet()) {
            if (info.equals(_info)) {
                return i;
            }
            ++i;
        }
        LOGGER.error("Failed to retrieve info from devices map!: " + MidiController.infoAsString(info), (Throwable)new RuntimeException());
        return -1;
    }

    public static MidiDevice.Info getInfoFromIndex(int index) {
        Iterator<MidiDevice.Info> infoIterator = DEVICES.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            infoIterator.next();
        }
        return infoIterator.next();
    }

    public static String infoAsString(MidiDevice.Info info) {
        return info.getName().strip() + " - " + info.getDescription() + " (" + info.getVendor() + ")";
    }

    static {
        isTransmitting = false;
    }
}

