/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSoundInstance;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.sound.registrar.HeldNoteSoundRegistrar;
import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public record HeldNoteSound(class_2960 baseSoundLocation, int index, NoteSound attack, NoteSound hold, @Nullable NoteSound release, float holdDuration, float holdDelay, float chainedHoldDelay, float decay, float releaseFadeOut, float fullHoldFadeoutTime) {
    public NoteSound getSound(Phase phase) {
        return switch (phase) {
            default -> throw new IncompatibleClassChangeError();
            case Phase.HOLD -> this.hold;
            case Phase.ATTACK -> this.attack;
            case Phase.RELEASE -> this.release;
        };
    }

    public static NoteSound[] getSounds(HeldNoteSound[] sounds, Phase phase) {
        return (NoteSound[])Arrays.stream(sounds).map(sound -> sound.getSound(phase)).toArray(NoteSound[]::new);
    }

    @Environment(value=EnvType.CLIENT)
    public void startPlaying(int notePitch, float volume, class_1297 initiator, class_2338 pos, InitiatorID initiatorId, class_2960 instrumentId) {
        new HeldNoteSoundInstance(this, Phase.ATTACK, notePitch, volume, initiator, pos, initiatorId, instrumentId).queueAndAddInstance();
    }

    @Environment(value=EnvType.CLIENT)
    public void startPlaying(int notePitch, float volume, class_1297 initiator, InitiatorID initiatorId, class_2960 instrumentId) {
        this.startPlaying(notePitch, volume, initiator, null, initiatorId, instrumentId);
    }

    @Environment(value=EnvType.CLIENT)
    public void startPlaying(int notePitch, float volume, class_1297 initiator, class_2960 instrumentId) {
        this.startPlaying(notePitch, volume, initiator, InitiatorID.fromEntity(initiator), instrumentId);
    }

    @Environment(value=EnvType.CLIENT)
    public void startPlaying(int notePitch, float volume, class_2338 pos, InitiatorID initiatorId, class_2960 instrumentId) {
        this.startPlaying(notePitch, volume, null, pos, initiatorId, instrumentId);
    }

    @Environment(value=EnvType.CLIENT)
    public void startPlaying(int notePitch, float volume, class_2960 instrumentId) {
        this.startPlaying(notePitch, volume, (class_1297)class_310.method_1551().field_1724, instrumentId);
    }

    @Environment(value=EnvType.CLIENT)
    public void playFromServer(Optional<Integer> initiatorId, Optional<InitiatorID> oInitiatorId, NoteSoundMetadata meta, HeldSoundPhase phase) {
        class_746 localPlayer = class_310.method_1551().field_1724;
        class_1937 level = localPlayer.method_37908();
        InitiatorID _initiatorID = InitiatorID.getEither(initiatorId, oInitiatorId);
        if (initiatorId.isPresent()) {
            class_1297 initiator = level.method_8469(initiatorId.get().intValue());
            ((HeldNoteSoundPlayedEvent)HeldNoteSoundPlayedEvent.EVENT.invoker()).triggered(new HeldNoteSoundPlayedEvent.HeldNoteSoundPlayedEventArgs(initiator, this, meta, phase, _initiatorID));
            if (localPlayer.equals((Object)initiator)) {
                return;
            }
        }
        ((HeldNoteSoundPlayedEvent)HeldNoteSoundPlayedEvent.EVENT.invoker()).triggered(new HeldNoteSoundPlayedEvent.HeldNoteSoundPlayedEventArgs(level, this, meta, phase, _initiatorID));
        switch (phase) {
            case ATTACK: {
                this.attackFromServer(_initiatorID, meta);
                break;
            }
            case RELEASE: {
                this.releaseFromServer(_initiatorID, meta);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void attackFromServer(InitiatorID initiatorID, NoteSoundMetadata meta) {
        if (initiatorID.type().equals("entity")) {
            this.startPlaying(meta.pitch(), (float)meta.volume() / 100.0f, class_310.method_1551().field_1687.method_8469(Integer.parseInt(initiatorID.identifier())), meta.instrumentId());
        } else {
            this.startPlaying(meta.pitch(), (float)meta.volume() / 100.0f, meta.pos(), initiatorID, meta.instrumentId());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void releaseFromServer(InitiatorID initiatorID, NoteSoundMetadata meta) {
        HeldNoteSounds.release(initiatorID, this, meta.pitch());
    }

    public void writeToNetwork(class_2540 buf) {
        buf.method_10812(this.baseSoundLocation);
        buf.writeInt(this.index);
    }

    public static HeldNoteSound readFromNetwork(class_2540 buf) {
        return HeldNoteSoundRegistrar.getSounds(buf.method_10810())[buf.readInt()];
    }

    public static enum Phase {
        ATTACK,
        HOLD,
        RELEASE;

    }
}

