/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public record InitiatorID(String type, String identifier) {
    public static final int MAX_UTF_LEN = 65;

    public InitiatorID {
        if (type.length() + identifier.length() > 64) {
            throw new IllegalArgumentException("Initiator type and ID must not exceed length 65");
        }
    }

    public InitiatorID(String id) {
        this(InitiatorID.decompose(id));
    }

    private InitiatorID(String[] decomposed) {
        this(decomposed[0], decomposed[1]);
    }

    private static String[] decompose(String id) {
        String[] result = id.split(":");
        assert (result.length == 2) : "ID must be in the format of type:identifier - received " + id;
        return result;
    }

    public static InitiatorID getEither(Optional<Integer> initiatorId, Optional<InitiatorID> oInitiatorId) {
        return oInitiatorId.orElseGet(() -> InitiatorID.assertIIDPresent(initiatorId.map(arg_0 -> ((class_638)class_310.method_1551().field_1687).method_8469(arg_0)).map(InitiatorID::fromEntity)));
    }

    private static InitiatorID assertIIDPresent(Optional<InitiatorID> initiatorID) {
        assert (initiatorID.isPresent()) : "Must either have an entity initiator or an initiator ID!";
        return initiatorID.get();
    }

    public static InitiatorID fromObj(@NotNull Object initiator) {
        InitiatorID initiatorID;
        if (initiator instanceof class_1297) {
            class_1297 entity = (class_1297)initiator;
            initiatorID = InitiatorID.fromEntity(entity);
        } else {
            initiatorID = new InitiatorID("other", initiator.toString());
        }
        return initiatorID;
    }

    public static InitiatorID fromEntity(@NotNull class_1297 entity) {
        return new InitiatorID("entity", String.valueOf(entity.method_5628()));
    }

    public static InitiatorID readFromNetwork(class_2540 buf) {
        return new InitiatorID(buf.method_19772(), buf.method_19772());
    }

    public void writeToNetwork(class_2540 buf) {
        buf.method_10814(this.type);
        buf.method_10814(this.identifier);
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.type, this.identifier);
    }
}

