/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.ast;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.StringHolder;
import com.bedrockk.molang.runtime.MoLangEnvironment;
import com.bedrockk.molang.runtime.MoScope;
import com.bedrockk.molang.runtime.struct.VariableStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.ArrayList;

public final class ForEachExpression
extends StringHolder
implements Expression {
    private final Expression variable;
    private final Expression array;
    private final Expression body;

    @Override
    public MoValue evaluate(MoScope scope2, MoLangEnvironment environment) {
        MoValue array = this.array.evaluate(scope2, environment);
        if (array instanceof VariableStruct) {
            VariableStruct struct2 = (VariableStruct)array;
            MoScope scope22 = new MoScope();
            for (MoValue value2 : new ArrayList<MoValue>(struct2.getMap().values())) {
                this.variable.assign(scope22, environment, value2);
                this.body.evaluate(scope22, environment);
                if (scope22.getReturnValue() != null) {
                    return scope22.getReturnValue();
                }
                if (!scope22.isBreak()) continue;
                break;
            }
        }
        return DoubleValue.ZERO;
    }

    public ForEachExpression(Expression variable, Expression array, Expression body) {
        this.variable = variable;
        this.array = array;
        this.body = body;
    }

    public Expression getVariable() {
        return this.variable;
    }

    public Expression getArray() {
        return this.array;
    }

    public Expression getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForEachExpression)) {
            return false;
        }
        ForEachExpression other = (ForEachExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$variable = this.getVariable();
        Expression other$variable = other.getVariable();
        if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
            return false;
        }
        Expression this$array = this.getArray();
        Expression other$array = other.getArray();
        if (this$array == null ? other$array != null : !this$array.equals(other$array)) {
            return false;
        }
        Expression this$body = this.getBody();
        Expression other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForEachExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        Expression $array = this.getArray();
        result = result * 59 + ($array == null ? 43 : $array.hashCode());
        Expression $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "ForEachExpression(variable=" + this.getVariable() + ", array=" + this.getArray() + ", body=" + this.getBody() + ")";
    }
}

