/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.ast;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.StringHolder;
import com.bedrockk.molang.ast.NameExpression;
import com.bedrockk.molang.runtime.MoLangEnvironment;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.MoScope;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FuncCallExpression
extends StringHolder
implements Expression {
    private final Expression name;
    private final Expression[] args;

    @Override
    public MoValue evaluate(MoScope scope2, MoLangEnvironment environment) {
        List<Expression> params = Arrays.asList(this.args);
        ArrayList<String> names = new ArrayList<String>();
        if (this.name instanceof NameExpression) {
            names.addAll(((NameExpression)this.name).getNames());
        } else {
            Collections.addAll(names, this.name.evaluate(scope2, environment).asString().split("\\."));
        }
        ArrayList<MoValue> paramsParsed = new ArrayList<MoValue>(params.size());
        for (Expression param : params) {
            paramsParsed.add(param.evaluate(scope2, environment));
        }
        return environment.getValue(names.iterator(), new MoParams(paramsParsed));
    }

    public FuncCallExpression(Expression name, Expression[] args2) {
        this.name = name;
        this.args = args2;
    }

    public Expression getName() {
        return this.name;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuncCallExpression)) {
            return false;
        }
        FuncCallExpression other = (FuncCallExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$name = this.getName();
        Expression other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FuncCallExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String toString() {
        return "FuncCallExpression(name=" + this.getName() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }
}

