/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.ast;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.StringHolder;
import com.bedrockk.molang.runtime.MoLangEnvironment;
import com.bedrockk.molang.runtime.MoScope;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.Arrays;

public final class StatementExpression
extends StringHolder
implements Expression {
    private final Expression[] expressions;

    @Override
    public MoValue evaluate(MoScope scope2, MoLangEnvironment environment) {
        for (Expression expression : this.expressions) {
            expression.evaluate(scope2, environment);
            if (scope2.getReturnValue() != null) {
                return scope2.getReturnValue();
            }
            if (scope2.isBreak() || scope2.isContinue()) break;
        }
        return DoubleValue.ZERO;
    }

    public StatementExpression(Expression[] expressions) {
        this.expressions = expressions;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatementExpression)) {
            return false;
        }
        StatementExpression other = (StatementExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getExpressions(), other.getExpressions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatementExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getExpressions());
        return result;
    }

    public String toString() {
        return "StatementExpression(expressions=" + Arrays.deepToString(this.getExpressions()) + ")";
    }
}

