/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.advancement.criterion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.criterion.BattleCountableContext;
import com.cobblemon.mod.common.advancement.criterion.CountableCriterionCondition;
import com.cobblemon.mod.common.api.storage.player.PlayerAdvancementData;
import com.cobblemon.mod.common.util.JsonExtensionsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0007R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableCriterionCondition;", "Lcom/cobblemon/mod/common/advancement/criterion/CountableCriterionCondition;", "Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableContext;", "Lcom/google/gson/JsonObject;", "json", "", "fromJson", "(Lcom/google/gson/JsonObject;)V", "Lnet/minecraft/class_3222;", "player", "context", "", "matches", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/advancement/criterion/BattleCountableContext;)Z", "toJson", "", "", "battleTypes", "Ljava/util/List;", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_5258;", "predicate", "<init>", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_5258;)V", "common"})
@SourceDebugExtension(value={"SMAP\nBattleCountableCriterion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleCountableCriterion.kt\ncom/cobblemon/mod/common/advancement/criterion/BattleCountableCriterionCondition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 BattleCountableCriterion.kt\ncom/cobblemon/mod/common/advancement/criterion/BattleCountableCriterionCondition\n*L\n31#1:68,2\n*E\n"})
public final class BattleCountableCriterionCondition
extends CountableCriterionCondition<BattleCountableContext> {
    @NotNull
    private List<String> battleTypes;

    public BattleCountableCriterionCondition(@NotNull class_2960 id, @NotNull class_5258 predicate2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(predicate2, "predicate");
        super(id, predicate2);
        String[] stringArray = new String[]{"any"};
        this.battleTypes = CollectionsKt.mutableListOf(stringArray);
    }

    @Override
    public void fromJson(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        super.fromJson(json);
        if (!json.get("battle_types").isJsonNull()) {
            this.battleTypes.clear();
            List list = json.get("battle_types").getAsJsonArray().asList();
            Intrinsics.checkNotNullExpressionValue(list, "json.get(\"battle_types\").asJsonArray.asList()");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement it = (JsonElement)element$iv;
                boolean bl = false;
                String string = it.getAsString();
                Intrinsics.checkNotNullExpressionValue(string, "it.asString");
                this.battleTypes.add(string);
            }
        }
    }

    @Override
    public void toJson(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        super.toJson(json);
        json.add("battle_types", (JsonElement)JsonExtensionsKt.toJsonArrayString((Collection<String>)this.battleTypes));
    }

    @Override
    public boolean matches(@NotNull class_3222 player, @NotNull BattleCountableContext context) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean typeCheck = false;
        PlayerAdvancementData advancementData = Cobblemon.INSTANCE.getPlayerData().get((class_1657)player).getAdvancementData();
        if (this.battleTypes.isEmpty() || this.battleTypes.contains("any")) {
            typeCheck = true;
        }
        if (this.battleTypes.contains("pvp")) {
            typeCheck = context.getBattle().isPvP();
            context.setTimes(advancementData.getTotalPvPBattleVictoryCount());
        }
        if (this.battleTypes.contains("pvw")) {
            typeCheck = context.getBattle().isPvW();
            context.setTimes(advancementData.getTotalPvWBattleVictoryCount());
        }
        if (this.battleTypes.contains("pvn")) {
            typeCheck = context.getBattle().isPvN();
            context.setTimes(advancementData.getTotalPvWBattleVictoryCount());
        }
        if (this.battleTypes.size() > 1) {
            context.setTimes(advancementData.getTotalBattleVictoryCount());
        }
        return context.getTimes() >= this.getCount() && typeCheck;
    }
}

