/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.drop;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.ItemDropMethod;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b-\u0010.J3\u0010\u000b\u001a\u00020\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u00178\u0016X\u0096D\u00a2\u0006\f\n\u0004\b&\u0010\u0019\u001a\u0004\b'\u0010\u001bR\u001c\u0010)\u001a\u0004\u0018\u00010(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "Lcom/cobblemon/mod/common/api/drop/DropEntry;", "Lnet/minecraft/class_1309;", "entity", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_243;", "pos", "Lnet/minecraft/class_3222;", "player", "", "drop", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_3218;Lnet/minecraft/class_243;Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "dropMethod", "Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "getDropMethod", "()Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "Lnet/minecraft/class_2960;", "item", "Lnet/minecraft/class_2960;", "getItem", "()Lnet/minecraft/class_2960;", "", "maxSelectableTimes", "I", "getMaxSelectableTimes", "()I", "Lnet/minecraft/class_2487;", "nbt", "Lnet/minecraft/class_2487;", "getNbt", "()Lnet/minecraft/class_2487;", "", "percentage", "F", "getPercentage", "()F", "quantity", "getQuantity", "Lkotlin/ranges/IntRange;", "quantityRange", "Lkotlin/ranges/IntRange;", "getQuantityRange", "()Lkotlin/ranges/IntRange;", "<init>", "()V", "common"})
@SourceDebugExtension(value={"SMAP\nItemDropEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemDropEntry.kt\ncom/cobblemon/mod/common/api/drop/ItemDropEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public class ItemDropEntry
implements DropEntry {
    private final float percentage;
    private final int quantity;
    @Nullable
    private final IntRange quantityRange;
    private final int maxSelectableTimes;
    @Nullable
    private final ItemDropMethod dropMethod;
    @NotNull
    private final class_2960 item = new class_2960("minecraft:fish");
    @Nullable
    private final class_2487 nbt;

    public ItemDropEntry() {
        this.percentage = 100.0f;
        this.quantity = 1;
        this.maxSelectableTimes = 1;
    }

    @Override
    public float getPercentage() {
        return this.percentage;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Nullable
    public IntRange getQuantityRange() {
        return this.quantityRange;
    }

    @Override
    public int getMaxSelectableTimes() {
        return this.maxSelectableTimes;
    }

    @Nullable
    public ItemDropMethod getDropMethod() {
        return this.dropMethod;
    }

    @NotNull
    public class_2960 getItem() {
        return this.item;
    }

    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public void drop(@Nullable class_1309 entity2, @NotNull class_3218 world, @NotNull class_243 pos, @Nullable class_3222 player) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        class_1792 class_17922 = (class_1792)world.method_30349().method_30530(class_7924.field_41197).method_10223(this.getItem());
        if (class_17922 == null) {
            Cobblemon.INSTANCE.getLOGGER().error("Unable to load drop item: " + this.getItem());
            return;
        }
        class_1792 item = class_17922;
        IntRange intRange = this.getQuantityRange();
        class_1799 stack = new class_1799((class_1935)item, intRange != null ? RangesKt.random(intRange, (Random)Random.Default) : this.getQuantity());
        boolean inLava = Intrinsics.areEqual(world.method_8320(Vec3ExtensionsKt.toBlockPos(pos)).method_26204(), class_2246.field_10164);
        ItemDropMethod itemDropMethod = this.getDropMethod();
        if (itemDropMethod == null) {
            itemDropMethod = Cobblemon.INSTANCE.getConfig().getDefaultDropItemMethod();
        }
        ItemDropMethod it = itemDropMethod;
        boolean bl = false;
        ItemDropMethod dropMethod = inLava ? ItemDropMethod.TO_INVENTORY : it;
        class_2487 class_24872 = this.getNbt();
        if (class_24872 != null) {
            class_2487 it2 = class_24872;
            boolean bl2 = false;
            stack.method_7980(it2);
        }
        if (dropMethod == ItemDropMethod.ON_PLAYER && player != null) {
            world.method_8649((class_1297)new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), stack));
        } else if (dropMethod == ItemDropMethod.TO_INVENTORY && player != null) {
            class_2561 name = stack.method_7964();
            int count = stack.method_7947();
            boolean succeeded = player.method_7270(stack);
            if (Cobblemon.INSTANCE.getConfig().getAnnounceDropItems()) {
                class_5250 class_52502;
                if (succeeded) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = count;
                    class_5250 class_52503 = name.method_27661();
                    Intrinsics.checkNotNullExpressionValue(class_52503, "name.copy()");
                    objectArray[1] = TextKt.green(class_52503);
                    class_52502 = LocalizationUtilsKt.lang("drop.item.inventory", objectArray);
                } else {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue(name, "name");
                    objectArray[0] = name;
                    class_5250 class_52504 = LocalizationUtilsKt.lang("drop.item.full", objectArray);
                    Intrinsics.checkNotNullExpressionValue(class_52504, "lang(\"drop.item.full\", name)");
                    class_52502 = TextKt.red(class_52504);
                }
                player.method_43496((class_2561)class_52502);
            }
        } else if (dropMethod == ItemDropMethod.ON_ENTITY && entity2 != null) {
            world.method_8649((class_1297)new class_1542(entity2.method_37908(), entity2.method_23317(), entity2.method_23318(), entity2.method_23321(), stack));
        } else {
            world.method_8649((class_1297)new class_1542((class_1937)world, pos.field_1352, pos.field_1351, pos.field_1350, stack));
        }
    }
}

