/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pasture;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.pasture.PastureLink;
import com.cobblemon.mod.common.net.messages.client.pasture.ClosePasturePacket;
import com.cobblemon.mod.common.util.MapExtensionsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014R#\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/cobblemon/mod/common/api/pasture/PastureLinkManager;", "", "Ljava/util/UUID;", "playerId", "Lcom/cobblemon/mod/common/api/pasture/PastureLink;", "link", "", "createLink", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/pasture/PastureLink;)V", "Lnet/minecraft/class_3222;", "player", "getLinkByPlayer", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/pasture/PastureLink;", "getLinkByPlayerId", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/pasture/PastureLink;", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_2338;", "pos", "removeAt", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)V", "", "links", "Ljava/util/Map;", "getLinks", "()Ljava/util/Map;", "<init>", "()V", "common"})
public final class PastureLinkManager {
    @NotNull
    public static final PastureLinkManager INSTANCE = new PastureLinkManager();
    @NotNull
    private static final Map<UUID, PastureLink> links = new LinkedHashMap();

    private PastureLinkManager() {
    }

    @NotNull
    public final Map<UUID, PastureLink> getLinks() {
        return links;
    }

    @Nullable
    public final PastureLink getLinkByPlayerId(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return links.get(playerId);
    }

    public final void createLink(@NotNull UUID playerId, @NotNull PastureLink link) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(link, "link");
        links.put(playerId, link);
    }

    @Nullable
    public final PastureLink getLinkByPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        PastureLink link = this.getLinkByPlayerId(uUID);
        if (!(link == null || Intrinsics.areEqual(link.getDimension(), player.method_37908().method_44013().method_29177()) && link.getPos().method_19769((class_2374)player.method_19538(), 10.0))) {
            links.remove(player.method_5667());
            return null;
        }
        return link;
    }

    public final void removeAt(@NotNull class_3218 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        MapExtensionsKt.removeIf(links, (Function1)new Function1<Map.Entry<? extends UUID, ? extends PastureLink>, Boolean>(world, pos){
            final /* synthetic */ class_3218 $world;
            final /* synthetic */ class_2338 $pos;
            {
                this.$world = $world;
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<UUID, PastureLink> entry) {
                boolean shouldRemove;
                block0: {
                    Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                    UUID uuid2 = entry.getKey();
                    PastureLink pastureLink = entry.getValue();
                    shouldRemove = Intrinsics.areEqual(pastureLink.getDimension(), this.$world.method_44013().method_29177()) && Intrinsics.areEqual(pastureLink.getPos(), this.$pos);
                    class_3222 class_32222 = PlayerExtensionsKt.getPlayer(uuid2);
                    if (class_32222 == null) break block0;
                    CobblemonNetwork.INSTANCE.sendPacket(class_32222, new ClosePasturePacket());
                }
                return shouldRemove;
            }
        });
    }
}

