/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.adapter.conversions;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.adapter.conversions.CobblemonConverter;
import com.cobblemon.mod.common.api.storage.adapter.conversions.ReforgedConversion;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u000f\u0012\u0006\u0010!\u001a\u00020\u001b\u00a2\u0006\u0004\b$\u0010%J5\u0010\t\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u00a2\u0006\u0004\b\t\u0010\nJA\u0010\u0012\u001a\u0004\u0018\u00018\u0001\"\b\b\u0000\u0010\f*\u00020\u000b\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u001d\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion;", "Lcom/cobblemon/mod/common/api/storage/adapter/conversions/CobblemonConverter;", "Lnet/minecraft/class_2487;", "T", "nbt", "", "key", "Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$Translator;", "translator", "find", "(Lnet/minecraft/class_2487;Ljava/lang/String;Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$Translator;)Ljava/lang/Object;", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "E", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Ljava/lang/Class;", "storeClass", "Ljava/util/UUID;", "uuid", "load", "(Ljava/lang/Class;Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "user", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "party", "(Ljava/util/UUID;Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "pc", "(Ljava/util/UUID;Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Ljava/nio/file/Path;", "root", "()Ljava/nio/file/Path;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "translate", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "base", "Ljava/nio/file/Path;", "getBase", "<init>", "(Ljava/nio/file/Path;)V", "ReforgedNatures", "Translator", "common"})
@SourceDebugExtension(value={"SMAP\nReforgedConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReforgedConversion.kt\ncom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1#2:193\n2624#3,3:194\n1855#3,2:197\n1855#3,2:199\n*S KotlinDebug\n*F\n+ 1 ReforgedConversion.kt\ncom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion\n*L\n103#1:194,3\n126#1:197,2\n129#1:199,2\n*E\n"})
public final class ReforgedConversion
implements CobblemonConverter<class_2487> {
    @NotNull
    private final Path base;

    public ReforgedConversion(@NotNull Path base) {
        Intrinsics.checkNotNullParameter(base, "base");
        this.base = base;
    }

    @NotNull
    public final Path getBase() {
        return this.base;
    }

    @Override
    @NotNull
    public Path root() {
        Path path = this.base.resolve("data").resolve("pokemon");
        Intrinsics.checkNotNullExpressionValue(path, "this.base.resolve(\"data\").resolve(\"pokemon\")");
        return path;
    }

    @Override
    @Nullable
    public <E extends StorePosition, T extends PokemonStore<E>> T load(@NotNull Class<T> storeClass, @NotNull UUID uuid2) {
        Intrinsics.checkNotNullParameter(storeClass, "storeClass");
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        String string = storeClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "storeClass.simpleName");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String extension = Intrinsics.areEqual(string2, "playerpartystore") ? "pk" : "comp";
        Path target = this.root().resolve(uuid2 + "." + extension);
        Intrinsics.checkNotNullExpressionValue(target, "target");
        if (!this.exists(target)) {
            return null;
        }
        class_2487 nbt = class_2507.method_10633((File)target.toFile());
        if (nbt != null) {
            PokemonStore pokemonStore = Intrinsics.areEqual(extension, "pk") ? (PokemonStore)this.party(uuid2, nbt) : (PokemonStore)this.pc(uuid2, nbt);
            Intrinsics.checkNotNull(pokemonStore, "null cannot be cast to non-null type T of com.cobblemon.mod.common.api.storage.adapter.conversions.ReforgedConversion.load");
            return (T)pokemonStore;
        }
        return null;
    }

    @Override
    @NotNull
    public PlayerPartyStore party(@NotNull UUID user, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        PlayerPartyStore result = new PlayerPartyStore(user);
        for (int x = 0; x < 6; ++x) {
            String key = "party" + x;
            if (!nbt.method_10545(key)) continue;
            class_2487 class_24872 = nbt.method_10562(key);
            Intrinsics.checkNotNullExpressionValue(class_24872, "nbt.getCompound(key)");
            result.add(this.translate(class_24872));
        }
        return result;
    }

    @Override
    @NotNull
    public PCStore pc(@NotNull UUID user, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        PCStore result = new PCStore(user);
        int box = 0;
        while (nbt.method_10545("BoxNumber" + box)) {
            class_2487 storage2 = nbt.method_10562("BoxNumber" + box);
            for (int x = 0; x < 30; ++x) {
                if (!storage2.method_10545("pc" + x)) continue;
                class_2487 class_24872 = storage2.method_10562("pc" + x);
                Intrinsics.checkNotNullExpressionValue(class_24872, "storage.getCompound(\"pc$x\")");
                Pokemon pokemon = this.translate(class_24872);
                if (result.add(pokemon)) continue;
                result.getBackupStore().add(pokemon);
            }
            ++box;
        }
        result.tryRestoreBackedUpPokemon();
        return result;
    }

    @Override
    @NotNull
    public Pokemon translate(@NotNull class_2487 nbt) {
        PokeBall pokeBall;
        Object element$iv;
        Object object;
        Iterator $this$none$iv;
        boolean bl;
        FormData formData;
        Object v1;
        Object it;
        PokemonProperties.Companion companion;
        Pokemon result;
        block16: {
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            result = new Pokemon();
            result.setUuid(nbt.method_25926("UUID"));
            Species species = PokemonSpecies.getByPokedexNumber$default(PokemonSpecies.INSTANCE, nbt.method_10550("ndex"), null, 2, null);
            if (species == null) {
                throw new IllegalStateException("Failed to read a species with pokedex identifier " + nbt.method_10550("ndex"));
            }
            result.setSpecies(species);
            Iterable iterable = result.getSpecies().getForms();
            companion = PokemonProperties.Companion;
            Iterable iterable2 = iterable;
            for (Object object2 : iterable2) {
                it = (FormData)object2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(((FormData)it).getName(), nbt.method_10558("Variant"))) continue;
                v1 = object2;
                break block16;
            }
            v1 = null;
        }
        if ((formData = (FormData)v1) == null) {
            formData = result.getSpecies().getStandardForm();
        }
        PokemonProperties.Companion.parse$default(companion, formData.getName(), null, null, 6, null).apply(result);
        result.setGender(Gender.values()[nbt.method_10550("Gender")]);
        Boolean bl3 = (Boolean)this.find(nbt, "IsShiny", translate.2.INSTANCE);
        if (bl3 != null) {
            bl = bl3;
        } else {
            String string = (String)this.find(nbt, "palette", translate.3.INSTANCE);
            Boolean bl4 = string != null ? Boolean.valueOf(string.equals("shiny")) : null;
            bl = bl4 != null ? bl4 : false;
        }
        result.setShiny(bl);
        result.setLevel(nbt.method_10550("Level"));
        result.addExperience(new SidemodExperienceSource("Reforged"), nbt.method_10550("EXP"));
        Pokemon.setFriendship$default(result, nbt.method_10550("Friendship"), false, 2, null);
        String string = nbt.method_10558("Ability");
        Intrinsics.checkNotNullExpressionValue(string, "nbt.getString(\"Ability\")");
        AbilityTemplate abilityTemplate = Abilities.INSTANCE.get(string);
        if (abilityTemplate != null) {
            boolean bl5;
            Pokemon bl2;
            block17: {
                Object object2;
                AbilityTemplate template = abilityTemplate;
                boolean bl6 = false;
                object2 = result.getForm().getAbilities();
                it = template;
                bl2 = result;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)((Object)$this$none$iv)).isEmpty()) {
                    bl5 = true;
                } else {
                    object = $this$none$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv2 = object.next();
                        PotentialAbility it2 = (PotentialAbility)element$iv2;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual(it2.getTemplate(), template)) continue;
                        bl5 = false;
                        break block17;
                    }
                    bl5 = true;
                }
            }
            boolean bl8 = bl5;
            bl2.updateAbility(((AbilityTemplate)it).create(bl8));
        }
        String string2 = ReforgedNatures.values()[nbt.method_10550("Nature")].name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        Nature nature = Natures.INSTANCE.getNature(new class_2960(string2));
        if (nature == null) {
            nature = Natures.INSTANCE.getRandomNature();
        }
        result.setNature(nature);
        String string3 = ReforgedNatures.values()[nbt.method_10550("MintNature")].name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        result.setMintedNature(Natures.INSTANCE.getNature(new class_2960(string3)));
        result.setCurrentHealth(nbt.method_10550("Health"));
        IVs ivs = new IVs();
        ivs.set(Stats.HP, nbt.method_10550("IVHP"));
        ivs.set(Stats.ATTACK, nbt.method_10550("IVAttack"));
        ivs.set(Stats.DEFENCE, nbt.method_10550("IVDefense"));
        ivs.set(Stats.SPECIAL_ATTACK, nbt.method_10550("IVSpAtt"));
        ivs.set(Stats.SPECIAL_DEFENCE, nbt.method_10550("IVSpDef"));
        ivs.set(Stats.SPEED, nbt.method_10550("IVSpeed"));
        EVs evs = new EVs();
        evs.set(Stats.HP, nbt.method_10550("EVHP"));
        evs.set(Stats.ATTACK, nbt.method_10550("EVAttack"));
        evs.set(Stats.DEFENCE, nbt.method_10550("EVDefense"));
        evs.set(Stats.SPECIAL_ATTACK, nbt.method_10550("EVSpecialAttack"));
        evs.set(Stats.SPECIAL_DEFENCE, nbt.method_10550("EVSpecialDefense"));
        evs.set(Stats.SPEED, nbt.method_10550("EVSpeed"));
        Object $this$forEach$iv = ivs;
        boolean $i$f$forEach = false;
        $this$none$iv = $this$forEach$iv.iterator();
        while ($this$none$iv.hasNext()) {
            element$iv = $this$none$iv.next();
            Map.Entry stat = (Map.Entry)element$iv;
            boolean bl9 = false;
            result.setIV((Stat)stat.getKey(), ((Number)stat.getValue()).intValue());
        }
        $this$forEach$iv = evs;
        $i$f$forEach = false;
        $this$none$iv = $this$forEach$iv.iterator();
        while ($this$none$iv.hasNext()) {
            element$iv = $this$none$iv.next();
            Map.Entry stat = (Map.Entry)element$iv;
            boolean bl10 = false;
            result.setEV((Stat)stat.getKey(), ((Number)stat.getValue()).intValue());
        }
        for (class_2520 move : nbt.method_10554("Moveset", 10)) {
            Intrinsics.checkNotNull(move, "null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
            class_2487 compound = (class_2487)move;
            String string4 = compound.method_10558("MoveID");
            Intrinsics.checkNotNullExpressionValue(string4, "compound.getString(\"MoveID\")");
            CharSequence stat = string4;
            Regex bl10 = new Regex("[-\\s]", RegexOption.IGNORE_CASE);
            object = "";
            String id = bl10.replace(stat, (String)object);
            int pp = compound.method_10550("MovePP");
            int level = compound.method_10550("MovePPLevel");
            String string5 = id.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            MoveTemplate template = Moves.INSTANCE.getByNameOrDummy(string5);
            result.getMoveSet().add(template.create(pp, level));
        }
        String ball2 = (String)this.find(nbt, "CaughtBall", translate.ball.1.INSTANCE);
        if (ball2 != null) {
            pokeBall = PokeBalls.INSTANCE.getPokeBall(new class_2960(ball2));
            if (pokeBall == null) {
                pokeBall = PokeBalls.INSTANCE.getPOKE_BALL();
            }
        } else {
            pokeBall = PokeBalls.INSTANCE.getPOKE_BALL();
        }
        result.setCaughtBall(pokeBall);
        return result;
    }

    @Nullable
    public final <T> T find(@NotNull class_2487 nbt, @NotNull String key, @NotNull Translator<? extends T> translator) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(translator, "translator");
        if (nbt.method_10545(key)) {
            return translator.from(nbt, key);
        }
        return null;
    }

    @Override
    public boolean exists(@NotNull Path target) {
        return CobblemonConverter.DefaultImpls.exists(this, target);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u001c\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$ReforgedNatures;", "", "<init>", "(Ljava/lang/String;I)V", "HARDY", "SERIOUS", "DOCILE", "BASHFUL", "QUIRKY", "LONELY", "BRAVE", "ADAMANT", "NAUGHTY", "BOLD", "RELAXED", "IMPISH", "LAX", "TIMID", "HASTY", "JOLLY", "NAIVE", "MODEST", "MILD", "QUIET", "RASH", "CALM", "GENTLE", "SASSY", "CAREFUL", "common"})
    public static final class ReforgedNatures
    extends Enum<ReforgedNatures> {
        public static final /* enum */ ReforgedNatures HARDY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures SERIOUS = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures DOCILE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures BASHFUL = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures QUIRKY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures LONELY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures BRAVE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures ADAMANT = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures NAUGHTY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures BOLD = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures RELAXED = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures IMPISH = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures LAX = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures TIMID = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures HASTY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures JOLLY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures NAIVE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures MODEST = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures MILD = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures QUIET = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures RASH = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures CALM = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures GENTLE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures SASSY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures CAREFUL = new ReforgedNatures();
        private static final /* synthetic */ ReforgedNatures[] $VALUES;

        public static ReforgedNatures[] values() {
            return (ReforgedNatures[])$VALUES.clone();
        }

        public static ReforgedNatures valueOf(String value2) {
            return Enum.valueOf(ReforgedNatures.class, value2);
        }

        static {
            $VALUES = reforgedNaturesArray = new ReforgedNatures[]{ReforgedNatures.HARDY, ReforgedNatures.SERIOUS, ReforgedNatures.DOCILE, ReforgedNatures.BASHFUL, ReforgedNatures.QUIRKY, ReforgedNatures.LONELY, ReforgedNatures.BRAVE, ReforgedNatures.ADAMANT, ReforgedNatures.NAUGHTY, ReforgedNatures.BOLD, ReforgedNatures.RELAXED, ReforgedNatures.IMPISH, ReforgedNatures.LAX, ReforgedNatures.TIMID, ReforgedNatures.HASTY, ReforgedNatures.JOLLY, ReforgedNatures.NAIVE, ReforgedNatures.MODEST, ReforgedNatures.MILD, ReforgedNatures.QUIET, ReforgedNatures.RASH, ReforgedNatures.CALM, ReforgedNatures.GENTLE, ReforgedNatures.SASSY, ReforgedNatures.CAREFUL};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00e6\u0080\u0001\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J!\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$Translator;", "R", "", "Lnet/minecraft/class_2487;", "nbt", "", "key", "from", "(Lnet/minecraft/class_2487;Ljava/lang/String;)Ljava/lang/Object;", "common"})
    public static interface Translator<R> {
        @Nullable
        public R from(@NotNull class_2487 var1, @NotNull String var2);
    }
}

