/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.party;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PartyCheckContext;
import com.cobblemon.mod.common.advancement.criterion.PartyCheckCriterion;
import com.cobblemon.mod.common.advancement.criterion.SimpleCriterionTrigger;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.evolution.PassiveEvolution;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.pokemon.OriginalTrainerType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.pokemon.evolution.variants.LevelUpEvolution;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b&\u0010'B\u0019\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\b\b\u0002\u0010(\u001a\u00020\u001e\u00a2\u0006\u0004\b&\u0010)J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "add", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "getOverflowPC", "()Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "", "initialize", "()V", "Lnet/minecraft/class_3222;", "player", "onSecondPassed", "(Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "position", "set", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "position1", "position2", "swap", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "Lnet/minecraft/class_2487;", "shoulderEntity", "isLeft", "validateShoulder", "(Lnet/minecraft/class_2487;Z)Z", "Ljava/util/UUID;", "playerUUID", "Ljava/util/UUID;", "getPlayerUUID", "()Ljava/util/UUID;", "", "secondsSinceFriendshipUpdate", "I", "<init>", "(Ljava/util/UUID;)V", "storageUUID", "(Ljava/util/UUID;Ljava/util/UUID;)V", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerPartyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerPartyStore.kt\ncom/cobblemon/mod/common/api/storage/party/PlayerPartyStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1#2:200\n800#3,11:201\n1855#3,2:212\n1855#3,2:214\n1855#3,2:216\n1855#3,2:218\n1855#3,2:220\n*S KotlinDebug\n*F\n+ 1 PlayerPartyStore.kt\ncom/cobblemon/mod/common/api/storage/party/PlayerPartyStore\n*L\n127#1:201,11\n127#1:212,2\n129#1:214,2\n133#1:216,2\n139#1:218,2\n157#1:220,2\n*E\n"})
public class PlayerPartyStore
extends PartyStore {
    @NotNull
    private final UUID playerUUID;
    private int secondsSinceFriendshipUpdate;

    public PlayerPartyStore(@NotNull UUID playerUUID, @NotNull UUID storageUUID) {
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        Intrinsics.checkNotNullParameter(storageUUID, "storageUUID");
        super(storageUUID);
        this.playerUUID = playerUUID;
    }

    public /* synthetic */ PlayerPartyStore(UUID uUID, UUID uUID2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uUID2 = uUID;
        }
        this(uUID, uUID2);
    }

    @NotNull
    public final UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public PlayerPartyStore(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        this(playerUUID, playerUUID);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getObserverUUIDs().add(this.playerUUID);
    }

    @Nullable
    public PCStore getOverflowPC() {
        return Cobblemon.INSTANCE.getStorage().getPC(this.playerUUID);
    }

    @Override
    public boolean add(@NotNull Pokemon pokemon) {
        boolean bl;
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        if (pokemon.getOriginalTrainerType() == OriginalTrainerType.NONE) {
            pokemon.setOriginalTrainer(this.playerUUID);
        }
        pokemon.refreshOriginalTrainer();
        if (super.add(pokemon)) {
            class_3222 class_32222 = pokemon.getOwnerPlayer();
            if (class_32222 != null) {
                class_3222 it = class_32222;
                boolean bl2 = false;
                CobblemonCriteria.INSTANCE.getPARTY_CHECK().trigger(it, new PartyCheckContext(this));
            }
            bl = true;
        } else {
            class_3222 player = PlayerExtensionsKt.getPlayer(this.playerUUID);
            PCStore pc = this.getOverflowPC();
            if (pc == null || !pc.add(pokemon)) {
                if (pc == null) {
                    class_3222 class_32223 = player;
                    if (class_32223 != null) {
                        class_32223.method_43496((class_2561)LocalizationUtilsKt.lang("overflow_no_pc", new Object[0]));
                    }
                } else {
                    class_3222 class_32224 = player;
                    if (class_32224 != null) {
                        Object[] objectArray = new Object[]{pc.getName()};
                        class_32224.method_43496((class_2561)LocalizationUtilsKt.lang("overflow_no_space", objectArray));
                    }
                }
                bl = false;
            } else {
                class_3222 class_32225 = player;
                if (class_32225 != null) {
                    Object[] objectArray = new Object[]{pokemon.getSpecies().getTranslatedName(), pc.getName()};
                    class_32225.method_43496((class_2561)LocalizationUtilsKt.lang("overflow_to_pc", objectArray));
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void onSecondPassed(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player) == null) {
            Random.Default random = Random.Default;
            for (Pokemon pokemon : this) {
                Evolution it;
                void $this$forEach$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Object status;
                if (pokemon.isFainted()) {
                    pokemon.setFaintedTimer(pokemon.getFaintedTimer() - 1);
                    if (pokemon.getFaintedTimer() <= -1) {
                        float php = (float)Math.ceil((float)pokemon.getHp() * Cobblemon.INSTANCE.getConfig().getFaintAwakenHealthPercent());
                        pokemon.setCurrentHealth((int)php);
                        Object[] objectArray = new Object[]{pokemon.getDisplayName()};
                        player.method_43496((class_2561)class_2561.method_43469((String)"cobblemon.party.faintRecover", (Object[])objectArray));
                    }
                } else if (pokemon.getCurrentHealth() < pokemon.getHp()) {
                    int php = pokemon.getHealTimer();
                    pokemon.setHealTimer(php + -1);
                    if (pokemon.getHealTimer() <= -1) {
                        pokemon.setHealTimer(Cobblemon.INSTANCE.getConfig().getHealTimer());
                        double healAmount = RangesKt.coerceAtLeast(1.0, (double)pokemon.getHp() * Cobblemon.INSTANCE.getConfig().getHealPercent());
                        pokemon.setCurrentHealth(pokemon.getCurrentHealth() + (int)Math.rint(healAmount));
                    }
                }
                if ((status = pokemon.getStatus()) != null && !player.method_6113()) {
                    if (((PersistentStatusContainer)status).isExpired()) {
                        ((PersistentStatusContainer)status).getStatus().onStatusExpire(player, pokemon, random);
                        pokemon.setStatus(null);
                    } else {
                        ((PersistentStatusContainer)status).getStatus().onSecondPassed(player, pokemon, random);
                        ((PersistentStatusContainer)status).tickTimer();
                    }
                }
                Iterable $this$filterIsInstance$iv = pokemon.getLockedEvolutions();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof PassiveEvolution)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                $this$filterIsInstanceTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    Object element$iv = $this$filterIsInstanceTo$iv$iv.next();
                    PassiveEvolution it2 = (PassiveEvolution)element$iv;
                    boolean bl = false;
                    it2.attemptEvolution(pokemon);
                }
                List removeList = new ArrayList();
                Iterable $this$forEach$iv2 = pokemon.getEvolutionProxy().server();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (Evolution)element$iv;
                    boolean bl = false;
                    if (it.test(pokemon) || !(it instanceof LevelUpEvolution) || ((LevelUpEvolution)it).getPermanent()) continue;
                    removeList.add(it);
                }
                $this$forEach$iv2 = removeList;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (Evolution)element$iv;
                    boolean bl = false;
                    pokemon.getEvolutionProxy().server().remove(it);
                }
            }
            ++this.secondsSinceFriendshipUpdate;
            if (this.secondsSinceFriendshipUpdate == 120) {
                this.secondsSinceFriendshipUpdate = 0;
                Iterable $this$forEach$iv = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pokemon pokemon = (Pokemon)element$iv;
                    boolean bl = false;
                    if (pokemon.getFriendship() >= 160 || pokemon.getEntity() == null && !(pokemon.getState() instanceof ShoulderedState)) continue;
                    Pokemon.incrementFriendship$default(pokemon, 1, false, 2, null);
                }
            }
        }
        class_2487 class_24872 = player.method_7356();
        Intrinsics.checkNotNullExpressionValue(class_24872, "player.shoulderEntityLeft");
        if (CompoundTagExtensionsKt.isPokemonEntity(class_24872)) {
            class_2487 class_24873 = player.method_7356();
            Intrinsics.checkNotNullExpressionValue(class_24873, "player.shoulderEntityLeft");
            if (!this.validateShoulder(class_24873, true)) {
                player.method_7296(player.method_7356());
            }
        }
        class_2487 class_24874 = player.method_7308();
        Intrinsics.checkNotNullExpressionValue(class_24874, "player.shoulderEntityRight");
        if (CompoundTagExtensionsKt.isPokemonEntity(class_24874)) {
            class_2487 class_24875 = player.method_7308();
            Intrinsics.checkNotNullExpressionValue(class_24875, "player.shoulderEntityRight");
            if (!this.validateShoulder(class_24875, false)) {
                player.method_7296(player.method_7308());
            }
        }
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            PokemonState state = it.getState();
            if (!(state instanceof ShoulderedState) || ((ShoulderedState)state).isStillShouldered(player)) continue;
            it.recall();
        }
    }

    public final boolean validateShoulder(@NotNull class_2487 shoulderEntity, boolean isLeft) {
        block6: {
            block5: {
                Object v0;
                Object object;
                block4: {
                    Intrinsics.checkNotNullParameter(shoulderEntity, "shoulderEntity");
                    object = this;
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        Pokemon it = (Pokemon)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getUuid(), shoulderEntity.method_10562("Pokemon").method_25926("UUID"))) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                Pokemon pokemon = v0;
                if (pokemon == null) break block5;
                object = pokemon.getState();
                ShoulderedState shoulderedState = object instanceof ShoulderedState ? (ShoulderedState)object : null;
                if (shoulderedState != null ? shoulderedState.isLeftShoulder() == isLeft : false) break block6;
            }
            return false;
        }
        return true;
    }

    @Override
    public void swap(@NotNull PartyPosition position1, @NotNull PartyPosition position2) {
        Intrinsics.checkNotNullParameter(position1, "position1");
        Intrinsics.checkNotNullParameter(position2, "position2");
        super.swap(position1, position2);
        Pokemon pokemon1 = this.get(position1);
        Pokemon pokemon2 = this.get(position2);
        if (pokemon1 != null && pokemon2 != null) {
            class_3222 player = pokemon1.getOwnerPlayer();
            if (player != null) {
                CobblemonCriteria.INSTANCE.getPARTY_CHECK().trigger(player, new PartyCheckContext(this));
            }
        } else if (pokemon1 != null || pokemon2 != null) {
            class_3222 player;
            Pokemon pokemon = pokemon1;
            Object object = player = pokemon != null ? pokemon.getOwnerPlayer() : null;
            if (player != null) {
                CobblemonCriteria.INSTANCE.getPARTY_CHECK().trigger(player, new PartyCheckContext(this));
            } else {
                Pokemon pokemon3 = pokemon2;
                Intrinsics.checkNotNull(pokemon3);
                player = pokemon3.getOwnerPlayer();
                SimpleCriterionTrigger<PartyCheckContext, PartyCheckCriterion> simpleCriterionTrigger = CobblemonCriteria.INSTANCE.getPARTY_CHECK();
                class_3222 class_32222 = player;
                Intrinsics.checkNotNull(class_32222);
                simpleCriterionTrigger.trigger(class_32222, new PartyCheckContext(this));
            }
        }
    }

    @Override
    public void set(@NotNull PartyPosition position, @NotNull Pokemon pokemon) {
        block0: {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(pokemon, "pokemon");
            super.set(position, pokemon);
            class_3222 class_32222 = pokemon.getOwnerPlayer();
            if (class_32222 == null) break block0;
            class_3222 it = class_32222;
            boolean bl = false;
            CobblemonCriteria.INSTANCE.getPARTY_CHECK().trigger(it, new PartyCheckContext(this));
        }
    }
}

