/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/battles/InsufficientPokemonError;", "Lcom/cobblemon/mod/common/battles/BattleStartError;", "Lnet/minecraft/class_1297;", "entity", "Lnet/minecraft/class_5250;", "getMessageFor", "(Lnet/minecraft/class_1297;)Lnet/minecraft/class_5250;", "", "hadCount", "I", "getHadCount", "()I", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_3222;", "getPlayer", "()Lnet/minecraft/class_3222;", "requiredCount", "getRequiredCount", "<init>", "(Lnet/minecraft/class_3222;II)V", "common"})
public final class InsufficientPokemonError
implements BattleStartError {
    @NotNull
    private final class_3222 player;
    private final int requiredCount;
    private final int hadCount;

    public InsufficientPokemonError(@NotNull class_3222 player, int requiredCount, int hadCount) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.requiredCount = requiredCount;
        this.hadCount = hadCount;
    }

    @NotNull
    public final class_3222 getPlayer() {
        return this.player;
    }

    public final int getRequiredCount() {
        return this.requiredCount;
    }

    public final int getHadCount() {
        return this.hadCount;
    }

    @Override
    @NotNull
    public class_5250 getMessageFor(@NotNull class_1297 entity2) {
        class_5250 class_52502;
        Intrinsics.checkNotNullParameter(entity2, "entity");
        if (Intrinsics.areEqual(this.player, entity2)) {
            String key = this.hadCount == 0 ? "no_pokemon" : "insufficient_pokemon.personal";
            Object[] objectArray = new Object[]{this.requiredCount, this.hadCount};
            class_5250 class_52503 = LocalizationUtilsKt.battleLang("error." + key, objectArray);
            class_52502 = class_52503;
            Intrinsics.checkNotNullExpressionValue(class_52503, "{\n            val key = \u2026t\n            )\n        }");
        } else {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue(this.player.method_5476(), "player.displayName");
            objectArray[1] = this.requiredCount;
            objectArray[2] = this.hadCount;
            class_5250 class_52504 = LocalizationUtilsKt.battleLang("error.insufficient_pokemon", objectArray);
            Intrinsics.checkNotNullExpressionValue(class_52504, "{\n            battleLang\u2026t\n            )\n        }");
            class_52502 = class_52504;
        }
        return class_52502;
    }
}

